/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file.transformers;

import java.io.File;
import java.io.UnsupportedEncodingException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.file.transformers.FileToByteArray;

public class FileToString
extends FileToByteArray {
    public FileToString() {
        this.registerSourceType(DataTypeFactory.create(File.class));
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.setReturnDataType(DataTypeFactory.STRING);
    }

    @Override
    public Object doTransform(Object src, String encoding) throws TransformerException {
        byte[] bytes = src instanceof byte[] ? (byte[])src : (byte[])super.doTransform(src, encoding);
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new TransformerException((Transformer)this, (Throwable)uee);
        }
    }
}

