/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;

public class HashSessionManager
extends AbstractSessionManager {
    private static int __id;
    private Timer _timer;
    private TimerTask _task;
    private int _scavengePeriodMs = 30000;
    private int _savePeriodMs = 0;
    private int _idleSavePeriodMs = 0;
    private TimerTask _saveTask;
    protected ConcurrentMap<String, HashedSession> _sessions;
    private File _storeDir;
    private boolean _lazyLoad = false;
    private volatile boolean _sessionsLoaded = false;

    public void doStart() throws Exception {
        this._sessions = new ConcurrentHashMap<String, HashedSession>();
        super.doStart();
        this._timer = new Timer("HashSessionScavenger-" + __id++, true);
        this.setScavengePeriod(this.getScavengePeriod());
        if (this._storeDir != null) {
            if (!this._storeDir.exists()) {
                this._storeDir.mkdirs();
            }
            if (!this._lazyLoad) {
                this.restoreSessions();
            }
        }
        this.setSavePeriod(this.getSavePeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws Exception {
        if (this._storeDir != null) {
            this.saveSessions();
        }
        super.doStop();
        this._sessions.clear();
        this._sessions = null;
        HashSessionManager hashSessionManager = this;
        synchronized (hashSessionManager) {
            if (this._saveTask != null) {
                this._saveTask.cancel();
            }
            this._saveTask = null;
            if (this._task != null) {
                this._task.cancel();
            }
            this._task = null;
            if (this._timer != null) {
                this._timer.cancel();
            }
            this._timer = null;
        }
    }

    public int getScavengePeriod() {
        return this._scavengePeriodMs / 1000;
    }

    public Map getSessionMap() {
        return Collections.unmodifiableMap(this._sessions);
    }

    public int getSessions() {
        int sessions = super.getSessions();
        if (Log.isDebugEnabled() && this._sessions.size() != sessions) {
            Log.warn("sessions: " + this._sessions.size() + "!=" + sessions);
        }
        return sessions;
    }

    public int getIdleSavePeriod() {
        if (this._idleSavePeriodMs <= 0) {
            return 0;
        }
        return this._idleSavePeriodMs;
    }

    public void setIdleSavePeriod(int seconds) {
        this._idleSavePeriodMs = seconds * 1000;
    }

    public void setMaxInactiveInterval(int seconds) {
        super.setMaxInactiveInterval(seconds);
        if (this._dftMaxIdleSecs > 0 && this._scavengePeriodMs > this._dftMaxIdleSecs * 1000) {
            this.setScavengePeriod((this._dftMaxIdleSecs + 9) / 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSavePeriod(int seconds) {
        int period = seconds * 1000;
        if (period < 0) {
            period = 0;
        }
        this._savePeriodMs = period;
        if (this._timer != null) {
            HashSessionManager hashSessionManager = this;
            synchronized (hashSessionManager) {
                if (this._saveTask != null) {
                    this._saveTask.cancel();
                }
                if (this._savePeriodMs > 0 && this._storeDir != null) {
                    this._saveTask = new TimerTask(){

                        public void run() {
                            try {
                                HashSessionManager.this.saveSessions();
                            }
                            catch (Exception e) {
                                Log.warn(e);
                            }
                        }
                    };
                    this._timer.schedule(this._saveTask, this._savePeriodMs, (long)this._savePeriodMs);
                }
            }
        }
    }

    public int getSavePeriod() {
        if (this._savePeriodMs <= 0) {
            return 0;
        }
        return this._savePeriodMs / 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengePeriod(int seconds) {
        if (seconds == 0) {
            seconds = 60;
        }
        int old_period = this._scavengePeriodMs;
        int period = seconds * 1000;
        if (period > 60000) {
            period = 60000;
        }
        if (period < 1000) {
            period = 1000;
        }
        this._scavengePeriodMs = period;
        if (this._timer != null && (period != old_period || this._task == null)) {
            HashSessionManager hashSessionManager = this;
            synchronized (hashSessionManager) {
                if (this._task != null) {
                    this._task.cancel();
                }
                this._task = new TimerTask(){

                    public void run() {
                        HashSessionManager.this.scavenge();
                    }
                };
                this._timer.schedule(this._task, this._scavengePeriodMs, (long)this._scavengePeriodMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scavenge() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader old_loader = thread.getContextClassLoader();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            try {
                if (!this._sessionsLoaded && this._lazyLoad) {
                    this.restoreSessions();
                }
            }
            catch (Exception e) {
                Log.debug(e);
            }
            long now = System.currentTimeMillis();
            for (HashedSession session : this._sessions.values()) {
                long idleTime = session._maxIdleMs;
                if (idleTime > 0L && session._accessed + idleTime < now) {
                    session.timeout();
                    continue;
                }
                if (this._idleSavePeriodMs <= 0 || session._accessed + (long)this._idleSavePeriodMs >= now) continue;
                session.idle();
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            Log.warn("Problem scavenging sessions", t);
        }
        finally {
            thread.setContextClassLoader(old_loader);
        }
    }

    protected void addSession(AbstractSessionManager.Session session) {
        if (this.isRunning()) {
            this._sessions.put(session.getClusterId(), (HashedSession)session);
        }
    }

    public AbstractSessionManager.Session getSession(String idInCluster) {
        ConcurrentMap<String, HashedSession> sessions;
        if (this._lazyLoad && !this._sessionsLoaded) {
            try {
                this.restoreSessions();
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
        if ((sessions = this._sessions) == null) {
            return null;
        }
        HashedSession session = (HashedSession)sessions.get(idInCluster);
        if (session == null) {
            return null;
        }
        if (this._idleSavePeriodMs != 0) {
            session.deIdle();
        }
        return session;
    }

    protected void invalidateSessions() {
        ArrayList sessions = new ArrayList(this._sessions.values());
        for (HashedSession session : sessions) {
            session.invalidate();
        }
        this._sessions.clear();
    }

    protected AbstractSessionManager.Session newSession(HttpServletRequest request) {
        return new HashedSession(request);
    }

    protected AbstractSessionManager.Session newSession(long created, long accessed, String clusterId) {
        return new HashedSession(created, accessed, clusterId);
    }

    protected boolean removeSession(String clusterId) {
        return this._sessions.remove(clusterId) != null;
    }

    public void setStoreDirectory(File dir) {
        this._storeDir = dir;
    }

    public File getStoreDirectory() {
        return this._storeDir;
    }

    public void setLazyLoad(boolean lazyLoad) {
        this._lazyLoad = lazyLoad;
    }

    public boolean isLazyLoad() {
        return this._lazyLoad;
    }

    public void restoreSessions() throws Exception {
        this._sessionsLoaded = true;
        if (this._storeDir == null || !this._storeDir.exists()) {
            return;
        }
        if (!this._storeDir.canRead()) {
            Log.warn("Unable to restore Sessions: Cannot read from Session storage directory " + this._storeDir.getAbsolutePath());
            return;
        }
        File[] files = this._storeDir.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            try {
                FileInputStream in = new FileInputStream(files[i]);
                HashedSession session = this.restoreSession(in, null);
                in.close();
                this.addSession(session, false);
                session.didActivate();
                files[i].delete();
                continue;
            }
            catch (Exception e) {
                Log.warn("Problem restoring session " + files[i].getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSessions() throws Exception {
        if (this._storeDir == null || !this._storeDir.exists()) {
            return;
        }
        if (!this._storeDir.canWrite()) {
            Log.warn("Unable to save Sessions: Session persistence storage directory " + this._storeDir.getAbsolutePath() + " is not writeable");
            return;
        }
        for (Map.Entry entry : this._sessions.entrySet()) {
            HashedSession session;
            String id = (String)entry.getKey();
            HashedSession hashedSession = session = (HashedSession)entry.getValue();
            synchronized (hashedSession) {
                block10: {
                    if (!session.isIdled() && !session.isSaveFailed()) {
                        File file = null;
                        FileOutputStream fos = null;
                        try {
                            file = new File(this._storeDir, id);
                            if (file.exists()) {
                                file.delete();
                            }
                            file.createNewFile();
                            fos = new FileOutputStream(file);
                            session.willPassivate();
                            session.save(fos);
                            session.didActivate();
                            fos.close();
                        }
                        catch (Exception e) {
                            session.saveFailed();
                            Log.warn("Problem persisting session " + id, e);
                            if (fos == null) break block10;
                            IO.close(fos);
                            file.delete();
                        }
                    }
                }
            }
        }
    }

    public HashedSession restoreSession(InputStream is, HashedSession session) throws Exception {
        DataInputStream in = new DataInputStream(is);
        String clusterId = in.readUTF();
        String nodeId = in.readUTF();
        boolean idChanged = in.readBoolean();
        long created = in.readLong();
        long cookieSet = in.readLong();
        long accessed = in.readLong();
        long lastAccessed = in.readLong();
        int requests = in.readInt();
        if (session == null) {
            session = (HashedSession)this.newSession(created, System.currentTimeMillis(), clusterId);
        }
        session._cookieSet = cookieSet;
        session._lastAccessed = lastAccessed;
        int size = in.readInt();
        if (size > 0) {
            ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream(in);
            for (int i = 0; i < size; ++i) {
                String key = ois.readUTF();
                Object value = ois.readObject();
                session.setAttribute(key, value);
            }
            ois.close();
        } else {
            in.close();
        }
        return session;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClassLoadingObjectInputStream
    extends ObjectInputStream {
        public ClassLoadingObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        public ClassLoadingObjectInputStream() throws IOException {
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass cl) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(cl.getName(), false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                return super.resolveClass(cl);
            }
        }
    }

    protected class HashedSession
    extends AbstractSessionManager.Session {
        private static final long serialVersionUID = -2134521374206116367L;
        private transient boolean _idled;
        private transient boolean _saveFailed;

        protected HashedSession(HttpServletRequest request) {
            super(request);
            this._idled = false;
            this._saveFailed = false;
        }

        protected HashedSession(long created, long accessed, String clusterId) {
            super(created, accessed, clusterId);
            this._idled = false;
            this._saveFailed = false;
        }

        protected boolean isNotAvailable() {
            if (HashSessionManager.this._idleSavePeriodMs != 0) {
                this.deIdle();
            }
            return this._invalid;
        }

        public void setMaxInactiveInterval(int secs) {
            super.setMaxInactiveInterval(secs);
            if (this._maxIdleMs > 0L && this._maxIdleMs / 10L < (long)HashSessionManager.this._scavengePeriodMs) {
                HashSessionManager.this.setScavengePeriod((secs + 9) / 10);
            }
        }

        public void invalidate() throws IllegalStateException {
            if (HashSessionManager.this.isRunning()) {
                super.invalidate();
                this.remove();
            }
        }

        public void remove() {
            String id = this.getId();
            if (id == null) {
                return;
            }
            if (HashSessionManager.this.isStopping() || HashSessionManager.this.isStopped()) {
                return;
            }
            if (HashSessionManager.this._storeDir == null || !HashSessionManager.this._storeDir.exists()) {
                return;
            }
            File f = new File(HashSessionManager.this._storeDir, id);
            f.delete();
        }

        public synchronized void save(OutputStream os) throws IOException {
            DataOutputStream out = new DataOutputStream(os);
            out.writeUTF(this._clusterId);
            out.writeUTF(this._nodeId);
            out.writeBoolean(this._idChanged);
            out.writeLong(this._created);
            out.writeLong(this._cookieSet);
            out.writeLong(this._accessed);
            out.writeLong(this._lastAccessed);
            out.writeInt(this._requests);
            if (this._attributes != null) {
                out.writeInt(this._attributes.size());
                ObjectOutputStream oos = new ObjectOutputStream(out);
                for (Map.Entry entry : this._attributes.entrySet()) {
                    oos.writeUTF((String)entry.getKey());
                    oos.writeObject(entry.getValue());
                }
                oos.close();
            } else {
                out.writeInt(0);
                out.close();
            }
        }

        public synchronized void deIdle() {
            if (this.isIdled()) {
                this.access(System.currentTimeMillis());
                if (Log.isDebugEnabled()) {
                    Log.debug("Deidling " + super.getId());
                }
                FileInputStream fis = null;
                try {
                    File file = new File(HashSessionManager.this._storeDir, super.getId());
                    if (!file.exists() || !file.canRead()) {
                        throw new FileNotFoundException(file.getName());
                    }
                    fis = new FileInputStream(file);
                    HashSessionManager.this.restoreSession(fis, this);
                    this._idled = false;
                    this.didActivate();
                    if (HashSessionManager.this._savePeriodMs == 0) {
                        file.delete();
                    }
                }
                catch (Exception e) {
                    Log.warn("Problem deidling session " + super.getId(), e);
                    IO.close(fis);
                    this.invalidate();
                }
            }
        }

        public synchronized void idle() {
            block5: {
                if (!this.isIdled() && !this._saveFailed) {
                    if (Log.isDebugEnabled()) {
                        Log.debug("Idling " + super.getId());
                    }
                    File file = null;
                    FileOutputStream fos = null;
                    try {
                        file = new File(HashSessionManager.this._storeDir, super.getId());
                        if (file.exists()) {
                            file.delete();
                        }
                        file.createNewFile();
                        fos = new FileOutputStream(file);
                        this.willPassivate();
                        this.save(fos);
                        this._attributes.clear();
                        this._idled = true;
                    }
                    catch (Exception e) {
                        this.saveFailed();
                        Log.warn("Problem idling session " + super.getId(), e);
                        if (fos == null) break block5;
                        IO.close(fos);
                        file.delete();
                        this._idled = false;
                    }
                }
            }
        }

        public boolean isIdled() {
            return this._idled;
        }

        public boolean isSaveFailed() {
            return this._saveFailed;
        }

        public void saveFailed() {
            this._saveFailed = true;
        }
    }
}

