/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.nio.AbstractNIOConnector;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;

public class SelectChannelConnector
extends AbstractNIOConnector {
    protected ServerSocketChannel _acceptChannel;
    private int _lowResourcesConnections;
    private int _lowResourcesMaxIdleTime;
    private int _localPort = -1;
    private final SelectorManager _manager = new ConnectorSelectorManager();

    public SelectChannelConnector() {
        this._manager.setMaxIdleTime(this.getMaxIdleTime());
    }

    public void accept(int acceptorID) throws IOException {
        this._manager.doSelect(acceptorID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._manager.isRunning()) {
                try {
                    this._manager.stop();
                }
                catch (Exception e) {
                    Log.warn(e);
                }
            }
            if (this._acceptChannel != null) {
                this._acceptChannel.close();
            }
            this._acceptChannel = null;
            this._localPort = -2;
        }
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        SelectChannelEndPoint cep = (SelectChannelEndPoint)endpoint;
        cep.cancelIdle();
        request.setTimeStamp(cep.getSelectSet().getNow());
        endpoint.setMaxIdleTime(this._maxIdleTime);
        super.customize(endpoint, request);
    }

    public void persist(EndPoint endpoint) throws IOException {
        ((SelectChannelEndPoint)endpoint).scheduleIdle();
        super.persist(endpoint);
    }

    public Object getConnection() {
        return this._acceptChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocalPort() {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            return this._localPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._acceptChannel == null) {
                this._acceptChannel = ServerSocketChannel.open();
                this._acceptChannel.configureBlocking(true);
                this._acceptChannel.socket().setReuseAddress(this.getReuseAddress());
                InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
                this._acceptChannel.socket().bind(addr, this.getAcceptQueueSize());
                this._localPort = this._acceptChannel.socket().getLocalPort();
                if (this._localPort <= 0) {
                    throw new IOException("Server channel not bound");
                }
            }
        }
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._manager.setMaxIdleTime(maxIdleTime);
        super.setMaxIdleTime(maxIdleTime);
    }

    public int getLowResourcesConnections() {
        return this._lowResourcesConnections;
    }

    public void setLowResourcesConnections(int lowResourcesConnections) {
        this._lowResourcesConnections = lowResourcesConnections;
    }

    public int getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(int lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = lowResourcesMaxIdleTime;
        super.setLowResourcesMaxIdleTime(lowResourcesMaxIdleTime);
    }

    protected void doStart() throws Exception {
        this._manager.setSelectSets(this.getAcceptors());
        this._manager.setMaxIdleTime(this.getMaxIdleTime());
        this._manager.setLowResourcesConnections(this.getLowResourcesConnections());
        this._manager.setLowResourcesMaxIdleTime(this.getLowResourcesMaxIdleTime());
        this._manager.start();
        super.doStart();
        this._manager.dispatch(new Runnable(){

            public void run() {
                ServerSocketChannel server = SelectChannelConnector.this._acceptChannel;
                while (SelectChannelConnector.this.isRunning() && SelectChannelConnector.this._acceptChannel == server && server.isOpen()) {
                    try {
                        SocketChannel channel = server.accept();
                        channel.configureBlocking(false);
                        Socket socket = channel.socket();
                        SelectChannelConnector.this.configure(socket);
                        SelectChannelConnector.this._manager.register(channel);
                    }
                    catch (IOException e) {
                        Log.ignore(e);
                    }
                }
            }
        });
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
        return new SelectChannelEndPoint(channel, selectSet, key, this._maxIdleTime);
    }

    protected Connection newConnection(SocketChannel channel, final SelectChannelEndPoint endpoint) {
        return new HttpConnection(this, endpoint, this.getServer()){

            public void cancelTimeout(Timeout.Task task) {
                endpoint.getSelectSet().cancelTimeout(task);
            }

            public void scheduleTimeout(Timeout.Task task, long timeoutMs) {
                endpoint.getSelectSet().scheduleTimeout(task, timeoutMs);
            }
        };
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append(String.valueOf(this)).append("\n");
        AggregateLifeCycle.dump(out, indent, Arrays.asList(this._acceptChannel, this._acceptChannel.isOpen() ? "OPEN" : "CLOSED", this._manager));
    }

    private final class ConnectorSelectorManager
    extends SelectorManager {
        private ConnectorSelectorManager() {
        }

        public boolean dispatch(Runnable task) {
            return SelectChannelConnector.this.getThreadPool().dispatch(task);
        }

        protected void endPointClosed(SelectChannelEndPoint endpoint) {
            SelectChannelConnector.this.connectionClosed(endpoint.getConnection());
        }

        protected void endPointOpened(SelectChannelEndPoint endpoint) {
            SelectChannelConnector.this.connectionOpened(endpoint.getConnection());
        }

        protected void endPointUpgraded(ConnectedEndPoint endpoint, Connection oldConnection) {
            SelectChannelConnector.this.connectionUpgraded(oldConnection, endpoint.getConnection());
        }

        protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
            return SelectChannelConnector.this.newConnection(channel, endpoint);
        }

        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey sKey) throws IOException {
            return SelectChannelConnector.this.newEndPoint(channel, selectSet, sKey);
        }
    }
}

