/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;

abstract class AbstractWriteSearchIndexOperation
implements WriteOperation<Void> {
    private final MongoNamespace namespace;

    AbstractWriteSearchIndexOperation(MongoNamespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return SyncOperationHelper.withConnection(binding, connection -> {
            try {
                SyncOperationHelper.executeCommand(binding, this.namespace.getDatabaseName(), this.buildCommand(), connection, SyncOperationHelper.writeConcernErrorTransformer(binding.getOperationContext().getTimeoutContext()));
            }
            catch (MongoCommandException mongoCommandException) {
                this.swallowOrThrow(mongoCommandException);
            }
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        AsyncOperationHelper.withAsyncSourceAndConnection(binding::getWriteConnectionSource, false, callback, (connectionSource, connection, cb) -> AsyncOperationHelper.executeCommandAsync(binding, this.namespace.getDatabaseName(), this.buildCommand(), connection, AsyncOperationHelper.writeConcernErrorTransformerAsync(binding.getOperationContext().getTimeoutContext()), (result, commandExecutionError) -> {
            try {
                this.swallowOrThrow(commandExecutionError);
                cb.onResult(result, null);
            }
            catch (Throwable mongoCommandException) {
                cb.onResult(null, mongoCommandException);
            }
        }));
    }

    <E extends Throwable> void swallowOrThrow(@Nullable E mongoExecutionException) throws E {
        if (mongoExecutionException != null) {
            throw mongoExecutionException;
        }
    }

    abstract BsonDocument buildCommand();

    MongoNamespace getNamespace() {
        return this.namespace;
    }
}

