/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source.selector;

import java.util.ArrayList;
import java.util.List;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.ParameterBinding;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.selector.MethodSelector;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;
import org.mapstruct.ap.internal.util.Collections;

public class TypeSelector
implements MethodSelector {
    private TypeFactory typeFactory;

    public TypeSelector(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    @Override
    public <T extends Method> List<SelectedMethod<T>> getMatchingMethods(Method mappingMethod, List<SelectedMethod<T>> methods, List<Type> sourceTypes, Type targetType, SelectionCriteria criteria) {
        if (methods.isEmpty()) {
            return methods;
        }
        ArrayList<SelectedMethod<T>> result = new ArrayList<SelectedMethod<T>>();
        List<ParameterBinding> availableBindings = sourceTypes.isEmpty() ? this.getAvailableParameterBindingsFromMethod(mappingMethod, targetType) : this.getAvailableParameterBindingsFromSourceTypes(sourceTypes, targetType, mappingMethod);
        for (SelectedMethod<T> method : methods) {
            SelectedMethod<T> matchingMethod;
            List<List<ParameterBinding>> parameterBindingPermutations = TypeSelector.getCandidateParameterBindingPermutations(availableBindings, method.getMethod().getParameters());
            if (parameterBindingPermutations == null || (matchingMethod = this.getFirstMatchingParameterBinding(targetType, method, parameterBindingPermutations)) == null) continue;
            result.add(matchingMethod);
        }
        return result;
    }

    private List<ParameterBinding> getAvailableParameterBindingsFromMethod(Method method, Type targetType) {
        ArrayList<ParameterBinding> availableParams = new ArrayList<ParameterBinding>(method.getParameters().size() + 2);
        availableParams.addAll(ParameterBinding.fromParameters(method.getParameters()));
        this.addMappingTargetAndTargetTypeBindings(availableParams, targetType);
        return availableParams;
    }

    private List<ParameterBinding> getAvailableParameterBindingsFromSourceTypes(List<Type> sourceTypes, Type targetType, Method mappingMethod) {
        ArrayList<ParameterBinding> availableParams = new ArrayList<ParameterBinding>(sourceTypes.size() + 2);
        this.addMappingTargetAndTargetTypeBindings(availableParams, targetType);
        for (Type sourceType : sourceTypes) {
            availableParams.add(ParameterBinding.forSourceTypeBinding(sourceType));
        }
        for (Parameter param : mappingMethod.getParameters()) {
            if (!param.isMappingContext()) continue;
            availableParams.add(ParameterBinding.fromParameter(param));
        }
        return availableParams;
    }

    private void addMappingTargetAndTargetTypeBindings(List<ParameterBinding> availableParams, Type targetType) {
        availableParams.add(ParameterBinding.forMappingTargetBinding(targetType));
        availableParams.add(ParameterBinding.forTargetTypeBinding(this.typeFactory.classTypeOf(targetType)));
    }

    private <T extends Method> SelectedMethod<T> getFirstMatchingParameterBinding(Type targetType, SelectedMethod<T> method, List<List<ParameterBinding>> parameterAssignmentVariants) {
        for (List<ParameterBinding> parameterAssignments : parameterAssignmentVariants) {
            if (!method.getMethod().matches(TypeSelector.extractTypes(parameterAssignments), targetType)) continue;
            method.setParameterBindings(parameterAssignments);
            return method;
        }
        return null;
    }

    private static List<List<ParameterBinding>> getCandidateParameterBindingPermutations(List<ParameterBinding> availableParams, List<Parameter> methodParameters) {
        if (methodParameters.size() > availableParams.size()) {
            return null;
        }
        ArrayList<List<ParameterBinding>> bindingPermutations = new ArrayList<List<ParameterBinding>>(1);
        bindingPermutations.add(new ArrayList(methodParameters.size()));
        for (Parameter methodParam : methodParameters) {
            List<ParameterBinding> candidateBindings = TypeSelector.findCandidateBindingsForParameter(availableParams, methodParam);
            if (candidateBindings.isEmpty()) {
                return null;
            }
            if (candidateBindings.size() == 1) {
                for (List list : bindingPermutations) {
                    list.add(Collections.first(candidateBindings));
                }
                continue;
            }
            ArrayList newVariants = new ArrayList(bindingPermutations.size() * candidateBindings.size());
            for (List list : bindingPermutations) {
                for (ParameterBinding binding : candidateBindings) {
                    ArrayList<ParameterBinding> extendedVariant = new ArrayList<ParameterBinding>(methodParameters.size());
                    extendedVariant.addAll(list);
                    extendedVariant.add(binding);
                    newVariants.add(extendedVariant);
                }
            }
            bindingPermutations = newVariants;
        }
        return bindingPermutations;
    }

    private static List<ParameterBinding> findCandidateBindingsForParameter(List<ParameterBinding> candidateParameters, Parameter parameter) {
        ArrayList<ParameterBinding> result = new ArrayList<ParameterBinding>(candidateParameters.size());
        for (ParameterBinding candidate : candidateParameters) {
            if (parameter.isTargetType() != candidate.isTargetType() || parameter.isMappingTarget() != candidate.isMappingTarget() || parameter.isMappingContext() != candidate.isMappingContext()) continue;
            result.add(candidate);
        }
        return result;
    }

    private static List<Type> extractTypes(List<ParameterBinding> parameters) {
        ArrayList<Type> result = new ArrayList<Type>(parameters.size());
        for (ParameterBinding param : parameters) {
            result.add(param.getType());
        }
        return result;
    }
}

