/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.rar;

import java.io.Serializable;
import java.util.Objects;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.rar.AuthorizationRequestSource;
import org.keycloak.representations.AuthorizationDetailsJSONRepresentation;

public class AuthorizationDetails
implements Serializable {
    private ClientScopeModel clientScope;
    private AuthorizationRequestSource source;
    private AuthorizationDetailsJSONRepresentation authorizationDetails;

    public AuthorizationDetails(ClientScopeModel clientScope, AuthorizationRequestSource source, AuthorizationDetailsJSONRepresentation authorizationDetails) {
        this.clientScope = clientScope;
        this.source = source;
        this.authorizationDetails = authorizationDetails;
    }

    public AuthorizationDetails(ClientScopeModel clientScope) {
        this.clientScope = clientScope;
        this.source = AuthorizationRequestSource.SCOPE;
    }

    public ClientScopeModel getClientScope() {
        return this.clientScope;
    }

    public void setClientScope(ClientScopeModel clientScope) {
        this.clientScope = clientScope;
    }

    public AuthorizationRequestSource getSource() {
        return this.source;
    }

    public void setSource(AuthorizationRequestSource source) {
        this.source = source;
    }

    public AuthorizationDetailsJSONRepresentation getAuthorizationDetails() {
        return this.authorizationDetails;
    }

    public void setAuthorizationDetails(AuthorizationDetailsJSONRepresentation authorizationDetails) {
        this.authorizationDetails = authorizationDetails;
    }

    public boolean isDynamicScope() {
        return this.source.equals((Object)AuthorizationRequestSource.SCOPE) && this.getClientScope().isDynamicScope();
    }

    public String getDynamicScopeParam() {
        if (this.isDynamicScope()) {
            return this.authorizationDetails.getDynamicScopeParamFromCustomData();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationDetails that = (AuthorizationDetails)o;
        return Objects.equals(this.clientScope, that.clientScope) && this.source == that.source && Objects.equals(this.authorizationDetails, that.authorizationDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientScope, this.source, this.authorizationDetails});
    }

    public String toString() {
        return "AuthorizationDetails{clientScope=" + this.clientScope + ", source=" + this.source + ", authorizationDetails=" + this.authorizationDetails + "}";
    }
}

