/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2.maven2.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    public static Comparator<?> LT = new NegativeComparator();
    public static Comparator<?> GT = new PositiveComparator();

    public static <T, V> Collection<V> apply(Collection<T> collection, Function<T, V> function) {
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(function.eval(t));
        }
        return list;
    }

    public static <T, V> V bestValue(Collection<T> collection, Function<T, V> function, Comparator<V> comparator) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        Iterator<T> i = collection.iterator();
        V candidateValue = function.eval(i.next());
        while (i.hasNext()) {
            V nextValue = function.eval(i.next());
            if (comparator.compare(candidateValue, nextValue) >= 0) continue;
            candidateValue = nextValue;
        }
        return candidateValue;
    }

    public static <V> Comparator<V> lt() {
        Comparator<?> comparator = LT;
        return comparator;
    }

    public static <V> Comparator<V> gt() {
        Comparator<?> comparator = GT;
        return comparator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Function<T, V> {
        public V eval(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NegativeComparator<V>
    implements Comparator<V> {
        @Override
        public int compare(V o1, V o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return -((Comparable)o1).compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PositiveComparator<V>
    implements Comparator<V> {
        @Override
        public int compare(V o1, V o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return ((Comparable)o1).compareTo(o2);
        }
    }
}

