/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.ConfigurationParameters;

class LauncherConfigurationParameters
implements ConfigurationParameters {
    private static final Logger logger = LoggerFactory.getLogger(LauncherConfigurationParameters.class);
    private final Map<String, String> explicitConfigParams;
    private final Properties configParamsFromFile;

    LauncherConfigurationParameters(Map<String, String> configParams) {
        this(configParams, "junit-platform.properties");
    }

    LauncherConfigurationParameters(Map<String, String> configParams, String configFileName) {
        Preconditions.notNull(configParams, (String)"configuration parameters must not be null");
        Preconditions.notBlank((String)configFileName, (String)"configFileName must not be null or blank");
        this.explicitConfigParams = configParams;
        this.configParamsFromFile = LauncherConfigurationParameters.fromClasspathResource(configFileName.trim());
    }

    private static Properties fromClasspathResource(String configFileName) {
        Properties props;
        block9: {
            props = new Properties();
            try {
                ClassLoader classLoader = ClassLoaderUtils.getDefaultClassLoader();
                LinkedHashSet<URL> resources = new LinkedHashSet<URL>(Collections.list(classLoader.getResources(configFileName)));
                if (resources.isEmpty()) break block9;
                if (resources.size() > 1) {
                    logger.warn(() -> String.format("Discovered %d '%s' configuration files in the classpath; only the first will be used.", resources.size(), configFileName));
                }
                URL configFileUrl = (URL)resources.iterator().next();
                logger.info(() -> String.format("Loading JUnit Platform configuration parameters from classpath resource [%s].", configFileUrl));
                URLConnection urlConnection = configFileUrl.openConnection();
                urlConnection.setUseCaches(false);
                try (InputStream inputStream = urlConnection.getInputStream();){
                    props.load(inputStream);
                }
            }
            catch (Exception ex) {
                logger.warn((Throwable)ex, () -> String.format("Failed to load JUnit Platform configuration parameters from classpath resource [%s].", configFileName));
            }
        }
        return props;
    }

    public Optional<String> get(String key) {
        return Optional.ofNullable(this.getProperty(key));
    }

    public Optional<Boolean> getBoolean(String key) {
        String property = this.getProperty(key);
        if (property != null) {
            return Optional.of(Boolean.parseBoolean(property));
        }
        return Optional.empty();
    }

    public int size() {
        return this.explicitConfigParams.size();
    }

    private String getProperty(String key) {
        Preconditions.notBlank((String)key, (String)"key must not be null or blank");
        String value = this.explicitConfigParams.get(key);
        if (value == null) {
            try {
                value = System.getProperty(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value == null) {
                value = this.configParamsFromFile.getProperty(key);
            }
        }
        return value;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        this.explicitConfigParams.forEach((arg_0, arg_1) -> ((ToStringBuilder)builder).append(arg_0, arg_1));
        this.configParamsFromFile.stringPropertyNames().stream().filter(key -> !this.explicitConfigParams.containsKey(key)).forEach(key -> builder.append(key, (Object)this.configParamsFromFile.getProperty((String)key)));
        return builder.toString();
    }
}

