/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import com.headius.backport9.buffer.Buffers;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.PackUtils;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.Sprintf;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;

public class Pack {
    private static final byte[] sSp10;
    private static final byte[] sNil10;
    private static final int IS_STAR = -1;
    private static final ASCIIEncoding ASCII;
    private static final USASCIIEncoding USASCII;
    private static final UTF8Encoding UTF8;
    private static final String NATIVE_CODES = "sSiIlLjJ";
    private static final String MAPPED_CODES = "sSiIqQjJ";
    private static final char BE = '\u00bd';
    private static final char LE = '<';
    private static final String ENDIANESS_CODES;
    private static final String UNPACK_IGNORE_NULL_CODES = "cC";
    private static final String PACK_IGNORE_NULL_CODES = "cCiIlLnNqQsSvV";
    private static final String PACK_IGNORE_NULL_CODES_WITH_MODIFIERS = "lLsS";
    private static final int UNPACK_ARRAY = 0;
    private static final int UNPACK_BLOCK = 1;
    private static final int UNPACK_1 = 2;
    private static final String sTooFew = "too few arguments";
    private static final byte[] uu_table;
    private static final byte[] b64_table;
    public static final byte[] sHexDigits;
    public static final int[] b64_xtable;
    private static final Converter[] converters;
    private static final long[] utf8_limits;

    private static long num2quad(IRubyObject arg2) {
        if (arg2.isNil()) {
            return 0L;
        }
        if (arg2 instanceof RubyBignum) {
            BigInteger big = ((RubyBignum)arg2).getValue();
            return big.longValue();
        }
        return RubyNumeric.num2long(arg2);
    }

    private static float obj2flt(Ruby runtime2, IRubyObject o) {
        return (float)TypeConverter.toFloat(runtime2, o).getDoubleValue();
    }

    private static double obj2dbl(Ruby runtime2, IRubyObject o) {
        return TypeConverter.toFloat(runtime2, o).getDoubleValue();
    }

    public static int unpackInt_i(ByteBuffer enc) {
        int value2 = Platform.BYTE_ORDER == 4321 ? Pack.decodeIntBigEndian(enc) : Pack.decodeIntLittleEndian(enc);
        return value2;
    }

    public static ByteList packInt_i(ByteList result2, int s2) {
        if (Platform.BYTE_ORDER == 4321) {
            Pack.encodeIntBigEndian(result2, s2);
        } else {
            Pack.encodeIntLittleEndian(result2, s2);
        }
        return result2;
    }

    public static void encodeUM(Ruby runtime2, ByteList lCurElemString, int occurrences, boolean ignoreStar, char type2, ByteList result2) {
        if (occurrences == 0 && type2 == 'm' && !ignoreStar) {
            Pack.encodes(runtime2, result2, lCurElemString.getUnsafeBytes(), lCurElemString.getBegin(), lCurElemString.length(), lCurElemString.length(), (byte)type2, false);
            return;
        }
        int n = occurrences = occurrences <= 2 ? 45 : occurrences / 3 * 3;
        if (lCurElemString.length() == 0) {
            return;
        }
        byte[] charsToEncode = lCurElemString.getUnsafeBytes();
        for (int i2 = 0; i2 < lCurElemString.length(); i2 += occurrences) {
            Pack.encodes(runtime2, result2, charsToEncode, i2 + lCurElemString.getBegin(), lCurElemString.length() - i2, occurrences, (byte)type2, true);
        }
    }

    private static ByteList encodes(Ruby runtime2, ByteList io2Append, byte[] charsToEncode, int startIndex, int length2, int charCount, byte encodingType, boolean tailLf) {
        byte lNextChar;
        byte lCurChar;
        byte lPadding;
        byte[] lTranslationTable;
        charCount = charCount < length2 ? charCount : length2;
        io2Append.ensure(charCount * 4 / 3 + 6);
        int i2 = startIndex;
        byte[] byArray = lTranslationTable = encodingType == 117 ? uu_table : b64_table;
        if (encodingType == 117) {
            if (charCount >= lTranslationTable.length) {
                throw runtime2.newArgumentError(charCount + " is not a correct value for the number of bytes per line in a u directive.  Correct values range from 0 to " + lTranslationTable.length);
            }
            io2Append.append(lTranslationTable[charCount]);
            lPadding = 96;
        } else {
            lPadding = 61;
        }
        while (charCount >= 3) {
            lCurChar = charsToEncode[i2++];
            lNextChar = charsToEncode[i2++];
            byte lNextNextChar = charsToEncode[i2++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | lNextChar >>> 4 & 0xF)]);
            io2Append.append(lTranslationTable[0x3F & (lNextChar << 2 & 0x3C | lNextNextChar >>> 6 & 3)]);
            io2Append.append(lTranslationTable[0x3F & lNextNextChar]);
            charCount -= 3;
        }
        if (charCount == 2) {
            lCurChar = charsToEncode[i2++];
            lNextChar = charsToEncode[i2++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | lNextChar >> 4 & 0xF)]);
            io2Append.append(lTranslationTable[0x3F & (lNextChar << 2 & 0x3C | 0)]);
            io2Append.append(lPadding);
        } else if (charCount == 1) {
            lCurChar = charsToEncode[i2++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | 0)]);
            io2Append.append(lPadding);
            io2Append.append(lPadding);
        }
        if (tailLf) {
            io2Append.append(10);
        }
        return io2Append;
    }

    public static RubyArray unpack(Ruby runtime2, ByteList encodedString, ByteList formatString) {
        return Pack.unpackWithBlock(runtime2.getCurrentContext(), runtime2, encodedString, formatString, Block.NULL_BLOCK);
    }

    public static RubyArray unpack(ThreadContext context, RubyString encoded, ByteList formatString) {
        return Pack.unpackWithBlock(context, encoded, formatString, Block.NULL_BLOCK);
    }

    public static RubyArray unpackWithBlock(ThreadContext context, RubyString encoded, ByteList formatString, Block block) {
        return (RubyArray)Pack.unpackInternal(context, encoded, formatString, block.isGiven() ? 1 : 0, 0L, block);
    }

    public static RubyArray unpackWithBlock(ThreadContext context, RubyString encoded, ByteList formatString, long offset2, Block block) {
        return (RubyArray)Pack.unpackInternal(context, encoded, formatString, block.isGiven() ? 1 : 0, offset2, block);
    }

    private static RubyString unpackBase46Strict(Ruby runtime2, ByteList input) {
        int index2 = 0;
        int s2 = -1;
        int a = -1;
        int b2 = -1;
        int c = 0;
        byte[] buf = input.unsafeBytes();
        int begin2 = input.begin();
        int length2 = input.realSize();
        int end2 = begin2 + length2;
        if (length2 % 4 != 0) {
            throw runtime2.newArgumentError("invalid base64");
        }
        int p2 = begin2;
        byte[] out = new byte[3 * ((length2 + 3) / 4)];
        while (p2 < end2 && s2 != 61) {
            if ((a = b64_xtable[s2 = buf[p2++]]) == -1) {
                throw runtime2.newArgumentError("invalid base64");
            }
            if ((b2 = b64_xtable[s2 = buf[p2++]]) == -1) {
                throw runtime2.newArgumentError("invalid base64");
            }
            s2 = buf[p2++];
            c = b64_xtable[s2];
            if (s2 == 61) {
                if (buf[p2++] == 61) break;
                throw runtime2.newArgumentError("invalid base64");
            }
            if (c == -1) {
                throw runtime2.newArgumentError("invalid base64");
            }
            s2 = buf[p2++];
            int d = b64_xtable[s2];
            if (s2 == 61) break;
            if (d == -1) {
                throw runtime2.newArgumentError("invalid base64");
            }
            out[index2++] = (byte)(a << 2 | b2 >> 4);
            out[index2++] = (byte)(b2 << 4 | c >> 2);
            out[index2++] = (byte)(c << 6 | d);
        }
        if (p2 < end2) {
            throw runtime2.newArgumentError("invalid base64");
        }
        if (a != -1 && b2 != -1) {
            if (c == -1 && s2 == 61) {
                if ((b2 & 0xF) > 0) {
                    throw runtime2.newArgumentError("invalid base64");
                }
                out[index2++] = (byte)((a << 2 | b2 >> 4) & 0xFF);
            } else if (c != -1 && s2 == 61) {
                if ((c & 3) > 0) {
                    throw runtime2.newArgumentError("invalid base64");
                }
                out[index2++] = (byte)((a << 2 | b2 >> 4) & 0xFF);
                out[index2++] = (byte)((b2 << 4 | c >> 2) & 0xFF);
            }
        }
        return runtime2.newString(new ByteList(out, 0, index2));
    }

    public static IRubyObject unpack1WithBlock(ThreadContext context, RubyString encoded, ByteList formatString, Block block) {
        return Pack.unpack1WithBlock(context, encoded, formatString, 0L, block);
    }

    public static IRubyObject unpack1WithBlock(ThreadContext context, RubyString encoded, ByteList formatString, long offset2, Block block) {
        byte second2;
        byte first2;
        int formatLength = formatString.realSize();
        if (formatLength >= 1 && (first2 = (byte)(formatString.get(0) & 0xFF)) == 109 && formatLength == 2 && (second2 = (byte)(formatString.get(1) & 0xFF)) == 48) {
            return Pack.unpackBase46Strict(context.runtime, encoded.getByteList());
        }
        return Pack.unpackInternal(context, encoded, formatString, 2, offset2, block);
    }

    private static IRubyObject unpackInternal(ThreadContext context, RubyString encoded, ByteList formatString, int mode2, long offset2, Block block) {
        Ruby runtime2 = context.runtime;
        RubyArray result2 = mode2 == 1 || mode2 == 2 ? null : runtime2.newArray();
        ByteList encodedString = encoded.getByteList();
        int len = encodedString.realSize();
        int beg = encodedString.begin();
        if (offset2 < 0L) {
            throw context.runtime.newArgumentError("offset can't be negative");
        }
        if (offset2 > 0L) {
            if (offset2 > (long)len) {
                throw context.runtime.newArgumentError("offset outside of string");
            }
            beg = (int)((long)beg + offset2);
            len = (int)((long)len - offset2);
        }
        ByteBuffer format = ByteBuffer.wrap(formatString.getUnsafeBytes(), formatString.begin(), formatString.length());
        ByteBuffer encode2 = ByteBuffer.wrap(encodedString.getUnsafeBytes(), beg, len);
        int next2 = Pack.safeGet(format);
        IRubyObject value2 = null;
        block19: while (next2 != 0) {
            int occurrences;
            int index2;
            int type2 = next2;
            next2 = Pack.safeGet(format);
            if (UNPACK_IGNORE_NULL_CODES.indexOf(type2) != -1 && next2 == 0) {
                next2 = Pack.safeGetIgnoreNull(format);
            }
            if (type2 == 35) {
                while (type2 != 10) {
                    if (next2 == 0) break block19;
                    type2 = next2;
                    next2 = Pack.safeGet(format);
                }
            }
            if (next2 == 95 || next2 == 33) {
                index2 = NATIVE_CODES.indexOf(type2);
                if (index2 == -1) {
                    throw runtime2.newArgumentError("'" + next2 + "' allowed only after types " + NATIVE_CODES);
                }
                type2 = MAPPED_CODES.charAt(index2);
                next2 = Pack.safeGet(format);
            }
            if (next2 == 62 || next2 == 60) {
                index2 = ENDIANESS_CODES.indexOf(type2 + (next2 = next2 == 62 ? 189 : 60));
                if (index2 == -1) {
                    throw runtime2.newArgumentError("'" + (char)next2 + "' allowed only after types sSiIlLqQjJ");
                }
                type2 = ENDIANESS_CODES.charAt(index2);
                next2 = Pack.safeGet(format);
                if (next2 == 95 || next2 == 33) {
                    next2 = Pack.safeGet(format);
                }
            }
            if (next2 == 0) {
                occurrences = 1;
            } else if (next2 == 42) {
                occurrences = -1;
                next2 = Pack.safeGet(format);
            } else if (ASCII.isDigit(next2)) {
                occurrences = 0;
                do {
                    occurrences = occurrences * 10 + Character.digit((char)(next2 & 0xFF), 10);
                } while ((next2 = Pack.safeGet(format)) != 0 && ASCII.isDigit(next2));
            } else {
                occurrences = type2 == 64 ? 0 : 1;
            }
            Converter converter = converters[type2];
            if (converter != null) {
                value2 = Pack.decode(context, runtime2, encode2, occurrences, result2, block, converter, mode2);
                if (mode2 != 2 || value2 == null) continue;
                return value2;
            }
            switch (type2) {
                case 64: {
                    Pack.unpack_at(runtime2, encodedString, encode2, occurrences);
                    break;
                }
                case 37: {
                    throw runtime2.newArgumentError("% is not supported");
                }
                case 65: {
                    value2 = Pack.unpack_A(context, block, result2, encode2, occurrences, mode2);
                    break;
                }
                case 90: {
                    value2 = Pack.unpack_Z(context, block, result2, encode2, occurrences, mode2);
                    break;
                }
                case 97: {
                    value2 = Pack.unpack_a(context, block, result2, encode2, occurrences, mode2);
                    break;
                }
                case 98: {
                    value2 = Pack.unpack_b(context, block, result2, encode2, occurrences, mode2);
                    break;
                }
                case 66: {
                    value2 = Pack.unpack_B(context, block, result2, encode2, occurrences, mode2);
                    break;
                }
                case 104: {
                    value2 = Pack.unpack_h(context, block, result2, encode2, occurrences, mode2);
                    break;
                }
                case 72: {
                    value2 = Pack.unpack_H(context, block, result2, encode2, occurrences, mode2);
                    break;
                }
                case 117: {
                    value2 = Pack.unpack_u(context, block, result2, encode2, mode2);
                    break;
                }
                case 109: {
                    value2 = Pack.unpack_m(context, block, runtime2, result2, encode2, occurrences, mode2);
                    break;
                }
                case 77: {
                    value2 = Pack.unpack_M(context, block, result2, encode2, mode2);
                    break;
                }
                case 85: {
                    value2 = Pack.unpack_U(context, block, runtime2, result2, encode2, occurrences, mode2);
                    break;
                }
                case 88: {
                    Pack.unpack_X(runtime2, encode2, occurrences);
                    break;
                }
                case 120: {
                    Pack.unpack_x(runtime2, encode2, occurrences);
                    break;
                }
                case 119: {
                    value2 = Pack.unpack_w(context, block, runtime2, result2, encode2, occurrences, mode2);
                    break;
                }
                case 32: {
                    break;
                }
                default: {
                    Pack.unknownDirective(context.runtime, "unpack", type2, formatString);
                }
            }
            if (mode2 != 2 || value2 == null) continue;
            return value2;
        }
        return result2;
    }

    private static IRubyObject unpack_w(ThreadContext context, Block block, Ruby runtime2, RubyArray result2, ByteBuffer encode2, int occurrences, int mode2) {
        if (occurrences == -1 || occurrences > encode2.remaining()) {
            occurrences = encode2.remaining();
        }
        long ul = 0L;
        long ulmask = -144115188075855872L;
        RubyBignum big128 = RubyBignum.newBignum(runtime2, 128L);
        int pos2 = encode2.position();
        block2: while (occurrences > 0 && pos2 < encode2.limit()) {
            ul <<= 7;
            ul |= (long)(encode2.get(pos2) & 0x7F);
            if ((encode2.get(pos2++) & 0x80) == 0) {
                RubyFixnum value2 = RubyFixnum.newFixnum(runtime2, ul);
                if (mode2 == 2) {
                    return value2;
                }
                Pack.appendOrYield(context, block, result2, value2, mode2);
                --occurrences;
                ul = 0L;
                continue;
            }
            if ((ul & ulmask) != 0L) continue;
            RubyBignum big = RubyBignum.newBignum(runtime2, ul);
            while (occurrences > 0 && pos2 < encode2.limit()) {
                IRubyObject mulResult = big.op_mul(runtime2.getCurrentContext(), big128);
                IRubyObject v = mulResult.callMethod(runtime2.getCurrentContext(), "+", RubyBignum.newBignum(runtime2, encode2.get(pos2) & 0x7F));
                if (v instanceof RubyFixnum) {
                    big = RubyBignum.newBignum(runtime2, RubyNumeric.fix2long(v));
                } else if (v instanceof RubyBignum) {
                    big = (RubyBignum)v;
                }
                if ((encode2.get(pos2++) & 0x80) != 0) continue;
                RubyInteger value3 = RubyBignum.bignorm(runtime2, big.getValue());
                if (mode2 == 2) {
                    return value3;
                }
                Pack.appendOrYield(context, block, result2, value3, mode2);
                --occurrences;
                ul = 0L;
                continue block2;
            }
        }
        try {
            Buffers.positionBuffer((Buffer)encode2, (int)pos2);
        }
        catch (IllegalArgumentException e) {
            throw runtime2.newArgumentError("in `unpack': poorly encoded input");
        }
        return context.nil;
    }

    private static void unpack_x(Ruby runtime2, ByteBuffer encode2, int occurrences) {
        if (occurrences == -1) {
            occurrences = encode2.remaining();
        }
        try {
            Buffers.positionBuffer((Buffer)encode2, (int)(encode2.position() + occurrences));
        }
        catch (IllegalArgumentException e) {
            throw runtime2.newArgumentError("in `unpack': x outside of string");
        }
    }

    private static void unpack_X(Ruby runtime2, ByteBuffer encode2, int occurrences) {
        if (occurrences == -1) {
            occurrences = encode2.remaining();
        }
        try {
            Buffers.positionBuffer((Buffer)encode2, (int)(encode2.position() - occurrences));
        }
        catch (IllegalArgumentException e) {
            throw runtime2.newArgumentError("in `unpack': X outside of string");
        }
    }

    private static IRubyObject unpack_U(ThreadContext context, Block block, Ruby runtime2, RubyArray result2, ByteBuffer encode2, int occurrences, int mode2) {
        if (occurrences == -1 || occurrences > encode2.remaining()) {
            occurrences = encode2.remaining();
        }
        while (occurrences-- > 0 && encode2.remaining() > 0) {
            try {
                RubyFixnum item = runtime2.newFixnum(Pack.utf8Decode(encode2));
                if (mode2 == 2) {
                    return item;
                }
                Pack.appendOrYield(context, block, result2, item, mode2);
            }
            catch (IllegalArgumentException e) {
                throw runtime2.newArgumentError(e.getMessage());
            }
        }
        return context.nil;
    }

    private static IRubyObject unpack_M(ThreadContext context, Block block, RubyArray result2, ByteBuffer encode2, int mode2) {
        byte[] lElem = new byte[Math.max(encode2.remaining(), 0)];
        int index2 = 0;
        while (encode2.hasRemaining()) {
            int c = Pack.safeGet(encode2);
            if (c != 61) {
                lElem[index2++] = (byte)c;
                continue;
            }
            if (!encode2.hasRemaining()) break;
            Buffers.markBuffer((Buffer)encode2);
            int c1 = Pack.safeGet(encode2);
            if (c1 == 10 || c1 == 13 && (c1 = Pack.safeGet(encode2)) == 10) continue;
            int d1 = Character.digit(c1, 16);
            if (d1 == -1) {
                encode2.reset();
                break;
            }
            Buffers.markBuffer((Buffer)encode2);
            if (!encode2.hasRemaining()) break;
            int c2 = Pack.safeGet(encode2);
            int d2 = Character.digit(c2, 16);
            if (d2 == -1) {
                encode2.reset();
                break;
            }
            byte value2 = (byte)(d1 << 4 | d2);
            lElem[index2++] = value2;
        }
        return Pack.appendOrYield(context, block, result2, new ByteList(lElem, 0, index2, (Encoding)ASCII, false), mode2);
    }

    private static IRubyObject unpack_m(ThreadContext context, Block block, Ruby runtime2, RubyArray result2, ByteBuffer encode2, int occurrences, int mode2) {
        int length2 = encode2.remaining() * 3 / 4;
        byte[] lElem = new byte[length2];
        int a = -1;
        int b2 = -1;
        int c = 0;
        int index2 = 0;
        int s2 = -1;
        index2 = occurrences == 0 ? Pack.unpack_m_zeroOccurrences(runtime2, encode2, lElem, a, b2, c, index2, s2) : Pack.unpack_m_nonzeroOccurrences(encode2, lElem, a, b2, c, index2);
        return Pack.appendOrYield(context, block, result2, new ByteList(lElem, 0, index2, (Encoding)ASCII, false), mode2);
    }

    private static int unpack_m_nonzeroOccurrences(ByteBuffer encode2, byte[] lElem, int a, int b2, int c, int index2) {
        while (encode2.hasRemaining()) {
            int d = -1;
            c = -1;
            b2 = -1;
            a = -1;
            int s2 = Pack.safeGet(encode2);
            while ((a = b64_xtable[s2]) == -1 && encode2.hasRemaining()) {
                s2 = Pack.safeGet(encode2);
            }
            if (a == -1) break;
            s2 = Pack.safeGet(encode2);
            while ((b2 = b64_xtable[s2]) == -1 && encode2.hasRemaining()) {
                s2 = Pack.safeGet(encode2);
            }
            if (b2 == -1) break;
            s2 = Pack.safeGet(encode2);
            while ((c = b64_xtable[s2]) == -1 && encode2.hasRemaining() && s2 != 61) {
                s2 = Pack.safeGet(encode2);
            }
            if (s2 == 61 || c == -1) {
                if (s2 != 61) break;
                Buffers.positionBuffer((Buffer)encode2, (int)(encode2.position() - 1));
                break;
            }
            s2 = Pack.safeGet(encode2);
            while ((d = b64_xtable[s2]) == -1 && encode2.hasRemaining() && s2 != 61) {
                s2 = Pack.safeGet(encode2);
            }
            if (s2 == 61 || d == -1) {
                if (s2 != 61) break;
                Buffers.positionBuffer((Buffer)encode2, (int)(encode2.position() - 1));
                break;
            }
            lElem[index2++] = (byte)((a << 2 | b2 >> 4) & 0xFF);
            lElem[index2++] = (byte)((b2 << 4 | c >> 2) & 0xFF);
            lElem[index2++] = (byte)((c << 6 | d) & 0xFF);
            a = -1;
        }
        if (a != -1 && b2 != -1) {
            if (c == -1) {
                lElem[index2++] = (byte)((a << 2 | b2 >> 4) & 0xFF);
            } else {
                lElem[index2++] = (byte)((a << 2 | b2 >> 4) & 0xFF);
                lElem[index2++] = (byte)((b2 << 4 | c >> 2) & 0xFF);
            }
        }
        return index2;
    }

    private static int unpack_m_zeroOccurrences(Ruby runtime2, ByteBuffer encode2, byte[] lElem, int a, int b2, int c, int index2, int s2) {
        if (encode2.remaining() % 4 != 0) {
            throw runtime2.newArgumentError("invalid base64");
        }
        while (encode2.hasRemaining() && s2 != 61) {
            c = -1;
            b2 = -1;
            a = -1;
            int d = -2;
            s2 = Pack.safeGet(encode2);
            a = b64_xtable[s2];
            if (a == -1) {
                throw runtime2.newArgumentError("invalid base64");
            }
            s2 = Pack.safeGet(encode2);
            b2 = b64_xtable[s2];
            if (b2 == -1) {
                throw runtime2.newArgumentError("invalid base64");
            }
            s2 = Pack.safeGet(encode2);
            c = b64_xtable[s2];
            if (s2 == 61) {
                if (Pack.safeGet(encode2) == 61) break;
                throw runtime2.newArgumentError("invalid base64");
            }
            if (c == -1) {
                throw runtime2.newArgumentError("invalid base64");
            }
            s2 = Pack.safeGet(encode2);
            d = b64_xtable[s2];
            if (s2 == 61) break;
            if (d == -1) {
                throw runtime2.newArgumentError("invalid base64");
            }
            lElem[index2++] = (byte)((a << 2 | b2 >> 4) & 0xFF);
            lElem[index2++] = (byte)((b2 << 4 | c >> 2) & 0xFF);
            lElem[index2++] = (byte)((c << 6 | d) & 0xFF);
        }
        if (encode2.hasRemaining()) {
            throw runtime2.newArgumentError("invalid base64");
        }
        if (a != -1 && b2 != -1) {
            if (c == -1 && s2 == 61) {
                if ((b2 & 0xF) > 0) {
                    throw runtime2.newArgumentError("invalid base64");
                }
                lElem[index2++] = (byte)((a << 2 | b2 >> 4) & 0xFF);
            } else if (c != -1 && s2 == 61) {
                if ((c & 3) > 0) {
                    throw runtime2.newArgumentError("invalid base64");
                }
                lElem[index2++] = (byte)((a << 2 | b2 >> 4) & 0xFF);
                lElem[index2++] = (byte)((b2 << 4 | c >> 2) & 0xFF);
            }
        }
        return index2;
    }

    private static IRubyObject unpack_u(ThreadContext context, Block block, RubyArray result2, ByteBuffer encode2, int mode2) {
        int length2 = encode2.remaining() * 3 / 4;
        byte[] lElem = new byte[length2];
        int index2 = 0;
        int s2 = 0;
        int total2 = 0;
        if (length2 > 0) {
            s2 = encode2.get();
        }
        while (encode2.hasRemaining() && s2 > 32 && s2 < 97) {
            byte[] hunk = new byte[3];
            int len = s2 - 32 & 0x3F;
            s2 = Pack.safeGet(encode2);
            if ((total2 += len) > length2) {
                len -= total2 - length2;
                total2 = length2;
            }
            while (len > 0) {
                int d;
                int c;
                int b2;
                int a;
                int mlen;
                int n = mlen = len > 3 ? 3 : len;
                if (encode2.hasRemaining() && s2 >= 32) {
                    a = s2 - 32 & 0x3F;
                    s2 = Pack.safeGet(encode2);
                } else {
                    a = 0;
                }
                if (encode2.hasRemaining() && s2 >= 32) {
                    b2 = s2 - 32 & 0x3F;
                    s2 = Pack.safeGet(encode2);
                } else {
                    b2 = 0;
                }
                if (encode2.hasRemaining() && s2 >= 32) {
                    c = s2 - 32 & 0x3F;
                    s2 = Pack.safeGet(encode2);
                } else {
                    c = 0;
                }
                if (encode2.hasRemaining() && s2 >= 32) {
                    d = s2 - 32 & 0x3F;
                    s2 = Pack.safeGet(encode2);
                } else {
                    d = 0;
                }
                hunk[0] = (byte)((a << 2 | b2 >> 4) & 0xFF);
                hunk[1] = (byte)((b2 << 4 | c >> 2) & 0xFF);
                hunk[2] = (byte)((c << 6 | d) & 0xFF);
                for (int i2 = 0; i2 < mlen; ++i2) {
                    lElem[index2++] = hunk[i2];
                }
                len -= mlen;
            }
            if (s2 == 13) {
                s2 = Pack.safeGet(encode2);
            }
            if (s2 == 10) {
                s2 = Pack.safeGet(encode2);
                continue;
            }
            if (!encode2.hasRemaining()) continue;
            if (Pack.safeGet(encode2) == 10) {
                Pack.safeGet(encode2);
                continue;
            }
            if (!encode2.hasRemaining()) continue;
            Buffers.positionBuffer((Buffer)encode2, (int)(encode2.position() - 1));
        }
        return Pack.appendOrYield(context, block, result2, new ByteList(lElem, 0, index2, (Encoding)ASCII, false), mode2);
    }

    private static IRubyObject unpack_H(ThreadContext context, Block block, RubyArray result2, ByteBuffer encode2, int occurrences, int mode2) {
        if (occurrences == -1 || occurrences > encode2.remaining() * 2) {
            occurrences = encode2.remaining() * 2;
        }
        int bits = 0;
        byte[] lElem = new byte[occurrences];
        for (int lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
            bits = (lCurByte & 1) != 0 ? (bits <<= 4) : (int)encode2.get();
            lElem[lCurByte] = sHexDigits[bits >>> 4 & 0xF];
        }
        return Pack.appendOrYield(context, block, result2, new ByteList(lElem, (Encoding)USASCII, false), mode2);
    }

    private static IRubyObject unpack_h(ThreadContext context, Block block, RubyArray result2, ByteBuffer encode2, int occurrences, int mode2) {
        if (occurrences == -1 || occurrences > encode2.remaining() * 2) {
            occurrences = encode2.remaining() * 2;
        }
        int bits = 0;
        byte[] lElem = new byte[occurrences];
        for (int lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
            bits = (lCurByte & 1) != 0 ? (bits >>>= 4) : (int)encode2.get();
            lElem[lCurByte] = sHexDigits[bits & 0xF];
        }
        return Pack.appendOrYield(context, block, result2, new ByteList(lElem, (Encoding)USASCII, false), mode2);
    }

    private static IRubyObject unpack_B(ThreadContext context, Block block, RubyArray result2, ByteBuffer encode2, int occurrences, int mode2) {
        if (occurrences == -1 || occurrences > encode2.remaining() * 8) {
            occurrences = encode2.remaining() * 8;
        }
        int bits = 0;
        byte[] lElem = new byte[occurrences];
        for (int lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
            bits = (lCurByte & 7) != 0 ? (bits <<= 1) : (int)encode2.get();
            lElem[lCurByte] = (bits & 0x80) != 0 ? 49 : 48;
        }
        return Pack.appendOrYield(context, block, result2, new ByteList(lElem, (Encoding)ASCII, false), mode2);
    }

    private static IRubyObject unpack_b(ThreadContext context, Block block, RubyArray result2, ByteBuffer encode2, int occurrences, int mode2) {
        if (occurrences == -1 || occurrences > encode2.remaining() * 8) {
            occurrences = encode2.remaining() * 8;
        }
        int bits = 0;
        byte[] lElem = new byte[occurrences];
        for (int lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
            bits = (lCurByte & 7) != 0 ? (bits >>>= 1) : (int)encode2.get();
            lElem[lCurByte] = (bits & 1) != 0 ? 49 : 48;
        }
        return Pack.appendOrYield(context, block, result2, new ByteList(lElem, (Encoding)USASCII, false), mode2);
    }

    private static IRubyObject unpack_a(ThreadContext context, Block block, RubyArray result2, ByteBuffer encode2, int occurrences, int mode2) {
        if (occurrences == -1 || occurrences > encode2.remaining()) {
            occurrences = encode2.remaining();
        }
        byte[] potential = new byte[occurrences];
        encode2.get(potential);
        return Pack.appendOrYield(context, block, result2, new ByteList(potential, (Encoding)ASCII, false), mode2);
    }

    private static IRubyObject unpack_Z(ThreadContext context, Block block, RubyArray result2, ByteBuffer encode2, int occurrences, int mode2) {
        byte b2;
        int t;
        boolean isStar;
        boolean bl = isStar = occurrences == -1;
        if (occurrences == -1 || occurrences > encode2.remaining()) {
            occurrences = encode2.remaining();
        }
        byte[] potential = new byte[occurrences];
        for (t = 0; t < occurrences && (b2 = encode2.get()) != 0; ++t) {
            potential[t] = b2;
        }
        IRubyObject value2 = Pack.appendOrYield(context, block, result2, new ByteList(potential, 0, t, (Encoding)ASCII, false), mode2);
        if (mode2 == 2) {
            return value2;
        }
        if (!isStar) {
            if (t < occurrences) {
                ++t;
            }
            while (t < occurrences) {
                encode2.get();
                ++t;
            }
        }
        return context.nil;
    }

    private static IRubyObject unpack_A(ThreadContext context, Block block, RubyArray result2, ByteBuffer encode2, int occurrences, int mode2) {
        byte c;
        if (occurrences == -1 || occurrences > encode2.remaining()) {
            occurrences = encode2.remaining();
        }
        byte[] potential = new byte[occurrences];
        encode2.get(potential);
        int t = occurrences - 1;
        while (occurrences > 0 && ((c = potential[t]) == 0 || c == 32)) {
            --occurrences;
            --t;
        }
        return Pack.appendOrYield(context, block, result2, new ByteList(potential, 0, occurrences, (Encoding)ASCII, false), mode2);
    }

    private static void unpack_at(Ruby runtime2, ByteList encodedString, ByteBuffer encode2, int occurrences) {
        try {
            int limit2 = occurrences == -1 ? Pack.checkLimit(runtime2, encode2, encodedString.begin() + encode2.remaining()) : Pack.checkLimit(runtime2, encode2, encodedString.begin() + occurrences);
            Buffers.positionBuffer((Buffer)encode2, (int)limit2);
        }
        catch (IllegalArgumentException iae) {
            throw runtime2.newArgumentError("@ outside of string");
        }
    }

    private static int checkLimit(Ruby runtime2, ByteBuffer encode2, int limit2) {
        if (limit2 >= encode2.capacity() || limit2 < 0) {
            throw runtime2.newRangeError("pack length too big");
        }
        return limit2;
    }

    @Deprecated
    public static RubyArray unpackWithBlock(ThreadContext context, Ruby runtime2, ByteList encodedString, ByteList formatString, Block block) {
        return Pack.unpackWithBlock(context, RubyString.newStringLight(runtime2, encodedString), formatString, block);
    }

    private static void appendOrYield(ThreadContext context, Block block, RubyArray result2, IRubyObject item, int mode2) {
        if (mode2 == 1) {
            block.yield(context, item);
        } else if (mode2 == 0) {
            result2.append(item);
        }
    }

    private static IRubyObject appendOrYield(ThreadContext context, Block block, RubyArray result2, ByteList item, int mode2) {
        RubyString itemStr = RubyString.newString(context.runtime, item);
        if (mode2 == 2) {
            return itemStr;
        }
        Pack.appendOrYield(context, block, result2, itemStr, mode2);
        return context.nil;
    }

    public static int utf8Decode(Ruby runtime2, byte[] to, int p2, int code) {
        if (code <= 127) {
            to[p2] = (byte)code;
            return 1;
        }
        if (code <= 2047) {
            to[p2 + 0] = (byte)(code >>> 6 & 0xFF | 0xC0);
            to[p2 + 1] = (byte)(code & 0x3F | 0x80);
            return 2;
        }
        if (code <= 65535) {
            to[p2 + 0] = (byte)(code >>> 12 & 0xFF | 0xE0);
            to[p2 + 1] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p2 + 2] = (byte)(code & 0x3F | 0x80);
            return 3;
        }
        if (code <= 0x1FFFFF) {
            to[p2 + 0] = (byte)(code >>> 18 & 0xFF | 0xF0);
            to[p2 + 1] = (byte)(code >>> 12 & 0x3F | 0x80);
            to[p2 + 2] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p2 + 3] = (byte)(code & 0x3F | 0x80);
            return 4;
        }
        if (code <= 0x3FFFFFF) {
            to[p2 + 0] = (byte)(code >>> 24 & 0xFF | 0xF8);
            to[p2 + 1] = (byte)(code >>> 18 & 0x3F | 0x80);
            to[p2 + 2] = (byte)(code >>> 12 & 0x3F | 0x80);
            to[p2 + 3] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p2 + 4] = (byte)(code & 0x3F | 0x80);
            return 5;
        }
        if (code <= Integer.MAX_VALUE) {
            to[p2 + 0] = (byte)(code >>> 30 & 0xFF | 0xFC);
            to[p2 + 1] = (byte)(code >>> 24 & 0x3F | 0x80);
            to[p2 + 2] = (byte)(code >>> 18 & 0x3F | 0x80);
            to[p2 + 3] = (byte)(code >>> 12 & 0x3F | 0x80);
            to[p2 + 4] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p2 + 5] = (byte)(code & 0x3F | 0x80);
            return 6;
        }
        throw runtime2.newRangeError("pack(U): value out of range");
    }

    private static int utf8Decode(ByteBuffer buffer) {
        int n;
        int c;
        int uv = c = buffer.get() & 0xFF;
        if ((c & 0x80) == 0) {
            return c;
        }
        if ((c & 0x40) == 0) {
            throw new IllegalArgumentException("malformed UTF-8 character");
        }
        if ((uv & 0x20) == 0) {
            n = 2;
            uv &= 0x1F;
        } else if ((uv & 0x10) == 0) {
            n = 3;
            uv &= 0xF;
        } else if ((uv & 8) == 0) {
            n = 4;
            uv &= 7;
        } else if ((uv & 4) == 0) {
            n = 5;
            uv &= 3;
        } else if ((uv & 2) == 0) {
            n = 6;
            uv &= 1;
        } else {
            throw new IllegalArgumentException("malformed UTF-8 character");
        }
        if (n > buffer.remaining() + 1) {
            throw new IllegalArgumentException("malformed UTF-8 character (expected " + n + " bytes, given " + (buffer.remaining() + 1) + " bytes)");
        }
        int limit2 = n - 1;
        if (--n != 0) {
            while (n-- != 0) {
                c = buffer.get() & 0xFF;
                if ((c & 0xC0) != 128) {
                    throw new IllegalArgumentException("malformed UTF-8 character");
                }
                uv = uv << 6 | (c &= 0x3F);
            }
        }
        if ((long)uv < utf8_limits[limit2]) {
            throw new IllegalArgumentException("redundant UTF-8 sequence");
        }
        return uv;
    }

    public static int safeGet(ByteBuffer encode2) {
        while (encode2.hasRemaining()) {
            int got = encode2.get() & 0xFF;
            if (got == 0) continue;
            return got;
        }
        return 0;
    }

    private static int safeGetIgnoreNull(ByteBuffer encode2) {
        int next2 = 0;
        while (encode2.hasRemaining() && next2 == 0) {
            next2 = Pack.safeGet(encode2);
        }
        return next2;
    }

    public static IRubyObject decode(ThreadContext context, Ruby runtime2, ByteBuffer encode2, int occurrences, RubyArray result2, Block block, Converter converter, int mode2) {
        int lPadLength = 0;
        if (occurrences == -1) {
            occurrences = encode2.remaining() / converter.size;
        } else if (occurrences > encode2.remaining() / converter.size) {
            lPadLength = occurrences - encode2.remaining() / converter.size;
            occurrences = encode2.remaining() / converter.size;
        }
        while (occurrences-- > 0) {
            IRubyObject value2 = converter.decode(runtime2, encode2);
            if (mode2 == 2) {
                return value2;
            }
            Pack.appendOrYield(context, block, result2, value2, mode2);
        }
        while (lPadLength-- > 0) {
            if (mode2 == 2) {
                return context.nil;
            }
            Pack.appendOrYield(context, block, result2, context.nil, mode2);
        }
        return context.nil;
    }

    public static int encode(Ruby runtime2, int occurrences, ByteList result2, RubyArray list2, int index2, ConverterExecutor converter) {
        int listSize = list2.size();
        while (occurrences-- > 0) {
            if (listSize-- <= 0 || index2 >= list2.size()) {
                throw runtime2.newArgumentError(sTooFew);
            }
            Object from = list2.eltInternal(index2++);
            converter.encode(runtime2, (IRubyObject)from, result2);
        }
        return index2;
    }

    private static ConverterExecutor executor() {
        return new ConverterExecutor(){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer format) {
                return this.converter.decode(runtime2, format);
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject from, ByteList result2) {
                if (from == runtime2.getNil() && this.converter.getType() != null) {
                    throw runtime2.newTypeError(from, this.converter.getType());
                }
                this.converter.encode(runtime2, from, result2);
            }
        };
    }

    private static final ByteList shrink(ByteList i2Shrink, int iLength) {
        iLength = i2Shrink.length() - iLength;
        if (iLength < 0) {
            throw new IllegalArgumentException();
        }
        i2Shrink.length(iLength);
        return i2Shrink;
    }

    private static final ByteList grow(ByteList i2Grow, byte[] iPads, int iLength) {
        int lPadLength = iPads.length;
        while (iLength >= lPadLength) {
            i2Grow.append(iPads);
            iLength -= lPadLength;
        }
        i2Grow.append(iPads, 0, iLength);
        return i2Grow;
    }

    public static RubyString pack(Ruby runtime2, RubyArray list2, ByteList formatString) {
        RubyString buffer = runtime2.newString();
        return Pack.packCommon(runtime2.getCurrentContext(), list2, formatString, Pack.executor(), buffer);
    }

    @Deprecated
    public static RubyString pack(ThreadContext context, Ruby runtime2, RubyArray list2, RubyString formatString) {
        RubyString buffer = runtime2.newString();
        return Pack.pack(context, list2, formatString, buffer);
    }

    @Deprecated
    public static void decode(ThreadContext context, Ruby runtime2, ByteBuffer encode2, int occurrences, RubyArray result2, Block block, Converter converter) {
        Pack.decode(context, runtime2, encode2, occurrences, result2, block, converter, block.isGiven() ? 1 : 0);
    }

    public static RubyString pack(ThreadContext context, RubyArray list2, RubyString formatString, RubyString buffer) {
        return Pack.packCommon(context, list2, formatString.getByteList(), Pack.executor(), buffer);
    }

    private static RubyString packCommon(ThreadContext context, RubyArray list2, ByteList formatString, ConverterExecutor executor, RubyString buffer) {
        ByteBuffer format = ByteBuffer.wrap(formatString.getUnsafeBytes(), formatString.begin(), formatString.length());
        buffer.modify();
        ByteList result2 = buffer.getByteList();
        PackInts packInts = new PackInts(list2.size(), 0);
        int next2 = Pack.safeGet(format);
        int enc_info = 1;
        block16: while (next2 != 0) {
            int index2;
            int type2 = next2;
            next2 = Pack.safeGet(format);
            if (PACK_IGNORE_NULL_CODES.indexOf(type2) != -1 && next2 == 0) {
                next2 = Pack.safeGetIgnoreNull(format);
            }
            while (ASCII.isSpace(type2)) {
                if (next2 == 0) break block16;
                type2 = next2;
                next2 = Pack.safeGet(format);
            }
            if (type2 == 35) {
                while (type2 != 10) {
                    if (next2 == 0) break block16;
                    type2 = next2;
                    next2 = Pack.safeGet(format);
                }
            }
            if (next2 == 33 || next2 == 95) {
                index2 = NATIVE_CODES.indexOf(type2);
                if (index2 == -1) {
                    throw context.runtime.newArgumentError("'" + next2 + "' allowed only after types " + NATIVE_CODES);
                }
                int typeBeforeMap = type2;
                type2 = MAPPED_CODES.charAt(index2);
                next2 = Pack.safeGet(format);
                if (PACK_IGNORE_NULL_CODES_WITH_MODIFIERS.indexOf(typeBeforeMap) != -1 && next2 == 0) {
                    next2 = Pack.safeGetIgnoreNull(format);
                }
            }
            if (next2 == 62 || next2 == 60) {
                index2 = ENDIANESS_CODES.indexOf(type2 + (next2 = next2 == 62 ? 189 : 60));
                if (index2 == -1) {
                    throw context.runtime.newArgumentError("'" + (char)next2 + "' allowed only after types sSiIlLqQ");
                }
                type2 = ENDIANESS_CODES.charAt(index2);
                next2 = Pack.safeGet(format);
            }
            int occurrences = 1;
            boolean isStar = false;
            boolean ignoreStar = false;
            if (next2 != 0) {
                if (next2 == 42) {
                    if ("@XxumM".indexOf(type2) != -1) {
                        occurrences = 0;
                        ignoreStar = true;
                    } else {
                        occurrences = list2.size() - packInts.idx;
                        isStar = true;
                    }
                    next2 = Pack.safeGet(format);
                } else if (ASCII.isDigit(next2)) {
                    occurrences = 0;
                    do {
                        occurrences = occurrences * 10 + Character.digit((char)(next2 & 0xFF), 10);
                    } while ((next2 = Pack.safeGet(format)) != 0 && ASCII.isDigit(next2));
                }
            }
            enc_info = Pack.adjustEncInfo(type2, enc_info);
            Converter converter = converters[type2];
            if (converter != null) {
                executor.setConverter(converter);
                packInts.idx = Pack.encode(context.runtime, occurrences, result2, list2, packInts.idx, executor);
                continue;
            }
            switch (type2) {
                case 37: {
                    throw context.runtime.newArgumentError("% is not supported");
                }
                case 65: 
                case 66: 
                case 72: 
                case 90: 
                case 97: 
                case 98: 
                case 104: {
                    Pack.pack_h(context, list2, result2, packInts, type2, occurrences, isStar);
                    continue block16;
                }
                case 120: {
                    Pack.grow(result2, sNil10, occurrences);
                    continue block16;
                }
                case 88: {
                    Pack.pack_X(context, result2, occurrences);
                    continue block16;
                }
                case 64: {
                    Pack.pack_at(result2, occurrences);
                    continue block16;
                }
                case 109: 
                case 117: {
                    Pack.pack_m(context, list2, result2, packInts, (char)type2, occurrences, ignoreStar);
                    continue block16;
                }
                case 77: {
                    Pack.pack_M(context, list2, result2, packInts, occurrences);
                    continue block16;
                }
                case 85: {
                    Pack.pack_U(context, list2, result2, packInts, occurrences);
                    continue block16;
                }
                case 119: {
                    Pack.pack_w(context, list2, result2, packInts, occurrences);
                    continue block16;
                }
                case 32: {
                    continue block16;
                }
            }
            Pack.unknownDirective(context.runtime, "pack", type2, formatString);
        }
        switch (enc_info) {
            case 1: {
                buffer.setEncodingAndCodeRange((Encoding)USASCII, 16);
                break;
            }
            case 2: {
                buffer.associateEncoding((Encoding)UTF8);
                break;
            }
        }
        return buffer;
    }

    private static void unknownDirective(Ruby runtime2, String mode2, int type2, ByteList formatString) {
        ByteList unknown;
        if (EncodingUtils.isPrint(type2)) {
            unknown = new ByteList(new byte[]{(byte)type2});
        } else {
            unknown = new ByteList();
            Sprintf.sprintf(runtime2, unknown, (CharSequence)"\\x%02X", type2 & 0xFF);
        }
        runtime2.getWarnings().warning(RubyStringBuilder.str(runtime2, "unknown " + mode2 + " directive '", runtime2.newString(unknown), "' in '", runtime2.newString(formatString), "'"));
    }

    private static void pack_w(ThreadContext context, RubyArray list2, ByteList result2, PackInts packInts, int occurrences) {
        while (occurrences-- > 0) {
            long l;
            Object from;
            if (packInts.listSize-- <= 0) {
                throw context.runtime.newArgumentError(sTooFew);
            }
            if ((from = list2.eltInternal(packInts.idx++)) == context.nil) {
                throw context.runtime.newTypeError("pack('w') does not take nil");
            }
            ByteList buf = new ByteList();
            if (from instanceof RubyBignum) {
                RubyBignum big128 = RubyBignum.newBignum(context.runtime, 128L);
                while (from instanceof RubyBignum) {
                    RubyArray ary = (RubyArray)((RubyBignum)from).divmod(context, big128);
                    buf.append((byte)(RubyNumeric.fix2int(ary.eltInternal(1)) | 0x80) & 0xFF);
                    from = ary.eltInternal(0);
                }
            }
            if ((l = RubyNumeric.num2long(from)) >= 0L) {
                while (l != 0L) {
                    buf.append((byte)((l & 0x7FL | 0x80L) & 0xFFL));
                    l >>= 7;
                }
                int left2 = 0;
                int right = buf.getRealSize() - 1;
                if (right >= 0) {
                    byte[] byArray = buf.getUnsafeBytes();
                    byArray[0] = (byte)(byArray[0] & 0x7F);
                } else {
                    buf.append(0);
                }
                while (left2 < right) {
                    byte tmp = buf.getUnsafeBytes()[left2];
                    buf.getUnsafeBytes()[left2] = buf.getUnsafeBytes()[right];
                    buf.getUnsafeBytes()[right] = tmp;
                    ++left2;
                    --right;
                }
                result2.append(buf);
                continue;
            }
            throw context.runtime.newArgumentError("can't compress negative numbers");
        }
    }

    private static void pack_U(ThreadContext context, RubyArray list2, ByteList result2, PackInts packInts, int occurrences) {
        while (occurrences-- > 0) {
            Object from;
            int code;
            if (packInts.listSize-- <= 0) {
                throw context.runtime.newArgumentError(sTooFew);
            }
            int n = code = (from = list2.eltInternal(packInts.idx++)) == context.nil ? 0 : RubyNumeric.num2int(from);
            if (code < 0) {
                throw context.runtime.newRangeError("pack(U): value out of range");
            }
            int len = result2.getRealSize();
            result2.ensure(len + 6);
            result2.setRealSize(len + Pack.utf8Decode(context.runtime, result2.getUnsafeBytes(), result2.getBegin() + len, code));
        }
    }

    private static void pack_M(ThreadContext context, RubyArray list2, ByteList result2, PackInts packInts, int occurrences) {
        Object from;
        ByteList lCurElemString;
        if (packInts.listSize-- <= 0) {
            throw context.runtime.newArgumentError(sTooFew);
        }
        ByteList byteList = lCurElemString = (from = list2.eltInternal(packInts.idx++)) == context.nil ? ByteList.EMPTY_BYTELIST : from.asString().getByteList();
        if (occurrences <= 1) {
            occurrences = 72;
        }
        PackUtils.qpencode(result2, lCurElemString, occurrences);
    }

    private static void pack_h(ThreadContext context, RubyArray list2, ByteList result2, PackInts packInts, int type2, int occurrences, boolean isStar) {
        Object from;
        ByteList lCurElemString;
        if (packInts.listSize-- <= 0) {
            throw context.runtime.newArgumentError(sTooFew);
        }
        ByteList byteList = lCurElemString = (from = list2.eltInternal(packInts.idx++)) == context.nil ? ByteList.EMPTY_BYTELIST : from.convertToString().getByteList();
        if (isStar) {
            occurrences = lCurElemString.length();
            if (type2 == 90) {
                ++occurrences;
            }
        }
        Pack.pack_h_inner(result2, type2, lCurElemString, occurrences);
    }

    private static void pack_m(ThreadContext context, RubyArray list2, ByteList result2, PackInts packInts, char type2, int occurrences, boolean ignoreStar) {
        Object from;
        if (packInts.listSize-- <= 0) {
            throw context.runtime.newArgumentError(sTooFew);
        }
        if ((from = list2.eltInternal(packInts.idx++)) == context.nil) {
            throw context.runtime.newTypeError((IRubyObject)from, "Integer");
        }
        ByteList lCurElemString = from.convertToString().getByteList();
        Pack.encodeUM(context.runtime, lCurElemString, occurrences, ignoreStar, type2, result2);
    }

    private static void pack_at(ByteList result2, int occurrences) {
        if ((occurrences -= result2.length()) > 0) {
            Pack.grow(result2, sNil10, occurrences);
        }
        if ((occurrences = -occurrences) > 0) {
            Pack.shrink(result2, occurrences);
        }
    }

    private static void pack_X(ThreadContext context, ByteList result2, int occurrences) {
        try {
            Pack.shrink(result2, occurrences);
        }
        catch (IllegalArgumentException e) {
            throw context.runtime.newArgumentError("in `pack': X outside of string");
        }
    }

    private static void pack_h_inner(ByteList result2, int type2, ByteList lCurElemString, int occurrences) {
        switch (type2) {
            case 65: 
            case 90: 
            case 97: {
                Pack.pack_h_aAZ(result2, type2, lCurElemString, occurrences);
                break;
            }
            case 98: {
                Pack.pack_h_b(result2, lCurElemString, occurrences);
                break;
            }
            case 66: {
                Pack.pack_h_B(result2, lCurElemString, occurrences);
                break;
            }
            case 104: {
                Pack.pack_h_h(result2, lCurElemString, occurrences);
                break;
            }
            case 72: {
                Pack.pack_h_H(result2, lCurElemString, occurrences);
            }
        }
    }

    private static void pack_h_H(ByteList result2, ByteList lCurElemString, int occurrences) {
        int currentByte = 0;
        int padLength = 0;
        if (occurrences > lCurElemString.length()) {
            padLength = occurrences - lCurElemString.length() + 1;
            occurrences = lCurElemString.length();
        }
        int i2 = 0;
        while (i2 < occurrences) {
            byte currentChar;
            currentByte = Character.isJavaIdentifierStart(currentChar = (byte)lCurElemString.charAt(i2++)) ? (currentByte |= (currentChar & 0xF) + 9 & 0xF) : (currentByte |= currentChar & 0xF);
            if ((i2 & 1) != 0) {
                currentByte <<= 4;
                continue;
            }
            result2.append((byte)(currentByte & 0xFF));
            currentByte = 0;
        }
        if ((occurrences & 1) != 0) {
            result2.append((byte)(currentByte & 0xFF));
            if (padLength > 0) {
                --padLength;
            }
        }
        result2.length(result2.length() + padLength / 2);
    }

    private static void pack_h_h(ByteList result2, ByteList lCurElemString, int occurrences) {
        int currentByte = 0;
        int padLength = 0;
        if (occurrences > lCurElemString.length()) {
            padLength = occurrences - lCurElemString.length() + 1;
            occurrences = lCurElemString.length();
        }
        int i2 = 0;
        while (i2 < occurrences) {
            byte currentChar;
            currentByte = Character.isJavaIdentifierStart(currentChar = (byte)lCurElemString.charAt(i2++)) ? (currentByte |= ((currentChar & 0xF) + 9 & 0xF) << 4) : (currentByte |= (currentChar & 0xF) << 4);
            if ((i2 & 1) != 0) {
                currentByte >>= 4;
                continue;
            }
            result2.append((byte)(currentByte & 0xFF));
            currentByte = 0;
        }
        if ((occurrences & 1) != 0) {
            result2.append((byte)(currentByte & 0xFF));
            if (padLength > 0) {
                --padLength;
            }
        }
        result2.length(result2.length() + padLength / 2);
    }

    private static void pack_h_B(ByteList result2, ByteList lCurElemString, int occurrences) {
        int currentByte = 0;
        int padLength = 0;
        if (occurrences > lCurElemString.length()) {
            padLength = (occurrences - lCurElemString.length()) / 2 + (occurrences + lCurElemString.length()) % 2;
            occurrences = lCurElemString.length();
        }
        int i2 = 0;
        while (i2 < occurrences) {
            currentByte |= lCurElemString.charAt(i2++) & '\u0001';
            if ((i2 & 7) == 0) {
                result2.append((byte)(currentByte & 0xFF));
                currentByte = 0;
                continue;
            }
            currentByte <<= 1;
        }
        if ((occurrences & 7) != 0) {
            result2.append((byte)((currentByte <<= 7 - (occurrences & 7)) & 0xFF));
        }
        result2.length(result2.length() + padLength);
    }

    private static void pack_h_b(ByteList result2, ByteList lCurElemString, int occurrences) {
        int currentByte = 0;
        int padLength = 0;
        if (occurrences > lCurElemString.length()) {
            padLength = (occurrences - lCurElemString.length()) / 2 + (occurrences + lCurElemString.length()) % 2;
            occurrences = lCurElemString.length();
        }
        int i2 = 0;
        while (i2 < occurrences) {
            if ((lCurElemString.charAt(i2++) & '\u0001') != 0) {
                currentByte |= 0x80;
            }
            if ((i2 & 7) == 0) {
                result2.append((byte)(currentByte & 0xFF));
                currentByte = 0;
                continue;
            }
            currentByte >>= 1;
        }
        if ((occurrences & 7) != 0) {
            result2.append((byte)((currentByte >>= 7 - (occurrences & 7)) & 0xFF));
        }
        result2.length(result2.length() + padLength);
    }

    private static void pack_h_aAZ(ByteList result2, int type2, ByteList lCurElemString, int occurrences) {
        if (lCurElemString.length() >= occurrences) {
            result2.append(lCurElemString.getUnsafeBytes(), lCurElemString.getBegin(), occurrences);
        } else {
            result2.append(lCurElemString);
            occurrences -= lCurElemString.length();
            switch (type2) {
                case 90: 
                case 97: {
                    Pack.grow(result2, sNil10, occurrences);
                    break;
                }
                default: {
                    Pack.grow(result2, sSp10, occurrences);
                }
            }
        }
    }

    private static int adjustEncInfo(int type2, int enc_info) {
        switch (type2) {
            case 85: {
                if (enc_info != 1) break;
                enc_info = 2;
                break;
            }
            case 77: 
            case 109: 
            case 117: {
                break;
            }
            default: {
                enc_info = 0;
            }
        }
        return enc_info;
    }

    private static int decodeIntLittleEndian(ByteBuffer encode2) {
        encode2.order(ByteOrder.LITTLE_ENDIAN);
        int value2 = encode2.getInt();
        encode2.order(ByteOrder.BIG_ENDIAN);
        return value2;
    }

    private static int decodeIntBigEndian(ByteBuffer encode2) {
        return encode2.getInt();
    }

    private static long decodeIntUnsignedBigEndian(ByteBuffer encode2) {
        return (long)encode2.getInt() & 0xFFFFFFFFL;
    }

    private static long decodeIntUnsignedLittleEndian(ByteBuffer encode2) {
        encode2.order(ByteOrder.LITTLE_ENDIAN);
        long value2 = (long)encode2.getInt() & 0xFFFFFFFFL;
        encode2.order(ByteOrder.BIG_ENDIAN);
        return value2;
    }

    private static void encodeIntLittleEndian(ByteList result2, int s2) {
        result2.append((byte)(s2 & 0xFF)).append((byte)(s2 >> 8 & 0xFF));
        result2.append((byte)(s2 >> 16 & 0xFF)).append((byte)(s2 >> 24 & 0xFF));
    }

    private static void encodeIntBigEndian(ByteList result2, int s2) {
        result2.append((byte)(s2 >> 24 & 0xFF)).append((byte)(s2 >> 16 & 0xFF));
        result2.append((byte)(s2 >> 8 & 0xFF)).append((byte)(s2 & 0xFF));
    }

    private static long decodeLongBigEndian(ByteBuffer encode2) {
        int c1 = Pack.decodeIntBigEndian(encode2);
        int c2 = Pack.decodeIntBigEndian(encode2);
        return ((long)c1 << 32) + ((long)c2 & 0xFFFFFFFFL);
    }

    private static long decodeLongLittleEndian(ByteBuffer encode2) {
        int c1 = Pack.decodeIntLittleEndian(encode2);
        int c2 = Pack.decodeIntLittleEndian(encode2);
        return ((long)c2 << 32) + ((long)c1 & 0xFFFFFFFFL);
    }

    private static void encodeLongLittleEndian(ByteList result2, long l) {
        Pack.encodeIntLittleEndian(result2, (int)(l & 0xFFFFFFFFFFFFFFFFL));
        Pack.encodeIntLittleEndian(result2, (int)(l >>> 32));
    }

    private static void encodeLongBigEndian(ByteList result2, long l) {
        Pack.encodeIntBigEndian(result2, (int)(l >>> 32));
        Pack.encodeIntBigEndian(result2, (int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    private static double decodeDoubleLittleEndian(ByteBuffer encode2) {
        return Double.longBitsToDouble(Pack.decodeLongLittleEndian(encode2));
    }

    private static double decodeDoubleBigEndian(ByteBuffer encode2) {
        return Double.longBitsToDouble(Pack.decodeLongBigEndian(encode2));
    }

    private static void encodeDoubleLittleEndian(ByteList result2, double d) {
        Pack.encodeLongLittleEndian(result2, Double.doubleToRawLongBits(d));
    }

    private static void encodeDoubleBigEndian(ByteList result2, double d) {
        Pack.encodeLongBigEndian(result2, Double.doubleToRawLongBits(d));
    }

    private static float decodeFloatBigEndian(ByteBuffer encode2) {
        return Float.intBitsToFloat(Pack.decodeIntBigEndian(encode2));
    }

    private static float decodeFloatLittleEndian(ByteBuffer encode2) {
        return Float.intBitsToFloat(Pack.decodeIntLittleEndian(encode2));
    }

    private static void encodeFloatLittleEndian(ByteList result2, float f) {
        Pack.encodeIntLittleEndian(result2, Float.floatToRawIntBits(f));
    }

    private static void encodeFloatBigEndian(ByteList result2, float f) {
        Pack.encodeIntBigEndian(result2, Float.floatToRawIntBits(f));
    }

    private static int decodeShortUnsignedLittleEndian(ByteBuffer encode2) {
        encode2.order(ByteOrder.LITTLE_ENDIAN);
        int value2 = encode2.getShort() & 0xFFFF;
        encode2.order(ByteOrder.BIG_ENDIAN);
        return value2;
    }

    private static int decodeShortUnsignedBigEndian(ByteBuffer encode2) {
        int value2 = encode2.getShort() & 0xFFFF;
        return value2;
    }

    private static int decodeShortLittleEndian(ByteBuffer encode2) {
        encode2.order(ByteOrder.LITTLE_ENDIAN);
        short value2 = encode2.getShort();
        encode2.order(ByteOrder.BIG_ENDIAN);
        return value2;
    }

    private static short decodeShortBigEndian(ByteBuffer encode2) {
        return encode2.getShort();
    }

    private static void encodeShortLittleEndian(ByteList result2, int s2) {
        result2.append((byte)(s2 & 0xFF)).append((byte)((s2 & 0xFF00) >> 8));
    }

    private static void encodeShortBigEndian(ByteList result2, int s2) {
        result2.append((byte)((s2 & 0xFF00) >> 8)).append((byte)(s2 & 0xFF));
    }

    static {
        Converter tmp;
        int i2;
        sSp10 = "          ".getBytes();
        sNil10 = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes();
        ASCII = ASCIIEncoding.INSTANCE;
        USASCII = USASCIIEncoding.INSTANCE;
        UTF8 = UTF8Encoding.INSTANCE;
        ENDIANESS_CODES = new String(new char[]{'\u0130', '\u0110', '\u0126', '\u0106', '\u0129', '\u0109', '\u012e', '\u010e', '\u0127', '\u0107', '\u00af', '\u008f', '\u00a5', '\u0085', '\u00a8', '\u0088', '\u00ad', '\u008d', '\u00a6', '\u0086'});
        b64_xtable = new int[256];
        converters = new Converter[512];
        uu_table = ByteList.plain("`!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_");
        b64_table = ByteList.plain("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
        sHexDigits = ByteList.plain("0123456789abcdef0123456789ABCDEFx");
        for (i2 = 0; i2 < 256; ++i2) {
            Pack.b64_xtable[i2] = -1;
        }
        for (i2 = 0; i2 < 64; ++i2) {
            Pack.b64_xtable[Pack.b64_table[i2]] = i2;
        }
        Pack.converters[101] = new Converter(4){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime2, Pack.decodeFloatLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                Pack.encodeFloatLittleEndian(result2, Pack.obj2flt(runtime2, o));
            }
        };
        Pack.converters[103] = new Converter(4){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime2, Pack.decodeFloatBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                Pack.encodeFloatBigEndian(result2, Pack.obj2flt(runtime2, o));
            }
        };
        Pack.converters[70] = tmp = new Converter(4){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime2, Platform.BYTE_ORDER == 4321 ? (double)Pack.decodeFloatBigEndian(enc) : (double)Pack.decodeFloatLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                if (Platform.BYTE_ORDER == 4321) {
                    Pack.encodeFloatBigEndian(result2, Pack.obj2flt(runtime2, o));
                } else {
                    Pack.encodeFloatLittleEndian(result2, Pack.obj2flt(runtime2, o));
                }
            }
        };
        Pack.converters[102] = tmp;
        Pack.converters[69] = new Converter(8){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime2, Pack.decodeDoubleLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                Pack.encodeDoubleLittleEndian(result2, Pack.obj2dbl(runtime2, o));
            }
        };
        Pack.converters[71] = new Converter(8){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime2, Pack.decodeDoubleBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                Pack.encodeDoubleBigEndian(result2, Pack.obj2dbl(runtime2, o));
            }
        };
        Pack.converters[68] = tmp = new Converter(8){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                if (Platform.BYTE_ORDER == 4321) {
                    return RubyFloat.newFloat(runtime2, Pack.decodeDoubleBigEndian(enc));
                }
                return RubyFloat.newFloat(runtime2, Pack.decodeDoubleLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                Pack.encodeDoubleLittleEndian(result2, Pack.obj2dbl(runtime2, o));
            }
        };
        Pack.converters[100] = tmp;
        Pack.converters[118] = tmp = new QuadConverter(2, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeShortUnsignedLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                Pack.encodeShortLittleEndian(result2, this.overflowQuad(Pack.num2quad(o)));
            }
        };
        Pack.converters[143] = tmp;
        Pack.converters[110] = tmp = new QuadConverter(2, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeShortUnsignedBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                Pack.encodeShortBigEndian(result2, this.overflowQuad(Pack.num2quad(o)));
            }
        };
        Pack.converters[272] = tmp;
        Pack.converters[115] = new QuadConverter(2, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Platform.BYTE_ORDER == 4321 ? Pack.decodeShortBigEndian(enc) : Pack.decodeShortLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                this.encodeShortByByteOrder(result2, this.overflowQuad(Pack.num2quad(o)));
            }
        };
        Pack.converters[83] = new QuadConverter(2, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Platform.BYTE_ORDER == 4321 ? Pack.decodeShortUnsignedBigEndian(enc) : Pack.decodeShortUnsignedLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                this.encodeShortByByteOrder(result2, this.overflowQuad(Pack.num2quad(o)));
            }
        };
        Pack.converters[175] = new QuadConverter(2, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeShortLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                Pack.encodeShortLittleEndian(result2, this.overflowQuad(Pack.num2quad(o)));
            }
        };
        Pack.converters[304] = new QuadConverter(2, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeShortBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                Pack.encodeShortBigEndian(result2, this.overflowQuad(Pack.num2quad(o)));
            }
        };
        Pack.converters[99] = new Converter(1, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                int c = enc.get();
                return runtime2.newFixnum(c > 127 ? c - 256 : c);
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                byte c = (byte)(Pack.num2quad(o) & 0xFFL);
                result2.append(c);
            }
        };
        Pack.converters[67] = new Converter(1, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(enc.get() & 0xFF);
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                byte c = o == runtime2.getNil() ? (byte)0 : (byte)(Pack.num2quad(o) & 0xFFL);
                result2.append(c);
            }
        };
        Pack.converters[86] = tmp = new Converter(4, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeIntUnsignedLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                Pack.encodeIntLittleEndian(result2, (int)RubyNumeric.num2long(o));
            }
        };
        Pack.converters[136] = tmp;
        Pack.converters[133] = tmp;
        if (Platform.BIT_WIDTH == 32) {
            Pack.converters[134] = tmp;
        }
        Pack.converters[78] = tmp = new Converter(4, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeIntUnsignedBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                Pack.encodeIntBigEndian(result2, (int)RubyNumeric.num2long(o));
            }
        };
        Pack.converters[265] = tmp;
        Pack.converters[262] = tmp;
        if (Platform.BIT_WIDTH == 32) {
            Pack.converters[263] = tmp;
        }
        Pack.converters[73] = tmp = new Converter(4, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                if (Platform.BYTE_ORDER == 4321) {
                    return runtime2.newFixnum(Pack.decodeIntUnsignedBigEndian(enc));
                }
                return runtime2.newFixnum(Pack.decodeIntUnsignedLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                int s2 = o == runtime2.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.packInt_i(result2, s2);
            }
        };
        Pack.converters[76] = tmp;
        if (Platform.BIT_WIDTH == 32) {
            Pack.converters[74] = tmp;
        }
        Pack.converters[105] = tmp = new Converter(4, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                int value2 = Pack.unpackInt_i(enc);
                return runtime2.newFixnum(value2);
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                int s2 = o == runtime2.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.packInt_i(result2, s2);
            }
        };
        Pack.converters[108] = tmp;
        if (Platform.BIT_WIDTH == 32) {
            Pack.converters[106] = tmp;
        }
        Pack.converters[165] = tmp = new Converter(4, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeIntLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                int s2 = o == runtime2.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.encodeIntLittleEndian(result2, s2);
            }
        };
        Pack.converters[168] = tmp;
        if (Platform.BIT_WIDTH == 32) {
            Pack.converters[166] = tmp;
        }
        Pack.converters[294] = tmp = new Converter(4, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeIntBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                int s2 = o == runtime2.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.encodeIntBigEndian(result2, s2);
            }
        };
        Pack.converters[297] = tmp;
        if (Platform.BIT_WIDTH == 32) {
            Pack.converters[295] = tmp;
        }
        Pack.converters[81] = tmp = new QuadConverter(8, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                long l = Platform.BYTE_ORDER == 4321 ? Pack.decodeLongBigEndian(enc) : Pack.decodeLongLittleEndian(enc);
                return RubyBignum.bignorm(runtime2, BigInteger.valueOf(l).and(new BigInteger("FFFFFFFFFFFFFFFF", 16)));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                this.encodeLongByByteOrder(result2, Pack.num2quad(o));
            }
        };
        if (Platform.BIT_WIDTH == 64) {
            Pack.converters[74] = tmp;
        }
        Pack.converters[141] = tmp = new QuadConverter(8, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                long l = Pack.decodeLongLittleEndian(enc);
                return RubyBignum.bignorm(runtime2, BigInteger.valueOf(l).and(new BigInteger("FFFFFFFFFFFFFFFF", 16)));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                Pack.encodeLongLittleEndian(result2, Pack.num2quad(o));
            }
        };
        if (Platform.BIT_WIDTH == 64) {
            Pack.converters[134] = tmp;
        }
        Pack.converters[270] = tmp = new QuadConverter(8, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                long l = Pack.decodeLongBigEndian(enc);
                return RubyBignum.bignorm(runtime2, BigInteger.valueOf(l).and(new BigInteger("FFFFFFFFFFFFFFFF", 16)));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                Pack.encodeLongBigEndian(result2, Pack.num2quad(o));
            }
        };
        if (Platform.BIT_WIDTH == 64) {
            Pack.converters[263] = tmp;
        }
        Pack.converters[113] = tmp = new QuadConverter(8, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Platform.BYTE_ORDER == 4321 ? Pack.decodeLongBigEndian(enc) : Pack.decodeLongLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                this.encodeLongByByteOrder(result2, Pack.num2quad(o));
            }
        };
        if (Platform.BIT_WIDTH == 64) {
            Pack.converters[106] = tmp;
        }
        Pack.converters[173] = tmp = new QuadConverter(8, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeLongLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                Pack.encodeLongLittleEndian(result2, Pack.num2quad(o));
            }
        };
        if (Platform.BIT_WIDTH == 64) {
            Pack.converters[166] = tmp;
        }
        Pack.converters[302] = tmp = new QuadConverter(8, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime2, ByteBuffer enc) {
                return runtime2.newFixnum(Pack.decodeLongBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime2, IRubyObject o, ByteList result2) {
                Pack.encodeLongBigEndian(result2, Pack.num2quad(o));
            }
        };
        if (Platform.BIT_WIDTH == 64) {
            Pack.converters[295] = tmp;
        }
        utf8_limits = new long[]{0L, 128L, 2048L, 65536L, 0x200000L, 0x4000000L, Integer.MIN_VALUE};
    }

    private static class PackInts {
        int listSize;
        int idx;

        PackInts(int listSize, int idx) {
            this.listSize = listSize;
            this.idx = idx;
        }
    }

    private static abstract class QuadConverter
    extends Converter {
        public QuadConverter(int size2, String type2) {
            super(size2, type2);
        }

        public QuadConverter(int size2) {
            super(size2);
        }

        protected int overflowQuad(long quad) {
            return (int)(quad & 0xFFFFL);
        }

        protected void encodeShortByByteOrder(ByteList result2, int s2) {
            if (Platform.BYTE_ORDER == 4321) {
                Pack.encodeShortBigEndian(result2, s2);
            } else {
                Pack.encodeShortLittleEndian(result2, s2);
            }
        }

        protected void encodeLongByByteOrder(ByteList result2, long l) {
            if (Platform.BYTE_ORDER == 4321) {
                Pack.encodeLongBigEndian(result2, l);
            } else {
                Pack.encodeLongLittleEndian(result2, l);
            }
        }
    }

    public static abstract class Converter {
        public final int size;
        public final String type;

        public Converter(int size2) {
            this(size2, null);
        }

        public Converter(int size2, String type2) {
            this.size = size2;
            this.type = type2;
        }

        public String getType() {
            return this.type;
        }

        public abstract IRubyObject decode(Ruby var1, ByteBuffer var2);

        public abstract void encode(Ruby var1, IRubyObject var2, ByteList var3);
    }

    private static abstract class ConverterExecutor {
        protected Converter converter;

        private ConverterExecutor() {
        }

        public void setConverter(Converter converter) {
            this.converter = converter;
        }

        public abstract IRubyObject decode(Ruby var1, ByteBuffer var2);

        public abstract void encode(Ruby var1, IRubyObject var2, ByteList var3);
    }
}

