/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.inference.ConeTypeVariableForLambdaReturnType;
import org.jetbrains.kotlin.fir.resolve.inference.ResolvedLambdaAtom;
import org.jetbrains.kotlin.fir.scopes.FakeOverrideTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\u001a@\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u001a.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a'\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\u001a$\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!\u001a0\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010#*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u0016\u001a\u001c\u0010&\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001b\u001a\u0016\u0010'\u001a\u0004\u0018\u00010(*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0012\u0010)\u001a\u00020\u0016*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u0010*\u001a\u00020\u0016*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\n\u0010+\u001a\u00020\u0016*\u00020\u0001\u001a\u0012\u0010,\u001a\u00020\u0016*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u0010-\u001a\u00020\u0016*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u001a\u0010.\u001a\u00020\u0016*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001b\u001a\u0012\u0010/\u001a\u00020\u0016*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u00100\u001a\u00020\u001b*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u00101\u001a\u00020\u001b*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u001a\u00102\u001a\u00020\u001b*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00103\u001a\u00020\u001a\u001a\u001a\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00f2\u0001\u0004\n\u00020\u001b\u00a8\u00065"}, d2={"receiverType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "getReceiverType", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "returnType", "getReturnType", "extractLambdaInfoFromFunctionalType", "Lorg/jetbrains/kotlin/fir/resolve/inference/ResolvedLambdaAtom;", "expectedType", "expectedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "argument", "returnTypeVariable", "Lorg/jetbrains/kotlin/fir/resolve/inference/ConeTypeVariableForLambdaReturnType;", "components", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "extractLambdaParameters", "", "expectedTypeIsExtensionFunctionType", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "extractParametersForFunctionalType", "isExtensionFunctionType", "findBaseInvokeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "findContributedInvokeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "expectedFunctionalType", "shouldCalculateReturnTypesOfFakeOverrides", "findSubtypeOfNonSuspendFunctionalType", "functionClassKind", "Lorg/jetbrains/kotlin/builtins/functions/FunctionClassKind;", "isBuiltinFunctionalType", "isFunctionalType", "isKClassType", "isKFunctionType", "isKMutableProperty", "isSubtypeOfFunctionalType", "isSuspendFunctionType", "kFunctionTypeToFunctionType", "suspendFunctionTypeToFunctionType", "suspendFunctionTypeToFunctionTypeWithContinuation", "continuationClassId", "valueParameterTypesIncludingReceiver", "resolve"})
public final class InferenceUtilsKt {
    private static final ClassId classId(ConeKotlinType $this$classId, FirSession session2) {
        boolean bl = false;
        if (!($this$classId instanceof ConeClassLikeType)) {
            return null;
        }
        return TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$classId, session2, null, 2, null).getLookupTag().getClassId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKMutableProperty(@NotNull ConeKotlinType $this$isKMutableProperty, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isKMutableProperty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Object object = InferenceUtilsKt.classId($this$isKMutableProperty, session2);
        if (object == null) {
            return false;
        }
        Object classId = object;
        if (!Intrinsics.areEqual((Object)((ClassId)classId).getPackageFqName(), (Object)StandardClassIds.INSTANCE.getBASE_REFLECT_PACKAGE())) return false;
        object = ((ClassId)classId).getShortClassName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classId.shortClassName.identifier");
        if (!StringsKt.startsWith$default((String)object, (String)"KMutableProperty", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final FunctionClassKind functionClassKind(ConeKotlinType $this$functionClassKind, FirSession session2) {
        Object object = InferenceUtilsKt.classId($this$functionClassKind, session2);
        if (object == null) {
            return null;
        }
        ClassId classId = object;
        object = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classId.packageFqName");
        Object object2 = object;
        object = classId.getRelativeClassName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classId.relativeClassName.asString()");
        return FunctionClassKind.Companion.byClassNamePrefix((FqName)object2, (String)object);
    }

    public static final boolean isBuiltinFunctionalType(@NotNull ConeKotlinType $this$isBuiltinFunctionalType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltinFunctionalType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FunctionClassKind functionClassKind = InferenceUtilsKt.functionClassKind($this$isBuiltinFunctionalType, session2);
        if (functionClassKind == null) {
            return false;
        }
        FunctionClassKind kind = functionClassKind;
        return kind == FunctionClassKind.Function || kind == FunctionClassKind.KFunction || kind == FunctionClassKind.SuspendFunction || kind == FunctionClassKind.KSuspendFunction;
    }

    public static final boolean isFunctionalType(@NotNull ConeKotlinType $this$isFunctionalType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionalType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FunctionClassKind functionClassKind = InferenceUtilsKt.functionClassKind($this$isFunctionalType, session2);
        if (functionClassKind == null) {
            return false;
        }
        FunctionClassKind kind = functionClassKind;
        return kind == FunctionClassKind.Function;
    }

    public static final boolean isSuspendFunctionType(@NotNull ConeKotlinType $this$isSuspendFunctionType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FunctionClassKind functionClassKind = InferenceUtilsKt.functionClassKind($this$isSuspendFunctionType, session2);
        if (functionClassKind == null) {
            return false;
        }
        FunctionClassKind kind = functionClassKind;
        return kind == FunctionClassKind.SuspendFunction || kind == FunctionClassKind.KSuspendFunction;
    }

    public static final boolean isKFunctionType(@NotNull ConeKotlinType $this$isKFunctionType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isKFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FunctionClassKind functionClassKind = InferenceUtilsKt.functionClassKind($this$isKFunctionType, session2);
        if (functionClassKind == null) {
            return false;
        }
        FunctionClassKind kind = functionClassKind;
        return kind == FunctionClassKind.KFunction || kind == FunctionClassKind.KSuspendFunction;
    }

    @NotNull
    public static final ConeClassLikeType kFunctionTypeToFunctionType(@NotNull ConeKotlinType $this$kFunctionTypeToFunctionType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$kFunctionTypeToFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        boolean bl = InferenceUtilsKt.isKFunctionType($this$kFunctionTypeToFunctionType, session2);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        FunctionClassKind kind = InferenceUtilsKt.isSuspendFunctionType($this$kFunctionTypeToFunctionType, session2) ? FunctionClassKind.SuspendFunction : FunctionClassKind.Function;
        ClassId functionalTypeId = new ClassId(kind.getPackageFqName(), kind.numberedClassName($this$kFunctionTypeToFunctionType.getTypeArguments().length - 1));
        return new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(functionalTypeId), $this$kFunctionTypeToFunctionType.getTypeArguments(), false, null, 8, null);
    }

    @NotNull
    public static final ConeClassLikeType suspendFunctionTypeToFunctionType(@NotNull ConeKotlinType $this$suspendFunctionTypeToFunctionType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendFunctionTypeToFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        boolean bl = InferenceUtilsKt.isSuspendFunctionType($this$suspendFunctionTypeToFunctionType, session2);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        FunctionClassKind kind = InferenceUtilsKt.isKFunctionType($this$suspendFunctionTypeToFunctionType, session2) ? FunctionClassKind.KFunction : FunctionClassKind.Function;
        ClassId functionalTypeId = new ClassId(kind.getPackageFqName(), kind.numberedClassName($this$suspendFunctionTypeToFunctionType.getTypeArguments().length - 1));
        return new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(functionalTypeId), $this$suspendFunctionTypeToFunctionType.getTypeArguments(), false, $this$suspendFunctionTypeToFunctionType.getAttributes());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeClassLikeType suspendFunctionTypeToFunctionTypeWithContinuation(@NotNull ConeKotlinType $this$suspendFunctionTypeToFunctionTypeWithContinuation, @NotNull FirSession session2, @NotNull ClassId continuationClassId) {
        void $this$toTypedArray$iv;
        Intrinsics.checkNotNullParameter((Object)$this$suspendFunctionTypeToFunctionTypeWithContinuation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)continuationClassId, (String)"continuationClassId");
        boolean bl = InferenceUtilsKt.isSuspendFunctionType($this$suspendFunctionTypeToFunctionTypeWithContinuation, session2);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        FunctionClassKind kind = InferenceUtilsKt.isKFunctionType($this$suspendFunctionTypeToFunctionTypeWithContinuation, session2) ? FunctionClassKind.KFunction : FunctionClassKind.Function;
        ClassId functionalTypeId = new ClassId(kind.getPackageFqName(), kind.numberedClassName($this$suspendFunctionTypeToFunctionTypeWithContinuation.getTypeArguments().length));
        Object object = new ConeTypeProjection[]{(ConeTypeProjection)ArraysKt.last((Object[])$this$suspendFunctionTypeToFunctionTypeWithContinuation.getType().getTypeArguments())};
        object = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)ArraysKt.dropLast((Object[])$this$suspendFunctionTypeToFunctionTypeWithContinuation.getType().getTypeArguments(), (int)1), (Object)TypeConstructionUtilsKt.constructClassType$default(new ConeClassLikeLookupTagImpl(continuationClassId), object, false, null, 4, null)), (Object)ArraysKt.last((Object[])$this$suspendFunctionTypeToFunctionTypeWithContinuation.getType().getTypeArguments()));
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeProjection[] coneTypeProjectionArray = thisCollection$iv.toArray(new ConeTypeProjection[0]);
        if (coneTypeProjectionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(functionalTypeId), coneTypeProjectionArray, false, $this$suspendFunctionTypeToFunctionTypeWithContinuation.getAttributes());
    }

    public static final boolean isSubtypeOfFunctionalType(@NotNull ConeKotlinType $this$isSubtypeOfFunctionalType, @NotNull FirSession session2, @NotNull ConeClassLikeType expectedFunctionalType) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOfFunctionalType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)expectedFunctionalType, (String)"expectedFunctionalType");
        boolean bl = InferenceUtilsKt.isBuiltinFunctionalType(expectedFunctionalType, session2);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, SessionUtilsKt.getTypeContext(session2), (KotlinTypeMarker)$this$isSubtypeOfFunctionalType, (KotlinTypeMarker)ConeTypeUtilsKt.replaceArgumentsWithStarProjections(expectedFunctionalType), false, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ConeKotlinType findSubtypeOfNonSuspendFunctionalType(@NotNull ConeKotlinType $this$findSubtypeOfNonSuspendFunctionalType, @NotNull FirSession session2, @NotNull ConeClassLikeType expectedFunctionalType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$findSubtypeOfNonSuspendFunctionalType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)expectedFunctionalType, (String)"expectedFunctionalType");
        boolean bl = InferenceUtilsKt.isBuiltinFunctionalType(expectedFunctionalType, session2) && !InferenceUtilsKt.isSuspendFunctionType(expectedFunctionalType, session2);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        ConeKotlinType coneKotlinType2 = $this$findSubtypeOfNonSuspendFunctionalType;
        if (coneKotlinType2 instanceof ConeClassLikeType) {
            coneKotlinType = InferenceUtilsKt.isSuspendFunctionType($this$findSubtypeOfNonSuspendFunctionalType, session2) || !InferenceUtilsKt.isSubtypeOfFunctionalType($this$findSubtypeOfNonSuspendFunctionalType, session2, expectedFunctionalType) ? null : (ConeClassLikeType)$this$findSubtypeOfNonSuspendFunctionalType;
        } else if (coneKotlinType2 instanceof ConeIntersectionType) {
            boolean bl6;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block22: {
                $this$any$iv = ((ConeIntersectionType)$this$findSubtypeOfNonSuspendFunctionalType).getIntersectedTypes();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl6 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl7 = false;
                        if (!InferenceUtilsKt.isSuspendFunctionType(it, session2)) continue;
                        bl6 = true;
                        break block22;
                    }
                    bl6 = false;
                }
            }
            if (bl6) {
                coneKotlinType = null;
            } else {
                Object v2;
                block23: {
                    $this$any$iv = ((ConeIntersectionType)$this$findSubtypeOfNonSuspendFunctionalType).getIntersectedTypes();
                    $i$f$any = false;
                    Iterable iterable = $this$any$iv;
                    boolean element$iv = false;
                    for (Object bl7 : iterable) {
                        ConeKotlinType it = (ConeKotlinType)bl7;
                        boolean bl8 = false;
                        if (!(InferenceUtilsKt.findSubtypeOfNonSuspendFunctionalType(it, session2, expectedFunctionalType) != null)) continue;
                        v2 = bl7;
                        break block23;
                    }
                    v2 = null;
                }
                coneKotlinType = v2;
            }
        } else if (coneKotlinType2 instanceof ConeTypeParameterType) {
            boolean bl9;
            List bounds;
            block24: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((FirTypeParameter)((ConeTypeParameterType)$this$findSubtypeOfNonSuspendFunctionalType).getLookupTag().getTypeParameterSymbol().getFir()).getBounds();
                boolean $i$f$map = false;
                Iterable element$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ConeKotlinType coneKotlinType3;
                    void it;
                    FirTypeRef firTypeRef = (FirTypeRef)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl10 = false;
                    void $this$coneType$iv = it;
                    boolean $i$f$getConeType = false;
                    void $this$coneTypeSafe$iv$iv = $this$coneType$iv;
                    boolean $i$f$coneTypeSafe = false;
                    boolean bl11 = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
                    ConeKotlinType coneKotlinType4 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                    if (!(coneKotlinType4 instanceof ConeKotlinType)) {
                        coneKotlinType4 = null;
                    }
                    if ((coneKotlinType3 = coneKotlinType4) == null) {
                        String string3 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default((FirElement)$this$coneType$iv, null, 1, null);
                        boolean bl12 = false;
                        throw (Throwable)new IllegalStateException(string3.toString());
                    }
                    ConeKotlinType coneKotlinType5 = coneKotlinType3;
                    collection.add(coneKotlinType5);
                }
                bounds = (List)destination$iv$iv;
                Iterable $this$any$iv = bounds;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl9 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv2;
                        boolean bl13 = false;
                        if (!InferenceUtilsKt.isSuspendFunctionType(it, session2)) continue;
                        bl9 = true;
                        break block24;
                    }
                    bl9 = false;
                }
            }
            if (bl9) {
                coneKotlinType = null;
            } else {
                Object v5;
                block25: {
                    Iterable iterable = bounds;
                    bl4 = false;
                    Iterable iterable2 = iterable;
                    boolean bl14 = false;
                    Iterator iterator2 = iterable2.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        ConeKotlinType it = (ConeKotlinType)t;
                        boolean bl15 = false;
                        if (!(InferenceUtilsKt.findSubtypeOfNonSuspendFunctionalType(it, session2, expectedFunctionalType) != null)) continue;
                        v5 = t;
                        break block25;
                    }
                    v5 = null;
                }
                coneKotlinType = v5;
            }
        } else {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    @Nullable
    public static final FirNamedFunctionSymbol findBaseInvokeSymbol(@NotNull ConeClassLikeType $this$findBaseInvokeSymbol, @NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        FirClass firClass;
        Intrinsics.checkNotNullParameter((Object)$this$findBaseInvokeSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        boolean bl = InferenceUtilsKt.isBuiltinFunctionalType($this$findBaseInvokeSymbol, session2);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol($this$findBaseInvokeSymbol.getLookupTag(), session2);
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir();
        FirClass firClass2 = firClass = firClassLikeDeclaration instanceof FirClass ? (FirClass)firClassLikeDeclaration : null;
        if (firClass == null) {
            return null;
        }
        FirClass functionN2 = firClass;
        Ref.ObjectRef baseInvokeSymbol = new Ref.ObjectRef();
        KotlinScopeProviderKt.unsubstitutedScope(functionN2, session2, scopeSession, false).processFunctionsByName(OperatorNameConventions.INVOKE, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>((Ref.ObjectRef<FirNamedFunctionSymbol>)baseInvokeSymbol){
            final /* synthetic */ Ref.ObjectRef<FirNamedFunctionSymbol> $baseInvokeSymbol;
            {
                this.$baseInvokeSymbol = $baseInvokeSymbol;
                super(1);
            }

            public final void invoke(@NotNull FirNamedFunctionSymbol functionSymbol) {
                Intrinsics.checkNotNullParameter((Object)functionSymbol, (String)"functionSymbol");
                this.$baseInvokeSymbol.element = functionSymbol;
            }
        }));
        return (FirNamedFunctionSymbol)baseInvokeSymbol.element;
    }

    @Nullable
    public static final FirFunctionSymbol<?> findContributedInvokeSymbol(@NotNull ConeKotlinType $this$findContributedInvokeSymbol, @NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull ConeClassLikeType expectedFunctionalType, boolean shouldCalculateReturnTypesOfFakeOverrides) {
        Intrinsics.checkNotNullParameter((Object)$this$findContributedInvokeSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)expectedFunctionalType, (String)"expectedFunctionalType");
        FirNamedFunctionSymbol firNamedFunctionSymbol = InferenceUtilsKt.findBaseInvokeSymbol(expectedFunctionalType, session2, scopeSession);
        if (firNamedFunctionSymbol == null) {
            return null;
        }
        FirNamedFunctionSymbol baseInvokeSymbol = firNamedFunctionSymbol;
        FakeOverrideTypeCalculator fakeOverrideTypeCalculator = shouldCalculateReturnTypesOfFakeOverrides ? (FakeOverrideTypeCalculator)FakeOverrideTypeCalculator.Forced.INSTANCE : (FakeOverrideTypeCalculator)FakeOverrideTypeCalculator.DoNothing.INSTANCE;
        FirTypeScope firTypeScope = ScopeUtilsKt.scope($this$findContributedInvokeSymbol, session2, scopeSession, fakeOverrideTypeCalculator);
        if (firTypeScope == null) {
            return null;
        }
        FirTypeScope scope2 = firTypeScope;
        Ref.ObjectRef declaredInvoke = new Ref.ObjectRef();
        scope2.processFunctionsByName(OperatorNameConventions.INVOKE, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(baseInvokeSymbol, (Ref.ObjectRef<FirNamedFunctionSymbol>)declaredInvoke){
            final /* synthetic */ FirNamedFunctionSymbol $baseInvokeSymbol;
            final /* synthetic */ Ref.ObjectRef<FirNamedFunctionSymbol> $declaredInvoke;
            {
                this.$baseInvokeSymbol = $baseInvokeSymbol;
                this.$declaredInvoke = $declaredInvoke;
                super(1);
            }

            public final void invoke(@NotNull FirNamedFunctionSymbol functionSymbol) {
                Intrinsics.checkNotNullParameter((Object)functionSymbol, (String)"functionSymbol");
                if (((FirSimpleFunction)functionSymbol.getFir()).getValueParameters().size() == ((FirSimpleFunction)this.$baseInvokeSymbol.getFir()).getValueParameters().size()) {
                    this.$declaredInvoke.element = functionSymbol;
                    return;
                }
            }
        }));
        Ref.ObjectRef overriddenInvoke = new Ref.ObjectRef();
        if (declaredInvoke.element != null) {
            Intrinsics.checkNotNull((Object)declaredInvoke.element);
            FirTypeScopeKt.processOverriddenFunctions(scope2, (FirNamedFunctionSymbol)declaredInvoke.element, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(baseInvokeSymbol, overriddenInvoke){
                final /* synthetic */ FirNamedFunctionSymbol $baseInvokeSymbol;
                final /* synthetic */ Ref.ObjectRef<FirFunctionSymbol<?>> $overriddenInvoke;
                {
                    this.$baseInvokeSymbol = $baseInvokeSymbol;
                    this.$overriddenInvoke = $overriddenInvoke;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol functionSymbol) {
                    ProcessorAction processorAction;
                    Intrinsics.checkNotNullParameter((Object)functionSymbol, (String)"functionSymbol");
                    if (!Intrinsics.areEqual((Object)functionSymbol, (Object)this.$baseInvokeSymbol)) {
                        FirCallableSymbol $this$originalForSubstitutionOverride$iv = functionSymbol;
                        boolean $i$f$getOriginalForSubstitutionOverride = false;
                        FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv = (FirCallableDeclaration)$this$originalForSubstitutionOverride$iv.getFir();
                        boolean $i$f$getOriginalForSubstitutionOverride2 = false;
                        FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv) : null;
                        if (!Intrinsics.areEqual((Object)((FirNamedFunctionSymbol)(firCallableDeclaration == null ? null : firCallableDeclaration.getSymbol())), (Object)this.$baseInvokeSymbol)) {
                            processorAction = ProcessorAction.NEXT;
                            return processorAction;
                        }
                    }
                    this.$overriddenInvoke.element = functionSymbol;
                    processorAction = ProcessorAction.STOP;
                    return processorAction;
                }
            }));
        }
        return overriddenInvoke.element != null ? (FirFunctionSymbol)declaredInvoke.element : null;
    }

    public static final boolean isKClassType(@NotNull ConeKotlinType $this$isKClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$isKClassType, (String)"<this>");
        return Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId($this$isKClassType), (Object)StandardClassIds.INSTANCE.getKClass());
    }

    @Nullable
    public static final ConeKotlinType receiverType(@NotNull ConeKotlinType $this$receiverType, @Nullable FirTypeRef expectedTypeRef, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$receiverType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (InferenceUtilsKt.isBuiltinFunctionalType($this$receiverType, session2) && TypeUtilsKt.isExtensionFunctionType($this$receiverType, session2)) {
            return ((ConeKotlinTypeProjection)ArraysKt.first((Object[])TypeExpansionUtilsKt.fullyExpandedType($this$receiverType, session2).getTypeArguments())).getType();
        }
        return null;
    }

    @Nullable
    public static final ConeKotlinType receiverType(@NotNull ConeKotlinType $this$receiverType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$receiverType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (InferenceUtilsKt.isBuiltinFunctionalType($this$receiverType, session2)) {
            return ((ConeKotlinTypeProjection)ArraysKt.first((Object[])TypeExpansionUtilsKt.fullyExpandedType($this$receiverType, session2).getTypeArguments())).getType();
        }
        return null;
    }

    @Nullable
    public static final ConeKotlinType returnType(@NotNull ConeKotlinType $this$returnType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$returnType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        boolean bl = $this$returnType instanceof ConeClassLikeType;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        ConeTypeProjection projection = (ConeTypeProjection)ArraysKt.last((Object[])TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$returnType, session2, null, 2, null).getTypeArguments());
        ConeKotlinTypeProjection coneKotlinTypeProjection = projection instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)projection : null;
        return coneKotlinTypeProjection == null ? null : coneKotlinTypeProjection.getType();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConeKotlinType> valueParameterTypesIncludingReceiver(@NotNull ConeKotlinType $this$valueParameterTypesIncludingReceiver, @NotNull FirSession session2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$valueParameterTypesIncludingReceiver, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        boolean bl = $this$valueParameterTypesIncludingReceiver instanceof ConeClassLikeType;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Iterable $this$map$iv = ArraysKt.dropLast((Object[])TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$valueParameterTypesIncludingReceiver, session2, null, 2, null).getTypeArguments(), (int)1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConeTypeProjection coneTypeProjection = (ConeTypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            ConeKotlinTypeProjection coneKotlinTypeProjection = it instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)it : null;
            ConeKotlinType coneKotlinType = coneKotlinTypeProjection == null ? null : coneKotlinTypeProjection.getType();
            collection.add(coneKotlinType);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ConeKotlinType getReturnType(@NotNull FirAnonymousFunction $this$returnType) {
        Intrinsics.checkNotNullParameter((Object)$this$returnType, (String)"<this>");
        FirTypeRef $this$coneTypeSafe$iv = $this$returnType.getReturnTypeRef();
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    @Nullable
    public static final ConeKotlinType getReceiverType(@NotNull FirAnonymousFunction $this$receiverType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$receiverType, (String)"<this>");
        FirTypeRef firTypeRef = $this$receiverType.getReceiverTypeRef();
        if (firTypeRef == null) {
            coneKotlinType = null;
        } else {
            FirTypeRef $this$coneTypeSafe$iv = firTypeRef;
            boolean $i$f$coneTypeSafe = false;
            boolean bl = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
        }
        return coneKotlinType;
    }

    @Nullable
    public static final ResolvedLambdaAtom extractLambdaInfoFromFunctionalType(@Nullable ConeKotlinType expectedType2, @Nullable FirTypeRef expectedTypeRef, @NotNull FirAnonymousFunction argument2, @Nullable ConeTypeVariableForLambdaReturnType returnTypeVariable, @NotNull BodyResolveComponents components2, @Nullable Candidate candidate2) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        FirSession session2 = components2.getSession();
        if (expectedType2 == null) {
            return null;
        }
        if (expectedType2 instanceof ConeFlexibleType) {
            return InferenceUtilsKt.extractLambdaInfoFromFunctionalType(((ConeFlexibleType)expectedType2).getLowerBound(), expectedTypeRef, argument2, returnTypeVariable, components2, candidate2);
        }
        if (!InferenceUtilsKt.isBuiltinFunctionalType(expectedType2, session2)) {
            return null;
        }
        ConeKotlinType coneKotlinType2 = InferenceUtilsKt.getReceiverType(argument2);
        ConeKotlinType receiverType = coneKotlinType2 == null ? InferenceUtilsKt.receiverType(expectedType2, expectedTypeRef, session2) : coneKotlinType2;
        ConeKotlinType coneKotlinType3 = InferenceUtilsKt.getReturnType(argument2);
        if (coneKotlinType3 == null) {
            ConeKotlinType coneKotlinType4 = InferenceUtilsKt.returnType(expectedType2, session2);
            if (coneKotlinType4 == null) {
                return null;
            }
            coneKotlinType = coneKotlinType4;
        } else {
            coneKotlinType = coneKotlinType3;
        }
        ConeKotlinType returnType2 = coneKotlinType;
        List<ConeKotlinType> parameters2 = InferenceUtilsKt.extractLambdaParameters(expectedType2, argument2, TypeUtilsKt.isExtensionFunctionType(expectedType2, session2), session2);
        return new ResolvedLambdaAtom(argument2, expectedType2, InferenceUtilsKt.isSuspendFunctionType(expectedType2, session2), receiverType, parameters2, returnType2, returnTypeVariable, candidate2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConeKotlinType> extractLambdaParameters(ConeKotlinType expectedType2, FirAnonymousFunction argument2, boolean expectedTypeIsExtensionFunctionType, FirSession session2) {
        void $this$mapIndexedTo$iv$iv;
        List<FirValueParameter> parameters2 = argument2.getValueParameters();
        List<ConeKotlinType> expectedParameters = InferenceUtilsKt.extractParametersForFunctionalType(expectedType2, expectedTypeIsExtensionFunctionType, session2);
        ConeClassLikeType nullableAnyType = argument2.getSession().getBuiltinTypes().getNullableAnyType().getType();
        if (parameters2.isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = expectedParameters;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ConeKotlinType coneKotlinType;
                void it;
                ConeKotlinType coneKotlinType2 = (ConeKotlinType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var16_25 = it;
                ConeKotlinType coneKotlinType3 = var16_25 == null ? (ConeKotlinType)nullableAnyType : ((coneKotlinType = var16_25.getType()) == null ? (ConeKotlinType)nullableAnyType : coneKotlinType);
                collection.add(coneKotlinType3);
            }
            return (List)destination$iv$iv;
        }
        Iterable $this$mapIndexed$iv = parameters2;
        boolean $i$f$mapIndexed = false;
        Iterable $this$mapTo$iv$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            ConeKotlinType coneKotlinType;
            ConeKotlinType coneKotlinType4;
            void parameter;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            FirTypeRef $this$coneTypeSafe$iv = parameter.getReturnTypeRef();
            boolean $i$f$coneTypeSafe = false;
            boolean bl3 = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType5 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType5 instanceof ConeKotlinType)) {
                coneKotlinType5 = null;
            }
            ConeKotlinType coneKotlinType6 = (coneKotlinType4 = coneKotlinType5) == null ? ((coneKotlinType = (ConeKotlinType)CollectionsKt.getOrNull(expectedParameters, (int)index2)) == null ? (ConeKotlinType)nullableAnyType : coneKotlinType) : coneKotlinType4;
            collection.add(coneKotlinType6);
        }
        return (List)destination$iv$iv;
    }

    private static final List<ConeKotlinType> extractParametersForFunctionalType(ConeKotlinType $this$extractParametersForFunctionalType, boolean isExtensionFunctionType, FirSession session2) {
        List list2 = InferenceUtilsKt.valueParameterTypesIncludingReceiver($this$extractParametersForFunctionalType, session2);
        boolean bl = false;
        boolean bl2 = false;
        List it = list2;
        boolean bl3 = false;
        return isExtensionFunctionType ? CollectionsKt.drop((Iterable)it, (int)1) : it;
    }
}

