/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.diagnostics;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategy;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategyKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategies;", "", "()V", "DECLARATION_NAME", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "getDECLARATION_NAME", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "DECLARATION_SIGNATURE", "getDECLARATION_SIGNATURE", "DECLARATION_SIGNATURE_OR_DEFAULT", "getDECLARATION_SIGNATURE_OR_DEFAULT", "DEFAULT", "getDEFAULT", "MODALITY_MODIFIER", "getMODALITY_MODIFIER", "OPERATOR", "getOPERATOR", "PARAMETER_DEFAULT_VALUE", "getPARAMETER_DEFAULT_VALUE", "PARAMETER_VARARG_MODIFIER", "getPARAMETER_VARARG_MODIFIER", "SECONDARY_CONSTRUCTOR_DELEGATION_CALL", "getSECONDARY_CONSTRUCTOR_DELEGATION_CALL", "VAL_OR_VAR_NODE", "getVAL_OR_VAR_NODE", "VISIBILITY_MODIFIER", "getVISIBILITY_MODIFIER", "ModifierSetBasedLightTreePositioningStrategy", "checkers"})
public final class LightTreePositioningStrategies {
    @NotNull
    public static final LightTreePositioningStrategies INSTANCE = new LightTreePositioningStrategies();
    @NotNull
    private static final LightTreePositioningStrategy DEFAULT = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            IElementType iElementType = node.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.OBJECT_DECLARATION)) {
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$objectKeyword(tree, node);
                Intrinsics.checkNotNull((Object)lighterASTNode2);
                LighterASTNode objectKeyword = lighterASTNode2;
                lighterASTNode2 = LightTreePositioningStrategiesKt.access$nameIdentifier(tree, node);
                return LightTreePositioningStrategyKt.markRange(objectKeyword, lighterASTNode2 == null ? objectKeyword : lighterASTNode2, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL)) {
                return LightTreePositioningStrategies.INSTANCE.getSECONDARY_CONSTRUCTOR_DELEGATION_CALL().mark(node, startOffset, endOffset, tree);
            }
            return super.mark(node, startOffset, endOffset, tree);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy VAL_OR_VAR_NODE = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$valOrVarKeyword(tree, node);
            LighterASTNode target = lighterASTNode2 == null ? node : lighterASTNode2;
            return LightTreePositioningStrategyKt.markElement(target, startOffset, endOffset, tree, node);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy SECONDARY_CONSTRUCTOR_DELEGATION_CALL = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            IElementType iElementType = node.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.SECONDARY_CONSTRUCTOR)) {
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                if (lighterASTNode2 == null) {
                    return LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
                }
                LighterASTNode valueParameterList = lighterASTNode2;
                lighterASTNode2 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, node);
                Intrinsics.checkNotNull((Object)lighterASTNode2);
                LighterASTNode lighterASTNode3 = lighterASTNode2;
                lighterASTNode2 = LightTreePositioningStrategiesKt.access$lastChild(tree, valueParameterList);
                return LightTreePositioningStrategyKt.markRange(lighterASTNode3, lighterASTNode2 == null ? valueParameterList : lighterASTNode2, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL)) {
                Object object = KtNodeTypes.CONSTRUCTOR_DELEGATION_REFERENCE;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CONSTRUCTOR_DELEGATION_REFERENCE");
                LighterASTNode delegationReference = LightTreePositioningStrategiesKt.findChildByType(tree, node, (IElementType)object);
                if (delegationReference != null && LightTreePositioningStrategiesKt.access$firstChild(tree, delegationReference) == null) {
                    Object object2 = KtNodeTypes.SECONDARY_CONSTRUCTOR;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"SECONDARY_CONSTRUCTOR");
                    LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.access$findParentOfType(tree, node, (IElementType)object2);
                    Intrinsics.checkNotNull((Object)lighterASTNode4);
                    LighterASTNode constructor2 = lighterASTNode4;
                    object2 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, constructor2);
                    if (object2 == null) {
                        return LightTreePositioningStrategyKt.markElement(constructor2, startOffset, endOffset, tree, node);
                    }
                    Object valueParameterList = object2;
                    object2 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, constructor2);
                    Intrinsics.checkNotNull((Object)object2);
                    Object object3 = object2;
                    object2 = LightTreePositioningStrategiesKt.access$lastChild(tree, (LighterASTNode)valueParameterList);
                    return LightTreePositioningStrategyKt.markRange((LighterASTNode)object3, (LighterASTNode)(object2 == null ? valueParameterList : object2), startOffset, endOffset, tree, node);
                }
                object = delegationReference;
                return LightTreePositioningStrategyKt.markElement((LighterASTNode)(object == null ? node : object), startOffset, endOffset, tree, node);
            }
            String string2 = Intrinsics.stringPlus((String)"unexpected element ", (Object)node);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy DECLARATION_NAME = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            LighterASTNode nameIdentifier = LightTreePositioningStrategiesKt.access$nameIdentifier(tree, node);
            if (nameIdentifier != null) {
                if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.CLASS) || Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.OBJECT_DECLARATION)) {
                    LighterASTNode lighterASTNode2;
                    Object object;
                    LighterASTNode lighterASTNode3;
                    LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.access$modifierList(tree, node);
                    if (lighterASTNode4 == null) {
                        lighterASTNode3 = null;
                    } else {
                        object = lighterASTNode4;
                        boolean bl = false;
                        boolean bl2 = false;
                        LighterASTNode modifierList2 = object;
                        boolean bl3 = false;
                        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ENUM_KEYWORD;
                        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"ENUM_KEYWORD");
                        lighterASTNode3 = LightTreePositioningStrategiesKt.findChildByType(tree, modifierList2, ktModifierKeywordToken);
                    }
                    LighterASTNode lighterASTNode5 = lighterASTNode3;
                    if (lighterASTNode5 == null) {
                        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD};
                        object = TokenSet.create(iElementTypeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD)");
                        lighterASTNode4 = LightTreePositioningStrategiesKt.access$findChildByType(tree, node, (TokenSet)object);
                        lighterASTNode2 = lighterASTNode4 == null ? node : lighterASTNode4;
                    } else {
                        lighterASTNode2 = lighterASTNode5;
                    }
                    LighterASTNode startElement = lighterASTNode2;
                    return LightTreePositioningStrategyKt.markRange(startElement, nameIdentifier, startOffset, endOffset, tree, node);
                }
                return LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
            }
            if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.FUN)) {
                return LightTreePositioningStrategies.INSTANCE.getDECLARATION_SIGNATURE().mark(node, startOffset, endOffset, tree);
            }
            return LightTreePositioningStrategies.INSTANCE.getDEFAULT().mark(node, startOffset, endOffset, tree);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy DECLARATION_SIGNATURE = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            IElementType iElementType = node.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.SECONDARY_CONSTRUCTOR)) {
                LighterASTNode lighterASTNode2;
                LighterASTNode lighterASTNode3;
                LighterASTNode lighterASTNode4;
                LighterASTNode lighterASTNode5 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, node);
                if (lighterASTNode5 == null) {
                    lighterASTNode4 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                    if (lighterASTNode4 == null) {
                        return LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
                    }
                    lighterASTNode3 = lighterASTNode4;
                } else {
                    lighterASTNode3 = lighterASTNode5;
                }
                LighterASTNode begin = lighterASTNode3;
                lighterASTNode4 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                if (lighterASTNode4 == null) {
                    LighterASTNode lighterASTNode6 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, node);
                    if (lighterASTNode6 == null) {
                        return LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
                    }
                    lighterASTNode2 = lighterASTNode6;
                } else {
                    lighterASTNode2 = lighterASTNode4;
                }
                LighterASTNode end = lighterASTNode2;
                return LightTreePositioningStrategyKt.markRange(begin, end, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FUN) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FUNCTION_LITERAL)) {
                LighterASTNode lighterASTNode7;
                LighterASTNode endOfSignatureElement;
                LighterASTNode end;
                LighterASTNode lighterASTNode8 = LightTreePositioningStrategiesKt.access$typeReference(tree, node);
                LighterASTNode lighterASTNode9 = end = lighterASTNode8 == null ? LightTreePositioningStrategiesKt.access$valueParameterList(tree, node) : lighterASTNode8;
                LighterASTNode lighterASTNode10 = end == null ? ((lighterASTNode8 = LightTreePositioningStrategiesKt.access$nameIdentifier(tree, node)) == null ? node : lighterASTNode8) : (endOfSignatureElement = end);
                LighterASTNode lighterASTNode11 = Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.FUNCTION_LITERAL) ? ((lighterASTNode8 = LightTreePositioningStrategiesKt.access$receiverTypeReference(tree, node)) == null ? ((lighterASTNode7 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node)) == null ? node : lighterASTNode7) : lighterASTNode8) : node;
                LighterASTNode startElement = lighterASTNode11;
                return LightTreePositioningStrategyKt.markRange(startElement, endOfSignatureElement, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PROPERTY)) {
                LighterASTNode lighterASTNode12;
                LighterASTNode startElement = LightTreePositioningStrategiesKt.access$typeReference(tree, node);
                LighterASTNode endOfSignatureElement = startElement == null ? ((lighterASTNode12 = LightTreePositioningStrategiesKt.access$nameIdentifier(tree, node)) == null ? node : lighterASTNode12) : startElement;
                return LightTreePositioningStrategyKt.markRange(node, endOfSignatureElement, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PROPERTY_ACCESSOR)) {
                LighterASTNode lighterASTNode13;
                LighterASTNode startElement = LightTreePositioningStrategiesKt.access$typeReference(tree, node);
                LighterASTNode endOfSignatureElement = startElement == null ? ((lighterASTNode13 = LightTreePositioningStrategiesKt.access$rightParenthesis(tree, node)) == null ? LightTreePositioningStrategiesKt.access$accessorNamePlaceholder(tree, node) : lighterASTNode13) : startElement;
                return LightTreePositioningStrategyKt.markRange(node, endOfSignatureElement, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CLASS)) {
                LighterASTNode lighterASTNode14;
                LighterASTNode startElement = LightTreePositioningStrategiesKt.access$nameIdentifier(tree, node);
                if (startElement == null) {
                    return LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
                }
                LighterASTNode nameAsDeclaration = startElement;
                LighterASTNode lighterASTNode15 = LightTreePositioningStrategiesKt.access$primaryConstructor(tree, node);
                if (lighterASTNode15 == null) {
                    lighterASTNode14 = null;
                } else {
                    LighterASTNode lighterASTNode16 = lighterASTNode15;
                    boolean bl = false;
                    boolean bl2 = false;
                    LighterASTNode constructor2 = lighterASTNode16;
                    boolean bl3 = false;
                    lighterASTNode14 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, constructor2);
                }
                LighterASTNode lighterASTNode17 = lighterASTNode14;
                if (lighterASTNode17 == null) {
                    return LightTreePositioningStrategyKt.markElement(nameAsDeclaration, startOffset, endOffset, tree, node);
                }
                LighterASTNode primaryConstructorParameterList = lighterASTNode17;
                return LightTreePositioningStrategyKt.markRange(nameAsDeclaration, primaryConstructorParameterList, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.OBJECT_DECLARATION)) {
                return LightTreePositioningStrategies.INSTANCE.getDECLARATION_NAME().mark(node, startOffset, endOffset, tree);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CLASS_INITIALIZER)) {
                LighterASTNode lighterASTNode18 = LightTreePositioningStrategiesKt.access$initKeyword(tree, node);
                Intrinsics.checkNotNull((Object)lighterASTNode18);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode18, startOffset, endOffset, tree, node);
            }
            return super.mark(node, startOffset, endOffset, tree);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy DECLARATION_SIGNATURE_OR_DEFAULT = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            return this.isDeclaration(node) ? LightTreePositioningStrategies.INSTANCE.getDECLARATION_SIGNATURE().mark(node, startOffset, endOffset, tree) : LightTreePositioningStrategies.INSTANCE.getDEFAULT().mark(node, startOffset, endOffset, tree);
        }

        private final boolean isDeclaration(LighterASTNode $this$isDeclaration) {
            IElementType iElementType = $this$isDeclaration.getTokenType();
            return (((((((Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.SECONDARY_CONSTRUCTOR)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FUN)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FUNCTION_LITERAL)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PROPERTY)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PROPERTY_ACCESSOR)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CLASS)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.OBJECT_DECLARATION)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CLASS_INITIALIZER);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy VISIBILITY_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy MODALITY_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy OPERATOR;
    @NotNull
    private static final LightTreePositioningStrategy PARAMETER_DEFAULT_VALUE;
    @NotNull
    private static final LightTreePositioningStrategy PARAMETER_VARARG_MODIFIER;

    private LightTreePositioningStrategies() {
    }

    @NotNull
    public final LightTreePositioningStrategy getDEFAULT() {
        return DEFAULT;
    }

    @NotNull
    public final LightTreePositioningStrategy getVAL_OR_VAR_NODE() {
        return VAL_OR_VAR_NODE;
    }

    @NotNull
    public final LightTreePositioningStrategy getSECONDARY_CONSTRUCTOR_DELEGATION_CALL() {
        return SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    }

    @NotNull
    public final LightTreePositioningStrategy getDECLARATION_NAME() {
        return DECLARATION_NAME;
    }

    @NotNull
    public final LightTreePositioningStrategy getDECLARATION_SIGNATURE() {
        return DECLARATION_SIGNATURE;
    }

    @NotNull
    public final LightTreePositioningStrategy getDECLARATION_SIGNATURE_OR_DEFAULT() {
        return DECLARATION_SIGNATURE_OR_DEFAULT;
    }

    @NotNull
    public final LightTreePositioningStrategy getVISIBILITY_MODIFIER() {
        return VISIBILITY_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getMODALITY_MODIFIER() {
        return MODALITY_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getOPERATOR() {
        return OPERATOR;
    }

    @NotNull
    public final LightTreePositioningStrategy getPARAMETER_DEFAULT_VALUE() {
        return PARAMETER_DEFAULT_VALUE;
    }

    @NotNull
    public final LightTreePositioningStrategy getPARAMETER_VARARG_MODIFIER() {
        return PARAMETER_VARARG_MODIFIER;
    }

    static {
        TokenSet tokenSet = KtTokens.VISIBILITY_MODIFIERS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"VISIBILITY_MODIFIERS");
        VISIBILITY_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy(tokenSet);
        tokenSet = KtTokens.MODALITY_MODIFIERS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"MODALITY_MODIFIERS");
        MODALITY_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy(tokenSet);
        OPERATOR = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$operationReference(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        PARAMETER_DEFAULT_VALUE = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$defaultValue(tree, node);
                LighterASTNode defaultValueElement = lighterASTNode2 == null ? node : lighterASTNode2;
                return LightTreePositioningStrategyKt.markElement(defaultValueElement, startOffset, endOffset, tree, node);
            }
        };
        PARAMETER_VARARG_MODIFIER = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                LighterASTNode modifier;
                LighterASTNode lighterASTNode2;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.access$modifierList(tree, node);
                if (lighterASTNode3 == null) {
                    lighterASTNode2 = null;
                } else {
                    LighterASTNode lighterASTNode4 = lighterASTNode3;
                    boolean bl = false;
                    boolean bl2 = false;
                    LighterASTNode modifierList2 = lighterASTNode4;
                    boolean bl3 = false;
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.VARARG_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"VARARG_KEYWORD");
                    lighterASTNode2 = LightTreePositioningStrategiesKt.findChildByType(tree, modifierList2, ktModifierKeywordToken);
                }
                lighterASTNode3 = modifier = lighterASTNode2;
                return LightTreePositioningStrategyKt.markElement(lighterASTNode3 == null ? node : lighterASTNode3, startOffset, endOffset, tree, node);
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategies$ModifierSetBasedLightTreePositioningStrategy;", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "modifierSet", "Lcom/intellij/psi/tree/TokenSet;", "(Lcom/intellij/psi/tree/TokenSet;)V", "mark", "", "Lcom/intellij/openapi/util/TextRange;", "node", "Lcom/intellij/lang/LighterASTNode;", "startOffset", "", "endOffset", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "checkers"})
    private static final class ModifierSetBasedLightTreePositioningStrategy
    extends LightTreePositioningStrategy {
        @NotNull
        private final TokenSet modifierSet;

        public ModifierSetBasedLightTreePositioningStrategy(@NotNull TokenSet modifierSet) {
            Intrinsics.checkNotNullParameter((Object)modifierSet, (String)"modifierSet");
            this.modifierSet = modifierSet;
        }

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            List<TextRange> list2;
            Object object;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            LighterASTNode modifierList2 = LightTreePositioningStrategiesKt.access$modifierList(tree, node);
            if (modifierList2 != null && (object = LightTreePositioningStrategiesKt.access$findChildByType(tree, modifierList2, this.modifierSet)) != null) {
                LighterASTNode lighterASTNode2 = object;
                boolean bl = false;
                boolean bl2 = false;
                LighterASTNode it = lighterASTNode2;
                boolean bl3 = false;
                return LightTreePositioningStrategyKt.markElement(it, startOffset, endOffset, tree, node);
            }
            object = LightTreePositioningStrategiesKt.access$nameIdentifier(tree, node);
            if (object != null) {
                LighterASTNode lighterASTNode3 = object;
                boolean bl = false;
                boolean bl4 = false;
                LighterASTNode it = lighterASTNode3;
                boolean bl5 = false;
                return LightTreePositioningStrategyKt.markElement(it, startOffset, endOffset, tree, node);
            }
            object = node.getTokenType();
            if (Intrinsics.areEqual((Object)object, (Object)KtNodeTypes.OBJECT_DECLARATION)) {
                LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.access$objectKeyword(tree, node);
                Intrinsics.checkNotNull((Object)lighterASTNode4);
                list2 = LightTreePositioningStrategyKt.markElement(lighterASTNode4, startOffset, endOffset, tree, node);
            } else {
                list2 = Intrinsics.areEqual((Object)object, (Object)KtNodeTypes.PROPERTY_ACCESSOR) ? LightTreePositioningStrategyKt.markElement(LightTreePositioningStrategiesKt.access$accessorNamePlaceholder(tree, node), startOffset, endOffset, tree, node) : LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
            }
            return list2;
        }
    }
}

