/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.range;

import java.util.Date;
import org.jeasy.random.randomizers.range.AbstractRangeRandomizer;

public class SqlDateRangeRandomizer
extends AbstractRangeRandomizer<java.sql.Date> {
    public SqlDateRangeRandomizer(java.sql.Date min, java.sql.Date max) {
        super(min, max);
    }

    public SqlDateRangeRandomizer(java.sql.Date min, java.sql.Date max, long seed) {
        super(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((java.sql.Date)this.min).after((Date)this.max)) {
            throw new IllegalArgumentException("max must be after min");
        }
    }

    @Override
    protected java.sql.Date getDefaultMinValue() {
        return new java.sql.Date(Long.MIN_VALUE);
    }

    @Override
    protected java.sql.Date getDefaultMaxValue() {
        return new java.sql.Date(Long.MAX_VALUE);
    }

    @Override
    public java.sql.Date getRandomValue() {
        long minDateTime = ((java.sql.Date)this.min).getTime();
        long maxDateTime = ((java.sql.Date)this.max).getTime();
        long randomDateTime = (long)this.nextDouble(minDateTime, maxDateTime);
        return new java.sql.Date(randomDateTime);
    }
}

