/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.range;

import java.time.LocalTime;
import org.jeasy.random.randomizers.range.AbstractRangeRandomizer;

public class LocalTimeRangeRandomizer
extends AbstractRangeRandomizer<LocalTime> {
    public LocalTimeRangeRandomizer(LocalTime min, LocalTime max) {
        super(min, max);
    }

    public LocalTimeRangeRandomizer(LocalTime min, LocalTime max, long seed) {
        super(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((LocalTime)this.min).isAfter((LocalTime)this.max)) {
            throw new IllegalArgumentException("max must be after min");
        }
    }

    @Override
    protected LocalTime getDefaultMinValue() {
        return LocalTime.MIN;
    }

    @Override
    protected LocalTime getDefaultMaxValue() {
        return LocalTime.MAX;
    }

    @Override
    public LocalTime getRandomValue() {
        int minNanoSecond = ((LocalTime)this.min).getNano();
        int minSecond = ((LocalTime)this.min).getSecond();
        int minMinute = ((LocalTime)this.min).getMinute();
        int minHour = ((LocalTime)this.min).getHour();
        int maxNanoSecond = ((LocalTime)this.max).getNano();
        int maxSecond = ((LocalTime)this.max).getSecond();
        int maxMinute = ((LocalTime)this.max).getMinute();
        int maxHour = ((LocalTime)this.max).getHour();
        int randomNanoSecond = (int)this.nextDouble(minNanoSecond, maxNanoSecond);
        int randomSecond = (int)this.nextDouble(minSecond, maxSecond);
        int randomMinute = (int)this.nextDouble(minMinute, maxMinute);
        int randomHour = (int)this.nextDouble(minHour, maxHour);
        return LocalTime.of(randomHour, randomMinute, randomSecond, randomNanoSecond);
    }
}

