/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.extension.ExtensionContext;
import org.jdbi.v3.core.extension.HandleSupplier;

abstract class AbstractHandleSupplier
implements HandleSupplier {
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Deque<ExtensionContext> extensionContexts = new ArrayDeque<ExtensionContext>();

    protected AbstractHandleSupplier() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V invokeInContext(ExtensionContext extensionContext, Callable<V> task) throws Exception {
        try {
            this.pushExtensionContext(extensionContext);
            V v = task.call();
            return v;
        }
        finally {
            this.popExtensionContext();
        }
    }

    protected ExtensionContext currentExtensionContext() {
        return this.extensionContexts.peek();
    }

    protected abstract void withHandle(Consumer<Handle> var1);

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            throw new IllegalStateException("Handle is closed");
        }
        this.extensionContexts.clear();
    }

    private void pushExtensionContext(ExtensionContext extensionContext) {
        this.extensionContexts.addFirst(extensionContext);
        this.withHandle(handle -> handle.acceptExtensionContext(extensionContext));
    }

    private void popExtensionContext() {
        this.extensionContexts.pollFirst();
        this.withHandle(h -> h.acceptExtensionContext(this.currentExtensionContext()));
    }
}

