/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter.tar;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.impl.base.exporter.StreamExporterDelegateBase;
import org.jboss.shrinkwrap.impl.base.io.tar.TarEntry;
import org.jboss.shrinkwrap.impl.base.io.tar.TarOutputStreamImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TarExporterDelegateBase<T extends TarOutputStreamImpl>
extends StreamExporterDelegateBase<T> {
    private static final Logger log = Logger.getLogger(TarExporterDelegateBase.class.getName());

    public TarExporterDelegateBase(Archive<?> archive) {
        super(archive);
    }

    @Override
    protected final void closeEntry(T outputStream) throws IOException {
        ((TarOutputStreamImpl)outputStream).closeEntry();
    }

    @Override
    protected final void putNextExtry(T outputStream, String context) throws IOException {
        TarEntry entry = new TarEntry(context);
        ((TarOutputStreamImpl)outputStream).putNextEntry(entry);
    }

    @Override
    protected Callable<Void> getExportTask(final Callable<Void> wrappedTask) {
        assert (wrappedTask != null) : "Wrapped task must be specified";
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    wrappedTask.call();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Exception encountered during export of archive", e);
                    throw e;
                }
                finally {
                    try {
                        ((TarOutputStreamImpl)TarExporterDelegateBase.this.outputStream).close();
                    }
                    catch (IOException ioe) {
                        log.log(Level.WARNING, "[SHRINKWRAP-120] Possible deadlock scenario: Got exception on closing the out stream: " + ioe.getMessage(), ioe);
                    }
                }
                return null;
            }
        };
    }
}

