/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.fixers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.QSFixer;
import org.jboss.maven.plugins.qstools.common.PomOrderUtil;
import org.jboss.maven.plugins.qstools.fixers.AbstractBaseFixerAdapter;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.jboss.maven.plugins.qstools.xml.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=QSFixer.class, hint="PomElementOrderFixer")
public class PomElementOrderFixer
extends AbstractBaseFixerAdapter {
    @Requirement
    private PomOrderUtil pomOrderUtil;

    @Override
    public String getFixerDescription() {
        return "Fix the pom.xml element order";
    }

    @Override
    public void fixProject(MavenProject project, Document doc) throws Exception {
        List<String> pomElementsOrder = this.getConfigurationProvider().getQuickstartsRules(project.getGroupId()).getPomOrder();
        Map<String, Node> elementsFound = this.pomOrderUtil.getElementsOrder(project, doc, pomElementsOrder);
        ArrayList<String> elementsList = new ArrayList<String>(elementsFound.keySet());
        for (String element : elementsList) {
            Node commentNode = null;
            Node elementNode = (Node)this.getxPath().evaluate("/project/" + element, doc, XPathConstants.NODE);
            if (elementNode.getPreviousSibling() != null && elementNode.getPreviousSibling().getNodeType() == 8) {
                commentNode = elementNode.getPreviousSibling();
            }
            for (String anotherElement : elementsList) {
                if (elementsList.indexOf(element) >= elementsList.indexOf(anotherElement)) continue;
                XMLUtil.removePreviousWhiteSpace(elementNode);
                Node anotherElementNode = (Node)this.getxPath().evaluate("/project/" + anotherElement, doc, XPathConstants.NODE);
                anotherElementNode.getParentNode().insertBefore(elementNode, anotherElementNode);
                if (commentNode == null) continue;
                XMLUtil.removePreviousWhiteSpace(commentNode);
                elementNode.getParentNode().insertBefore(commentNode, elementNode);
            }
        }
        XMLWriter.writeXML(doc, project.getFile());
    }

    @Override
    public int order() {
        return 10;
    }
}

