/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.docbook.support;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jboss.maven.shared.file.DirectoryCopier;

public class ResourceMojo
extends AbstractMojo {
    protected File xsltSourceDirectory;
    protected File fontSourceDirectory;
    protected File imagesSourceDirectory;
    protected File cssSourceDirectory;
    protected File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.copySource(this.xsltSourceDirectory, new File(this.outputDirectory, "xslt"));
        this.copySource(this.fontSourceDirectory, new File(this.outputDirectory, "fonts"));
        this.copySource(this.imagesSourceDirectory, new File(this.outputDirectory, "images"));
        this.copySource(this.cssSourceDirectory, new File(this.outputDirectory, "css"));
    }

    private void copySource(File sourceDirectory, File targetDirectory) throws MojoExecutionException {
        this.getLog().info((CharSequence)("attempting to copy directory : " + sourceDirectory.getAbsolutePath()));
        try {
            new DirectoryCopier(sourceDirectory).copyTo(targetDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy directory [" + sourceDirectory + "]", (Exception)e);
        }
    }
}

