/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.retro.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.jboss.maven.plugins.retro.util.JarFileEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarUtil {
    public static ArrayList<JarFileEntry> createJarEntries(File directory) throws IOException {
        ArrayList<JarFileEntry> fileEntries = new ArrayList<JarFileEntry>();
        Collection files = FileUtils.listFiles((File)directory, null, (boolean)true);
        for (Object fileObj : files) {
            String relativePath = fileObj.toString().replace(directory.getAbsolutePath() + File.separator, "");
            relativePath = relativePath.replace('\\', '/');
            byte[] content = FileUtils.readFileToByteArray((File)((File)fileObj));
            fileEntries.add(new JarFileEntry(relativePath, content));
        }
        return fileEntries;
    }

    public static File createJarFile(String inputPath, String jarFilePath) throws IOException {
        File outputDir = new File(inputPath);
        ArrayList<JarFileEntry> fileEntries = JarUtil.createJarEntries(outputDir);
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        attributes.putValue("Created-By", System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
        JarOutputStream stream = new JarOutputStream((OutputStream)new FileOutputStream(jarFilePath), manifest);
        stream.setLevel(9);
        for (JarFileEntry fileEntry : fileEntries) {
            JarEntry jarEntry = new JarEntry(fileEntry.getName());
            stream.putNextEntry(jarEntry);
            stream.write(fileEntry.getContent());
        }
        stream.close();
        return new File(jarFilePath);
    }
}

