/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.remoting;

import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aspects.remoting.AOPRemotingInvocationHandler;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.logging.Logger;
import org.jboss.profileservice.remoting.SecurityActions;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.SecurityContext;

public class ProfileServiceInvocationHandler
extends AOPRemotingInvocationHandler
implements ServerInvocationHandler {
    private static Logger log = Logger.getLogger(ProfileServiceInvocationHandler.class);
    private ManagementView mgtViewProxy;
    private DeploymentManager deployMgrProxy;
    private String securityDomain = "profileservice";
    private ISecurityManagement securityManagement;

    public ManagementView getManagementViewProxy() {
        return this.mgtViewProxy;
    }

    public void setManagementViewProxy(ManagementView mgtViewProxy) {
        this.mgtViewProxy = mgtViewProxy;
    }

    public DeploymentManager getDeployMgrProxy() {
        return this.deployMgrProxy;
    }

    public void setDeployMgrProxy(DeploymentManager deployMgrProxy) {
        this.deployMgrProxy = deployMgrProxy;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public ISecurityManagement getSecurityManagement() {
        return this.securityManagement;
    }

    public void setSecurityManagement(ISecurityManagement securityManagement) {
        this.securityManagement = securityManagement;
    }

    public Object invoke(InvocationRequest invocation) throws Throwable {
        this.establishSecurityContext(invocation);
        InvocationResponse value = (InvocationResponse)super.invoke(invocation);
        if (value.getResponse() instanceof ManagementView) {
            value.setResponse((Object)this.mgtViewProxy);
        }
        if (value.getResponse() instanceof DeploymentManager) {
            value.setResponse((Object)this.deployMgrProxy);
        }
        return value;
    }

    private void establishSecurityContext(InvocationRequest invocation) throws Exception {
        SecurityContext newSC = SecurityActions.createAndSetSecurityContext(this.securityDomain);
        SecurityActions.setSecurityManagement(newSC, this.securityManagement);
        log.trace((Object)("establishSecurityIdentity:SecCtx=" + SecurityActions.trace(newSC)));
    }
}

