/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.aop.Dispatcher;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.aspects.remoting.MergeMetaDataInterceptor;
import org.jboss.aspects.remoting.Remoting;
import org.jboss.aspects.security.SecurityClientInterceptor;
import org.jboss.deployers.spi.management.DelegatingComponentDispatcher;
import org.jboss.deployers.spi.management.RuntimeComponentDispatcher;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.profileservice.management.DelegatingComponentDispatcherImpl;
import org.jboss.profileservice.management.ManagedOperationDelegate;
import org.jboss.profileservice.management.ManagedPropertyDelegate;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedOperationProxyFactory
implements Serializable,
DelegatingComponentDispatcherImpl.ProxyRegistry {
    private static final long serialVersionUID = 1343224268002757169L;
    private AtomicLong operationID = new AtomicLong(0L);
    private AtomicLong propertyID = new AtomicLong(0L);
    private transient RuntimeComponentDispatcher dispatcher;
    private transient InvokerLocator locator;
    private transient Map<Long, ManagedProperty> properties = new ConcurrentHashMap<Long, ManagedProperty>();
    private transient Map<Long, ManagedOperation> operations = new ConcurrentHashMap<Long, ManagedOperation>();
    private DelegatingComponentDispatcher dispatcherProxy;
    private String dispatchName;

    public String getDispatchName() {
        return this.dispatchName;
    }

    public void setDispatchName(String dispatchName) {
        this.dispatchName = dispatchName;
    }

    public RuntimeComponentDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(RuntimeComponentDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    public void setLocator(InvokerLocator locator) {
        this.locator = locator;
    }

    public DelegatingComponentDispatcher getDispatcherProxy() {
        return this.dispatcherProxy;
    }

    public void start() throws Exception {
        if (this.dispatcher == null) {
            throw new IllegalStateException("Null dispatcher.");
        }
        if (this.locator == null) {
            throw new IllegalStateException("Null locator.");
        }
        this.dispatcherProxy = this.createDispatcherProxy();
    }

    public synchronized void clear() {
        this.properties.clear();
        this.operations.clear();
    }

    @Override
    public ManagedOperation getManagedOperation(Long opID) {
        ManagedOperation op = this.operations.get(opID);
        if (op == null) {
            throw new IllegalStateException("operation not found for id " + opID);
        }
        return op;
    }

    @Override
    public ManagedProperty getManagedProperty(Long propID) {
        ManagedProperty prop = this.properties.get(propID);
        if (prop == null) {
            throw new IllegalStateException("property not found for id " + propID);
        }
        return prop;
    }

    public ManagedProperty createPropertyProxy(ManagedProperty delegate, Object componentName) {
        long propID = this.propertyID.incrementAndGet();
        ManagedPropertyDelegate proxy = new ManagedPropertyDelegate(propID, delegate, componentName, this.dispatcherProxy);
        this.properties.put(propID, proxy);
        return proxy;
    }

    public Set<ManagedOperation> createOperationProxies(Set<ManagedOperation> ops, Object componentName) throws Exception {
        HashSet<ManagedOperation> opProxies = new HashSet<ManagedOperation>();
        for (ManagedOperation op : ops) {
            if (op instanceof ManagedOperationDelegate) {
                opProxies.add(op);
                ManagedOperationDelegate proxy = (ManagedOperationDelegate)op;
                long opID = proxy.getOpID();
                this.operations.put(opID, proxy);
                continue;
            }
            long opID = this.operationID.incrementAndGet();
            ManagedOperationDelegate proxy = new ManagedOperationDelegate(opID, op, componentName, this.dispatcherProxy);
            this.operations.put(opID, proxy);
            opProxies.add(proxy);
        }
        return opProxies;
    }

    protected DelegatingComponentDispatcher createDispatcherProxy() throws Exception {
        ArrayList<Object> interceptors = new ArrayList<Object>();
        interceptors.add(SecurityClientInterceptor.singleton);
        interceptors.add(MergeMetaDataInterceptor.singleton);
        interceptors.add(InvokeRemoteInterceptor.singleton);
        Class[] ifaces = new Class[]{DelegatingComponentDispatcher.class};
        DelegatingComponentDispatcherImpl delegate = new DelegatingComponentDispatcherImpl(this, this.dispatcher);
        String dispatchName = "ProfileService-" + this.dispatchName;
        Dispatcher.singleton.registerTarget((Object)dispatchName, (Object)delegate);
        return (DelegatingComponentDispatcher)Remoting.createRemoteProxy((Object)dispatchName, (ClassLoader)this.getClass().getClassLoader(), (Class[])ifaces, (InvokerLocator)this.locator, interceptors, (String)"ProfileService");
    }
}

