/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.ejb;

import java.util.Collection;
import javax.annotation.Resource;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless(name="SecureProfileService")
@SecurityDomain(value="profileservice", unauthenticatedPrincipal="nobody")
@Remote(value={ProfileService.class})
@RolesAllowed(value={"Administrator"})
public class SecureProfileServiceBean
implements ProfileService {
    @Resource(mappedName="ProfileService")
    private ProfileService delegate;
    @EJB(beanName="SecureManagementView")
    ManagementView mgtView;

    public void activateProfile(ProfileKey key) throws NoSuchProfileException, Exception {
        this.delegate.activateProfile(key);
    }

    public void deactivateProfile(ProfileKey key) throws NoSuchProfileException {
        this.delegate.deactivateProfile(key);
    }

    public Profile getActiveProfile(ProfileKey key) throws NoSuchProfileException {
        return this.delegate.getActiveProfile(key);
    }

    public Collection<ProfileKey> getActiveProfileKeys() {
        return this.delegate.getActiveProfileKeys();
    }

    public DeploymentManager getDeploymentManager() {
        return this.delegate.getDeploymentManager();
    }

    public String[] getDomains() {
        return this.delegate.getDomains();
    }

    public Profile getProfile(ProfileKey key) throws NoSuchProfileException {
        return this.delegate.getProfile(key);
    }

    public Collection<ProfileKey> getProfileKeys() {
        return this.delegate.getProfileKeys();
    }

    public ManagementView getViewManager() {
        return this.delegate.getViewManager();
    }

    public void registerProfile(Profile profile) throws Exception {
        this.delegate.registerProfile(profile);
    }

    public void unregisterProfile(ProfileKey key) throws NoSuchProfileException {
        this.delegate.unregisterProfile(key);
    }

    public void validateProfile(ProfileKey key) throws Exception {
        this.delegate.validateProfile(key);
    }
}

