/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.registration;

import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.jboss.test.jmx.compliance.registration.support.RegistrationAware;

public class RegistrationTEST
extends TestCase {
    public RegistrationTEST(String s) {
        super(s);
    }

    public void testSimpleRegistration() {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            RegistrationAware ra = new RegistrationAware();
            ObjectName name = new ObjectName("test:key=value");
            server.registerMBean(ra, name);
            RegistrationTEST.assertTrue((String)"preRegister", (boolean)ra.isPreRegisterCalled());
            RegistrationTEST.assertTrue((String)"postRegister", (boolean)ra.isPostRegisterCalled());
            RegistrationTEST.assertTrue((String)"postRegisterRegistrationDone", (boolean)ra.isPostRegisterRegistrationDone());
            RegistrationTEST.assertEquals((Object)name, (Object)ra.getRegisteredObjectName());
            server.unregisterMBean(name);
            RegistrationTEST.assertTrue((String)"preDeRegister", (boolean)ra.isPreDeRegisterCalled());
            RegistrationTEST.assertTrue((String)"postDeRegister", (boolean)ra.isPostDeRegisterCalled());
        }
        catch (MalformedObjectNameException e) {
            RegistrationTEST.fail((String)"spurious MalformedObjectNameException");
        }
        catch (MBeanRegistrationException e) {
            RegistrationTEST.fail((String)("strange MBeanRegistrationException linked to: " + e.getTargetException().getMessage()));
        }
        catch (Exception e) {
            RegistrationTEST.fail((String)("something else went wrong: " + e.getMessage()));
        }
    }

    public void testDuplicateRegistration() {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            ObjectName name = new ObjectName("test:key=value");
            RegistrationAware original = new RegistrationAware();
            RegistrationAware ra = new RegistrationAware();
            server.registerMBean(original, name);
            try {
                server.registerMBean(ra, name);
                RegistrationTEST.fail((String)"expected a InstanceAlreadyExistsException");
            }
            catch (InstanceAlreadyExistsException e) {
                // empty catch block
            }
            RegistrationTEST.assertTrue((String)"preRegister", (boolean)ra.isPreRegisterCalled());
            RegistrationTEST.assertTrue((String)"postRegister", (boolean)ra.isPostRegisterCalled());
            RegistrationTEST.assertTrue((String)"postRegisterRegistrationDone", (!ra.isPostRegisterRegistrationDone() ? 1 : 0) != 0);
            RegistrationTEST.assertTrue((String)"preDeRegister", (!ra.isPreDeRegisterCalled() ? 1 : 0) != 0);
            RegistrationTEST.assertTrue((String)"postDeRegister", (!ra.isPostDeRegisterCalled() ? 1 : 0) != 0);
            RegistrationTEST.assertEquals((Object)name, (Object)ra.getRegisteredObjectName());
            server.unregisterMBean(name);
        }
        catch (Exception e) {
            RegistrationTEST.fail((String)("got an unexpected exception: " + e.getMessage()));
        }
    }
}

