/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.openmbean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import junit.framework.TestCase;

public class ArrayTypeTestCase
extends TestCase {
    public ArrayTypeTestCase(String s) {
        super(s);
    }

    public void testArrayTypeOpenType() throws Exception {
        ArrayType arrayType = new ArrayType(3, SimpleType.STRING);
        ArrayTypeTestCase.assertEquals((String)"[[[Ljava.lang.String;", (String)arrayType.getClassName());
        ArrayTypeTestCase.assertEquals((String)"3-dimension array of java.lang.String", (String)arrayType.getDescription());
        ArrayTypeTestCase.assertEquals((String)"[[[Ljava.lang.String;", (String)arrayType.getTypeName());
        ArrayTypeTestCase.assertTrue((String)"Composite type should be an array", (boolean)arrayType.isArray());
    }

    public void testGetDimension() throws Exception {
        ArrayType arrayType = new ArrayType(3, SimpleType.STRING);
        ArrayTypeTestCase.assertTrue((String)"Dimension should be 3", (arrayType.getDimension() == 3 ? 1 : 0) != 0);
    }

    public void testElementOpenType() throws Exception {
        ArrayType arrayType = new ArrayType(3, SimpleType.STRING);
        ArrayTypeTestCase.assertTrue((String)("Element OpenType should be " + SimpleType.STRING), (boolean)arrayType.getElementOpenType().equals(SimpleType.STRING));
    }

    public void testIsValue() throws Exception {
        ArrayType arrayType = new ArrayType(3, SimpleType.STRING);
        ArrayTypeTestCase.assertTrue((String)"null is not a value of array type", (!arrayType.isValue(null) ? 1 : 0) != 0);
        ArrayTypeTestCase.assertTrue((String)"object is not a value of array type", (!arrayType.isValue(new Object()) ? 1 : 0) != 0);
        String[][][] data = new String[1][2][3];
        ArrayTypeTestCase.assertTrue((String)"data should be a value of array type", (boolean)arrayType.isValue(data));
        String[][] data2 = new String[1][2];
        ArrayTypeTestCase.assertTrue((String)"data should not be a value of array type, wrong number of dimensions", (!arrayType.isValue(data2) ? 1 : 0) != 0);
        Object[][][] data3 = new Object[1][2][3];
        ArrayTypeTestCase.assertTrue((String)"data should not be a value of array type, wrong element type", (!arrayType.isValue(data3) ? 1 : 0) != 0);
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType compositeType = new CompositeType("typeName", "description", itemNames, itemDescriptions, itemTypes);
        Object[] itemValues = new Object[]{"string", new Integer(1)};
        CompositeDataSupport cds = new CompositeDataSupport(compositeType, itemNames, itemValues);
        CompositeDataSupport[][] compData1 = new CompositeDataSupport[][]{{cds, null}, {cds, cds}};
        ArrayType compArrayType1 = new ArrayType(2, compositeType);
        ArrayTypeTestCase.assertTrue((String)"compData1 should be a value of array type", (boolean)compArrayType1.isValue(compData1));
        ArrayType compArrayType2 = new ArrayType(1, compositeType);
        ArrayTypeTestCase.assertTrue((String)"compData1 should not be a value of array type, wrong dimension", (!compArrayType2.isValue(compData1) ? 1 : 0) != 0);
        CompositeType compositeType2 = new CompositeType("typeName2", "description", itemNames, itemDescriptions, itemTypes);
        ArrayType compArrayType3 = new ArrayType(2, compositeType2);
        ArrayTypeTestCase.assertTrue((String)"compData1 should not be a value of array type, wrong element type", (!compArrayType3.isValue(compData1) ? 1 : 0) != 0);
        TabularType tabularType = new TabularType("typeName", "description", compositeType, new String[]{"name1"});
        TabularDataSupport tds = new TabularDataSupport(tabularType);
        TabularDataSupport[][] tabData1 = new TabularDataSupport[][]{{tds, null}, {tds, tds}};
        ArrayType tabArrayType1 = new ArrayType(2, tabularType);
        ArrayTypeTestCase.assertTrue((String)"tabData1 should be a value of array type", (boolean)tabArrayType1.isValue(tabData1));
        ArrayType tabArrayType2 = new ArrayType(1, tabularType);
        ArrayTypeTestCase.assertTrue((String)"tabData1 should not be a value of array type, wrong number of dimensions", (!tabArrayType2.isValue(tabData1) ? 1 : 0) != 0);
        TabularType tabularType2 = new TabularType("typeName2", "description", compositeType, new String[]{"name1"});
        ArrayType tabArrayType3 = new ArrayType(2, tabularType2);
        ArrayTypeTestCase.assertTrue((String)"tabData1 should not be a value of array type, wrong element type", (!tabArrayType3.isValue(tabData1) ? 1 : 0) != 0);
    }

    public void testEquals() throws Exception {
        ArrayType arrayType = new ArrayType(3, SimpleType.STRING);
        ArrayTypeTestCase.assertTrue((String)"null is not an array type", (!arrayType.equals(null) ? 1 : 0) != 0);
        ArrayTypeTestCase.assertTrue((String)"object is not an array type", (!arrayType.equals(new Object()) ? 1 : 0) != 0);
        ArrayTypeTestCase.assertTrue((String)"should be equal", (boolean)arrayType.equals(arrayType));
        ArrayType arrayType2 = new ArrayType(3, SimpleType.STRING);
        ArrayTypeTestCase.assertTrue((String)"should be equal, even though different instances", (boolean)arrayType.equals(arrayType2));
        ArrayTypeTestCase.assertTrue((String)"should be equal, even though different instances", (boolean)arrayType2.equals(arrayType));
        arrayType2 = new ArrayType(2, SimpleType.STRING);
        ArrayTypeTestCase.assertTrue((String)"should not be equal, wrong number of dimensions", (!arrayType.equals(arrayType2) ? 1 : 0) != 0);
        ArrayTypeTestCase.assertTrue((String)"should not be equal, wrong number of dimensions", (!arrayType2.equals(arrayType) ? 1 : 0) != 0);
        arrayType2 = new ArrayType(3, SimpleType.INTEGER);
        ArrayTypeTestCase.assertTrue((String)"should not be equal, wrong element type", (!arrayType.equals(arrayType2) ? 1 : 0) != 0);
        ArrayTypeTestCase.assertTrue((String)"should not be equal, wrong element type", (!arrayType2.equals(arrayType) ? 1 : 0) != 0);
    }

    public void testHashCode() throws Exception {
        ArrayType arrayType = new ArrayType(3, SimpleType.STRING);
        int myHashCode = 3 + SimpleType.STRING.hashCode();
        ArrayTypeTestCase.assertTrue((String)"Wrong hash code generated", (myHashCode == arrayType.hashCode() ? 1 : 0) != 0);
    }

    public void testToString() throws Exception {
        ArrayType arrayType = new ArrayType(3, SimpleType.STRING);
        String toString = arrayType.toString();
        ArrayTypeTestCase.assertTrue((String)"toString() should contain the array type class name", (toString.indexOf(ArrayType.class.getName()) != -1 ? 1 : 0) != 0);
        ArrayTypeTestCase.assertTrue((String)"toString() should contain the dimension", (toString.indexOf("3") != -1 ? 1 : 0) != 0);
        ArrayTypeTestCase.assertTrue((String)"toString() should contain the element type", (toString.indexOf(SimpleType.STRING.toString()) != -1 ? 1 : 0) != 0);
    }

    public void testSerialization() throws Exception {
        ArrayType arrayType = new ArrayType(3, SimpleType.STRING);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(arrayType);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object result = ois.readObject();
        ArrayTypeTestCase.assertEquals(arrayType, (Object)result);
    }

    public void testErrors() throws Exception {
        boolean caught = false;
        try {
            new ArrayType(-1, SimpleType.STRING);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            ArrayTypeTestCase.fail((String)"Excepted IllegalArgumentException for negative dimension");
        }
        caught = false;
        try {
            new ArrayType(1, new ArrayType(2, SimpleType.STRING));
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            ArrayTypeTestCase.fail((String)"Excepted OpenDataException for ArrayType element type");
        }
    }

    public void testErrors2() throws Exception {
        boolean caught = false;
        try {
            new ArrayType(1, null);
        }
        catch (NullPointerException e) {
            ArrayTypeTestCase.fail((String)"FAILS IN RI: expected IllegalArgumentException for null element type");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            ArrayTypeTestCase.fail((String)"Excepted IllegalArgumentException for null element type");
        }
    }
}

