/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.metadata.mcf;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ManagementPropertyFactory;
import org.jboss.resource.deployers.management.ConnectionFactoryProperty;
import org.jboss.resource.metadata.mcf.JDBCProviderSupport;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryPropertyMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceDeploymentMetaData
extends ManagedConnectionFactoryDeploymentMetaData
implements JDBCProviderSupport {
    private static final long serialVersionUID = 1440129014410015366L;
    private static final String CONNECTION_DEFINITION = "javax.sql.DataSource";
    private static final String RAR_NAME = "jboss-local-jdbc.rar";
    @XmlElement(name="transaction-isolation")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String transactionIsolation;
    @XmlElement(name="user-name")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String userName;
    @XmlElement(name="password")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String passWord;
    @XmlElement(name="new-connection-sql")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String newConnectionSQL;
    @XmlElement(name="check-valid-connection-sql")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String checkValidConnectionSQL;
    @XmlElement(name="valid-connection-checker-class-name")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String validConnectionCheckerClassName;
    @XmlElement(name="exception-sorter-class-name")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String exceptionSorterClassName;
    @XmlElement(name="stale-connection-checker-class-name")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String staleConnectionCheckerClassName;
    @XmlElement(name="track-statements")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String trackStatements;
    @XmlElement(name="prepared-statement-cache-size")
    private int preparedStatementCacheSize = 0;
    @XmlElement(name="share-prepared-statements")
    private boolean sharePreparedStatements;
    @XmlElement(name="set-tx-query-timeout")
    private boolean useQueryTimeout;
    @XmlElement(name="query-timeout")
    private int queryTimeout;
    @XmlElement(name="use-try-lock")
    private long useTryLock;
    @XmlElement(name="url-delimiter")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String urlDelimiter;
    @XmlElement(name="url-selector-strategy-class-name")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String urlSelectorStrategyClassName;

    public DataSourceDeploymentMetaData() {
        this.setConnectionDefinition(CONNECTION_DEFINITION);
        this.setRarName(RAR_NAME);
    }

    @ManagementProperty(name="transaction-isolation", description="The DataSource transaction isolation level", includeInTemplate=true)
    public String getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(String transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    @ManagementProperty(name="password", description="The DataSource password", includeInTemplate=true)
    public String getPassWord() {
        return this.passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    @ManagementProperty(name="user-name", description="The DataSource username", includeInTemplate=true)
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    @ManagementProperty(name="check-valid-connection-sql", description="The SQL statement to validate a connection", includeInTemplate=true)
    public String getCheckValidConnectionSQL() {
        return this.checkValidConnectionSQL;
    }

    @Override
    public void setCheckValidConnectionSQL(String checkValidConnectionSQL) {
        this.checkValidConnectionSQL = checkValidConnectionSQL;
    }

    @Override
    @ManagementProperty(name="exception-sorter-class-name", description="The exception sorter class name", includeInTemplate=true)
    public String getExceptionSorterClassName() {
        return this.exceptionSorterClassName;
    }

    @Override
    public void setExceptionSorterClassName(String exceptionSorterClassName) {
        this.exceptionSorterClassName = exceptionSorterClassName;
    }

    @Override
    @ManagementProperty(name="new-connection-sql", description="The new connection SQL", includeInTemplate=true)
    public String getNewConnectionSQL() {
        return this.newConnectionSQL;
    }

    @Override
    public void setNewConnectionSQL(String newConnectionSQL) {
        this.newConnectionSQL = newConnectionSQL;
    }

    @Override
    @ManagementProperty(name="valid-connection-checker-class-name", description="The DataSource connection checker class name", includeInTemplate=true)
    public String getValidConnectionCheckerClassName() {
        return this.validConnectionCheckerClassName;
    }

    @Override
    public void setValidConnectionCheckerClassName(String validConnectionCheckerClassName) {
        this.validConnectionCheckerClassName = validConnectionCheckerClassName;
    }

    @ManagementProperty(name="stale-connection-checker-class-name", description="The DataSource stale connection checker class name", includeInTemplate=true)
    public String getStaleConnectionCheckerClassName() {
        return this.staleConnectionCheckerClassName;
    }

    public void setStaleConnectionCheckerClassName(String staleConnectionCheckerClassName) {
        this.staleConnectionCheckerClassName = staleConnectionCheckerClassName;
    }

    @ManagementProperty(name="url-delimiter", description="The DataSource url delimiter", includeInTemplate=true)
    public String getURLDelimiter() {
        return this.urlDelimiter;
    }

    public void setURLDelimiter(String urlDelimiter) {
        this.urlDelimiter = urlDelimiter;
    }

    @ManagementProperty(name="url-selector-strategy-class-name", description="The DataSource url selector strategy class name", includeInTemplate=true)
    public String getURLSelectorStrategyClassName() {
        return this.urlSelectorStrategyClassName;
    }

    public void setURLSelectorStrategyClassName(String urlSelectorStrategyClassName) {
        this.urlSelectorStrategyClassName = urlSelectorStrategyClassName;
    }

    @Override
    @ManagementProperty(name="prepared-statement-cache-size", description="The DataSource prepared statement cache size", includeInTemplate=true)
    public int getPreparedStatementCacheSize() {
        return this.preparedStatementCacheSize;
    }

    @Override
    public void setPreparedStatementCacheSize(int preparedStatementCacheSize) {
        this.preparedStatementCacheSize = preparedStatementCacheSize;
    }

    @ManagementProperty(name="query-timeout", description="The query timeout", includeInTemplate=true)
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    @ManagementProperty(name="use-try-lock", description="The internal lock timeout", includeInTemplate=true)
    public long getUseTryLock() {
        return this.useTryLock;
    }

    public void setUseTryLock(long useTryLock) {
        this.useTryLock = useTryLock;
    }

    @Override
    @ManagementProperty(name="share-prepared-statements", description="Should prepared statements be shared", includeInTemplate=true)
    public boolean isSharePreparedStatements() {
        return this.sharePreparedStatements;
    }

    @Override
    public void setSharePreparedStatements(boolean sharePreparedStatements) {
        this.sharePreparedStatements = sharePreparedStatements;
    }

    @Override
    @ManagementProperty(name="track-statements", description="The track statements method", includeInTemplate=true)
    public String getTrackStatements() {
        return this.trackStatements;
    }

    @Override
    public void setTrackStatements(String trackStatements) {
        this.trackStatements = trackStatements;
    }

    @Override
    @ManagementProperty(name="set-tx-query-timeout", description="Should query timeout be enabled", includeInTemplate=true)
    public boolean isUseQueryTimeout() {
        return this.useQueryTimeout;
    }

    @Override
    public void setUseQueryTimeout(boolean useQueryTimeout) {
        this.useQueryTimeout = useQueryTimeout;
    }

    @Override
    @ManagementProperty(name="config-property", description="The connection factory property info", managed=true, readOnly=true)
    @ManagementPropertyFactory(value=ConnectionFactoryProperty.class)
    public List<ManagedConnectionFactoryPropertyMetaData> getManagedConnectionFactoryProperties() {
        ArrayList<ManagedConnectionFactoryPropertyMetaData> properties = new ArrayList<ManagedConnectionFactoryPropertyMetaData>();
        ManagedConnectionFactoryPropertyMetaData property = null;
        if (this.getUserName() != null) {
            property = new ManagedConnectionFactoryPropertyMetaData();
            property.setName("UserName");
            property.setValue(this.getUserName());
            properties.add(property);
        }
        if (this.getPassWord() != null) {
            property = new ManagedConnectionFactoryPropertyMetaData();
            property.setName("Password");
            property.setValue(this.getPassWord());
            properties.add(property);
        }
        if (this.getTransactionIsolation() != null) {
            property = new ManagedConnectionFactoryPropertyMetaData();
            property.setName("TransactionIsolation");
            property.setValue(this.getTransactionIsolation());
            properties.add(property);
        }
        if (this.getNewConnectionSQL() != null) {
            property = new ManagedConnectionFactoryPropertyMetaData();
            property.setName("NewConnectionSQL");
            property.setValue(this.getNewConnectionSQL());
            properties.add(property);
        }
        if (this.getCheckValidConnectionSQL() != null) {
            property = new ManagedConnectionFactoryPropertyMetaData();
            property.setName("CheckValidConnectionSQL");
            property.setValue(this.getCheckValidConnectionSQL());
            properties.add(property);
        }
        if (this.getValidConnectionCheckerClassName() != null) {
            property = new ManagedConnectionFactoryPropertyMetaData();
            property.setName("ValidConnectionCheckerClassName");
            property.setValue(this.getValidConnectionCheckerClassName());
            properties.add(property);
        }
        if (this.getExceptionSorterClassName() != null) {
            property = new ManagedConnectionFactoryPropertyMetaData();
            property.setName("ExceptionSorterClassName");
            property.setValue(this.getExceptionSorterClassName());
            properties.add(property);
        }
        if (this.getStaleConnectionCheckerClassName() != null) {
            property = new ManagedConnectionFactoryPropertyMetaData();
            property.setName("StaleConnectionCheckerClassName");
            property.setValue(this.getStaleConnectionCheckerClassName());
            properties.add(property);
        }
        if (this.getURLSelectorStrategyClassName() != null) {
            property = new ManagedConnectionFactoryPropertyMetaData();
            property.setName("URLSelectorStrategyClassName");
            property.setValue(this.getURLSelectorStrategyClassName());
            properties.add(property);
        }
        if (this.getURLDelimiter() != null) {
            property = new ManagedConnectionFactoryPropertyMetaData();
            property.setName("URLDelimiter");
            property.setValue(this.getURLDelimiter());
            properties.add(property);
        }
        property = new ManagedConnectionFactoryPropertyMetaData();
        property.setName("PreparedStatementCacheSize");
        property.setType("int");
        property.setValue(String.valueOf(this.getPreparedStatementCacheSize()));
        properties.add(property);
        property = new ManagedConnectionFactoryPropertyMetaData();
        property.setName("SharePreparedStatements");
        property.setType("boolean");
        property.setValue(String.valueOf(this.isSharePreparedStatements()));
        properties.add(property);
        property = new ManagedConnectionFactoryPropertyMetaData();
        property.setName("QueryTimeout");
        property.setType("int");
        property.setValue(String.valueOf(this.getQueryTimeout()));
        properties.add(property);
        property = new ManagedConnectionFactoryPropertyMetaData();
        property.setName("UseTryLock");
        property.setType("long");
        property.setValue(String.valueOf(this.getUseTryLock()));
        properties.add(property);
        property = new ManagedConnectionFactoryPropertyMetaData();
        property.setName("TransactionQueryTimeout");
        property.setType("boolean");
        property.setValue(String.valueOf(this.isUseQueryTimeout()));
        properties.add(property);
        property = new ManagedConnectionFactoryPropertyMetaData();
        property.setName("ValidateOnMatch");
        property.setType("boolean");
        property.setValue(String.valueOf(this.isValidateOnMatch()));
        properties.add(property);
        if (this.getTrackStatements() != null) {
            property = new ManagedConnectionFactoryPropertyMetaData();
            property.setName("TrackStatements");
            property.setType("java.lang.String");
            property.setValue(String.valueOf(this.getTrackStatements()));
            properties.add(property);
        }
        return properties;
    }
}

