/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.xa;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.resource.adapter.jdbc.URLSelectorStrategy;
import org.jboss.resource.adapter.jdbc.xa.XAManagedConnection;

public class XAManagedConnectionFactory
extends BaseWrapperManagedConnectionFactory {
    private static final long serialVersionUID = 1647927657609573729L;
    private String xaDataSourceClass;
    private String xaDataSourceProperties;
    protected final Properties xaProps = new Properties();
    private Boolean isSameRMOverrideValue;
    private XADataSource xads;
    private String urlProperty;
    private URLSelectorStrategy xadsSelector;

    public String getURLProperty() {
        return this.urlProperty;
    }

    public void setURLProperty(String urlProperty) throws ResourceException {
        this.urlProperty = urlProperty;
        this.initSelector();
    }

    public void setURLDelimiter(String urlDelimiter) throws ResourceException {
        this.urlDelimiter = urlDelimiter;
        this.initSelector();
    }

    private void initSelector() throws JBossResourceException {
        String urlsStr;
        if (this.urlProperty != null && this.urlProperty.length() > 0 && (urlsStr = this.xaProps.getProperty(this.urlProperty)) != null && urlsStr.trim().length() > 0 && this.urlDelimiter != null && this.urlDelimiter.trim().length() > 0) {
            XADataSource xads;
            String url;
            ArrayList<XAData> xaDataList = new ArrayList<XAData>();
            Properties xaPropsCopy = new Properties();
            for (Object key : this.xaProps.keySet()) {
                xaPropsCopy.put(key, this.xaProps.get(key));
            }
            int urlStart = 0;
            int urlEnd = urlsStr.indexOf(this.urlDelimiter);
            while (urlEnd > 0) {
                url = urlsStr.substring(urlStart, urlEnd);
                xaPropsCopy.setProperty(this.urlProperty, url);
                xads = this.createXaDataSource(xaPropsCopy);
                xaDataList.add(new XAData(xads, url));
                urlStart = ++urlEnd;
                urlEnd = urlsStr.indexOf(this.urlDelimiter, urlEnd);
                this.log.debug((Object)("added XA HA connection url: " + url));
            }
            if (urlStart != urlsStr.length()) {
                url = urlsStr.substring(urlStart, urlsStr.length());
                xaPropsCopy.setProperty(this.urlProperty, url);
                xads = this.createXaDataSource(xaPropsCopy);
                xaDataList.add(new XAData(xads, url));
                this.log.debug((Object)("added XA HA connection url: " + url));
            }
            if (this.getUrlSelectorStrategyClassName() == null) {
                this.xadsSelector = new XADataSelector(xaDataList);
                this.log.debug((Object)("Default URLSelectorStrategy is being used : " + this.xadsSelector));
            } else {
                this.xadsSelector = (URLSelectorStrategy)this.loadClass(this.getUrlSelectorStrategyClassName(), xaDataList);
                this.log.debug((Object)("Customized URLSelectorStrategy is being used : " + this.xadsSelector));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private XADataSource createXaDataSource(Properties xaProps) throws JBossResourceException {
        XADataSource xads;
        if (this.getXADataSourceClass() == null) {
            throw new JBossResourceException("No XADataSourceClass supplied!");
        }
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.getXADataSourceClass());
            xads = (XADataSource)clazz.newInstance();
            Class[] NOCLASSES = new Class[]{};
            for (String string : xaProps.keySet()) {
                void var6_12;
                String value = xaProps.getProperty(string);
                char firstCharName = Character.toUpperCase(string.charAt(0));
                if (string.length() > 1) {
                    String string2 = firstCharName + string.substring(1);
                } else {
                    String string3 = "" + firstCharName;
                }
                Class type = null;
                try {
                    Method getter = clazz.getMethod("get" + (String)var6_12, NOCLASSES);
                    type = getter.getReturnType();
                }
                catch (NoSuchMethodException e) {
                    type = String.class;
                }
                Method setter = clazz.getMethod("set" + (String)var6_12, type);
                PropertyEditor editor = PropertyEditorManager.findEditor(type);
                if (editor == null) {
                    throw new JBossResourceException("No property editor found for type: " + type);
                }
                editor.setAsText(value);
                setter.invoke((Object)xads, editor.getValue());
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new JBossResourceException("Class not found for XADataSource " + this.getXADataSourceClass(), cnfe);
        }
        catch (InstantiationException ie) {
            throw new JBossResourceException("Could not create an XADataSource: ", ie);
        }
        catch (IllegalAccessException iae) {
            throw new JBossResourceException("Could not set a property: ", iae);
        }
        catch (IllegalArgumentException iae) {
            throw new JBossResourceException("Could not set a property: ", iae);
        }
        catch (InvocationTargetException ite) {
            throw new JBossResourceException("Could not invoke setter on XADataSource: ", ite);
        }
        catch (NoSuchMethodException nsme) {
            throw new JBossResourceException("Could not find accessor on XADataSource: ", nsme);
        }
        return xads;
    }

    public String getXADataSourceClass() {
        return this.xaDataSourceClass;
    }

    public void setXADataSourceClass(String xaDataSourceClass) {
        this.xaDataSourceClass = xaDataSourceClass;
    }

    public String getXADataSourceProperties() {
        return this.xaDataSourceProperties;
    }

    public void setXADataSourceProperties(String xaDataSourceProperties) throws ResourceException {
        this.xaDataSourceProperties = xaDataSourceProperties;
        this.xaProps.clear();
        if (xaDataSourceProperties != null) {
            xaDataSourceProperties = xaDataSourceProperties.replaceAll("\\\\", "\\\\\\\\");
            ByteArrayInputStream is = new ByteArrayInputStream(xaDataSourceProperties.getBytes());
            try {
                this.xaProps.load(is);
            }
            catch (IOException ioe) {
                throw new JBossResourceException("Could not load connection properties", ioe);
            }
        }
        this.initSelector();
    }

    public Boolean getIsSameRMOverrideValue() {
        return this.isSameRMOverrideValue;
    }

    public void setIsSameRMOverrideValue(Boolean isSameRMOverrideValue) {
        this.isSameRMOverrideValue = isSameRMOverrideValue;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (this.xadsSelector == null) {
            return this.getXAManagedConnection(subject, cri);
        }
        for (int i = 0; i < this.xadsSelector.getCustomSortedUrls().size(); ++i) {
            XAData xaData = (XAData)this.xadsSelector.getUrlObject();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Trying to create an XA connection to " + xaData.url));
            }
            try {
                return this.getXAManagedConnection(subject, cri);
            }
            catch (ResourceException e) {
                this.log.warn((Object)("Failed to create an XA connection to " + xaData.url + ": " + e.getMessage()));
                this.xadsSelector.failedUrlObject(xaData);
                continue;
            }
        }
        throw new JBossResourceException("Could not create connection using any of the URLs: " + this.xadsSelector.getAllUrlObjects());
    }

    public ManagedConnection getXAManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        PooledConnection xaConnection = null;
        Properties props = this.getConnectionProperties(subject, cri);
        try {
            String user = props.getProperty("user");
            String password = props.getProperty("password");
            xaConnection = user != null ? this.getXADataSource().getXAConnection(user, password) : this.getXADataSource().getXAConnection();
            return this.newXAManagedConnection(props, (XAConnection)xaConnection);
        }
        catch (Throwable e) {
            try {
                if (xaConnection != null) {
                    xaConnection.close();
                }
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw new JBossResourceException("Could not create connection", e);
        }
    }

    protected ManagedConnection newXAManagedConnection(Properties props, XAConnection xaConnection) throws SQLException {
        return new XAManagedConnection(this, xaConnection, props, this.transactionIsolation, this.preparedStatementCacheSize);
    }

    public ManagedConnection matchManagedConnections(Set mcs, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties newProps = this.getConnectionProperties(subject, cri);
        for (Object o : mcs) {
            XAManagedConnection mc;
            if (!(o instanceof XAManagedConnection) || !(mc = (XAManagedConnection)o).getProperties().equals(newProps) || (!this.getValidateOnMatch() || !mc.checkValid()) && this.getValidateOnMatch()) continue;
            return mc;
        }
        return null;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.xaDataSourceClass == null ? 0 : this.xaDataSourceClass.hashCode());
        result = result * 37 + this.xaProps.hashCode();
        result = result * 37 + (this.userName == null ? 0 : this.userName.hashCode());
        result = result * 37 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 37 + this.transactionIsolation;
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        XAManagedConnectionFactory otherMcf = (XAManagedConnectionFactory)other;
        return this.xaDataSourceClass.equals(otherMcf.xaDataSourceClass) && this.xaProps.equals(otherMcf.xaProps) && (this.userName == null ? otherMcf.userName == null : this.userName.equals(otherMcf.userName)) && (this.password == null ? otherMcf.password == null : this.password.equals(otherMcf.password)) && this.transactionIsolation == otherMcf.transactionIsolation;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized XADataSource getXADataSource() throws ResourceException {
        if (this.xadsSelector != null) {
            XAData xada = (XAData)this.xadsSelector.getUrlObject();
            return xada.xads;
        }
        if (this.xads == null) {
            if (this.xaDataSourceClass == null) {
                throw new JBossResourceException("No XADataSourceClass supplied!");
            }
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.xaDataSourceClass);
                this.xads = (XADataSource)clazz.newInstance();
                Class[] NOCLASSES = new Class[]{};
                for (String string : this.xaProps.keySet()) {
                    void var4_11;
                    String value = this.xaProps.getProperty(string);
                    char firstCharName = Character.toUpperCase(string.charAt(0));
                    if (string.length() > 1) {
                        String string2 = firstCharName + string.substring(1);
                    } else {
                        String string3 = "" + firstCharName;
                    }
                    Class type = null;
                    try {
                        Method getter = clazz.getMethod("get" + (String)var4_11, NOCLASSES);
                        type = getter.getReturnType();
                    }
                    catch (NoSuchMethodException e) {
                        type = String.class;
                    }
                    Method setter = clazz.getMethod("set" + (String)var4_11, type);
                    PropertyEditor editor = PropertyEditorManager.findEditor(type);
                    if (editor == null) {
                        throw new JBossResourceException("No property editor found for type: " + type);
                    }
                    editor.setAsText(value);
                    setter.invoke((Object)this.xads, editor.getValue());
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new JBossResourceException("Class not found for XADataSource " + this.xaDataSourceClass, cnfe);
            }
            catch (InstantiationException ie) {
                throw new JBossResourceException("Could not create an XADataSource: ", ie);
            }
            catch (IllegalAccessException iae) {
                throw new JBossResourceException("Could not set a property: ", iae);
            }
            catch (IllegalArgumentException iae) {
                throw new JBossResourceException("Could not set a property: ", iae);
            }
            catch (InvocationTargetException ite) {
                throw new JBossResourceException("Could not invoke setter on XADataSource: ", ite);
            }
            catch (NoSuchMethodException nsme) {
                throw new JBossResourceException("Could not find accessor on XADataSource: ", nsme);
            }
        }
        return this.xads;
    }

    protected Properties getXaProps() {
        return this.xaProps;
    }

    private static class XAData {
        public final XADataSource xads;
        public final String url;

        public XAData(XADataSource xads, String url) {
            this.xads = xads;
            this.url = url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof XAData)) {
                return false;
            }
            XAData xaData = (XAData)o;
            return this.url.equals(xaData.url);
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public String toString() {
            return "[XA URL=" + this.url + "]";
        }
    }

    public static class XADataSelector
    implements URLSelectorStrategy {
        private final List xaDataList;
        private int xaDataIndex;
        private XAData xaData;

        public XADataSelector(List xaDataList) {
            if (xaDataList == null || xaDataList.size() == 0) {
                throw new IllegalStateException("Expected non-empty list of XADataSource/URL pairs but got: " + xaDataList);
            }
            this.xaDataList = xaDataList;
        }

        public synchronized XAData getXAData() {
            if (this.xaData == null) {
                if (this.xaDataIndex == this.xaDataList.size()) {
                    this.xaDataIndex = 0;
                }
                this.xaData = (XAData)this.xaDataList.get(this.xaDataIndex++);
            }
            return this.xaData;
        }

        public synchronized void failedXAData(XAData xads) {
            if (xads.equals(this.xaData)) {
                this.xaData = null;
            }
        }

        public List getCustomSortedUrls() {
            return this.xaDataList;
        }

        public void failedUrlObject(Object urlObject) {
            this.failedXAData((XAData)urlObject);
        }

        public List getAllUrlObjects() {
            return this.xaDataList;
        }

        public Object getUrlObject() {
            return this.getXAData();
        }
    }
}

