/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import java.util.Set;
import org.jboss.classloading.spi.dependency.policy.ClassLoaderPolicyModule;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.DeploymentUnit;

public abstract class AbstractDeploymentClassLoaderPolicyModule
extends ClassLoaderPolicyModule {
    private static final long serialVersionUID = 1L;
    private static ControllerState CLASSLOADER_STATE = new ControllerState(DeploymentStages.CLASSLOADER.getName());
    private DeploymentUnit unit;

    private static ClassLoadingMetaData determineClassLoadingMetaData(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        return (ClassLoadingMetaData)unit.getAttachment(ClassLoadingMetaData.class);
    }

    private static String determineContextName(DeploymentUnit unit) {
        Set aliases;
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        ControllerContext context = (ControllerContext)unit.getTopLevel().getAttachment(ControllerContext.class);
        if (context == null) {
            throw new IllegalStateException("Deployment has no controller context");
        }
        String contextName = unit.getName();
        if (!contextName.equals(context.getName()) && (aliases = context.getAliases()) != null && !aliases.contains(contextName)) {
            try {
                context.getController().addAlias((Object)contextName, context.getName());
            }
            catch (Throwable t) {
                throw new RuntimeException("Error adding deployment alias " + contextName + " to " + context, t);
            }
        }
        return contextName;
    }

    public AbstractDeploymentClassLoaderPolicyModule(DeploymentUnit unit) {
        super(AbstractDeploymentClassLoaderPolicyModule.determineClassLoadingMetaData(unit), AbstractDeploymentClassLoaderPolicyModule.determineContextName(unit));
        this.unit = unit;
        ControllerContext context = (ControllerContext)unit.getTopLevel().getAttachment(ControllerContext.class);
        this.setControllerContext(context);
    }

    public DeploymentUnit getDeploymentUnit() {
        return this.unit;
    }

    public ControllerState getClassLoaderState() {
        return CLASSLOADER_STATE;
    }
}

