/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.version;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.classloading.spi.version.Version;
import org.jboss.classloading.spi.version.VersionComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionComparatorRegistry {
    private static VersionComparatorRegistry registry = new VersionComparatorRegistry();
    private Map<Class<?>, Map<Class<?>, VersionComparator<?, ?>>> comparatorMap = new ConcurrentHashMap();

    public VersionComparatorRegistry() {
        this.internalRegisterVersionComparator(Version.class, Version.class, new VersionToVersionComparator(), true);
        this.internalRegisterVersionComparator(Version.class, String.class, new VersionToStringComparator(), true);
        this.internalRegisterVersionComparator(String.class, String.class, new StringToStringComparator(), true);
    }

    public static VersionComparatorRegistry getInstance() {
        return registry;
    }

    public <T, U> void removeVersionComparator(Class<T> t, Class<U> u) {
        this.registerVersionComparator(t, u, null);
    }

    public <T> void removeVersionComparator(Class<T> t) {
        this.registerVersionComparator(t, null);
    }

    public <T> void registerVersionComparator(Class<T> t, VersionComparator<T, T> comparator) {
        this.registerVersionComparator(t, t, comparator);
    }

    public <T, U> void registerVersionComparator(Class<T> t, Class<U> u, VersionComparator<T, U> comparator) {
        this.internalRegisterVersionComparator(t, u, comparator, false);
    }

    private <T, U> void internalRegisterVersionComparator(Class<T> t, Class<U> u, VersionComparator<T, U> comparator, boolean setup) {
        if (t == null || u == null) {
            throw new IllegalArgumentException("Null version class");
        }
        if (!setup) {
            if (t == Version.class && u == Version.class) {
                throw new IllegalArgumentException("You can't remove or replace the built in Version->Version comparator");
            }
            if (t == Version.class && u == String.class) {
                throw new IllegalArgumentException("You can't remove or replace the built in Version->String comparator");
            }
            if (t == String.class && u == Version.class) {
                throw new IllegalArgumentException("You can't remove or replace the built in Version->String comparator");
            }
            if (t == String.class && u == String.class) {
                throw new IllegalArgumentException("You can't remove or replace the built in Version->String comparator");
            }
        }
        if (comparator == null) {
            Map<Class<?>, VersionComparator<?, ?>> uKeyMap;
            Map<Class<?>, VersionComparator<?, ?>> tKeyMap = this.comparatorMap.get(t);
            if (tKeyMap != null) {
                tKeyMap.remove(u);
            }
            if (!t.equals(u) && (uKeyMap = this.comparatorMap.get(u)) != null) {
                uKeyMap.remove(t);
            }
        } else {
            Map<Class<?>, VersionComparator<?, ?>> tKeyMap = this.comparatorMap.get(t);
            if (tKeyMap == null) {
                tKeyMap = new ConcurrentHashMap();
                this.comparatorMap.put(t, tKeyMap);
            }
            tKeyMap.put(u, comparator);
            if (!t.equals(u)) {
                Map<Class<?>, VersionComparator<?, ?>> uKeyMap = this.comparatorMap.get(u);
                if (uKeyMap == null) {
                    uKeyMap = new ConcurrentHashMap();
                    this.comparatorMap.put(u, uKeyMap);
                }
                uKeyMap.put(t, new SwitchVersionComparator<U, T>(comparator));
            }
        }
    }

    protected <T, U> VersionComparator<T, U> getComparator(T t, U u) {
        if (t == null || u == null) {
            return null;
        }
        Class<?> classT = t.getClass();
        Class<?> classU = u.getClass();
        return this.getComparator(classT, classU);
    }

    public <T, U> VersionComparator<T, U> getComparator(Class<T> t, Class<U> u) {
        Map<Class<?>, VersionComparator<?, ?>> map = this.comparatorMap.get(t);
        if (map == null) {
            return null;
        }
        return map.get(u);
    }

    public <T, U> int compare(T t, U u) {
        VersionComparator<T, U> comparator = this.getComparator(t, u);
        if (comparator == null) {
            String classT = null;
            if (t != null) {
                classT = t.getClass().getName();
            }
            String classU = null;
            if (u != null) {
                classU = u.getClass().getName();
            }
            throw new IllegalArgumentException("Missing version comparator for Version pair: (" + classT + "," + classU + ")");
        }
        return comparator.compare(t, u);
    }

    public <T, U> boolean same(T t, U u) {
        VersionComparator<T, U> comparator = this.getComparator(t, u);
        if (comparator == null) {
            return false;
        }
        return comparator.compare(t, u) == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringToStringComparator
    implements VersionComparator<String, String> {
        private StringToStringComparator() {
        }

        @Override
        public int compare(String t, String u) {
            return Version.parseVersion(t).compareTo(Version.parseVersion(u));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VersionToStringComparator
    implements VersionComparator<Version, String> {
        private VersionToStringComparator() {
        }

        @Override
        public int compare(Version t, String u) {
            return t.compareTo(Version.parseVersion(u));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VersionToVersionComparator
    implements VersionComparator<Version, Version> {
        private VersionToVersionComparator() {
        }

        @Override
        public int compare(Version t, Version u) {
            return t.compareTo(u);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SwitchVersionComparator<T, U>
    implements VersionComparator<T, U> {
        private VersionComparator<U, T> delegate;

        public SwitchVersionComparator(VersionComparator<U, T> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException("Null delegate");
            }
            this.delegate = delegate;
        }

        @Override
        public int compare(T t, U u) {
            return -1 * this.delegate.compare(u, t);
        }
    }
}

