/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jboss.as.plugin.deployment.Deployment;
import org.jboss.as.plugin.deployment.IgnoredPackageTypes;
import org.jboss.as.plugin.deployment.common.AbstractServerConnection;
import org.jboss.as.plugin.deployment.domain.DomainDeployment;
import org.jboss.as.plugin.deployment.standalone.StandaloneDeployment;

abstract class AbstractDeployment
extends AbstractServerConnection {
    private static final String NO_NAME_MSG = "No name defined, using default deployment name.";
    private static final String NAME_DEFINED_MSG_FMT = "Using '%s' for the deployment name.";
    private MavenProject project;
    private String name;
    private String packaging;
    private File targetDir;
    private String filename;
    private boolean skip;

    AbstractDeployment() {
    }

    public File file() {
        return new File(this.targetDir, this.filename);
    }

    @Override
    public abstract String goal();

    public abstract Deployment.Type getType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping deployment of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        try {
            if (this.checkPackaging() && IgnoredPackageTypes.isIgnored(this.packaging)) {
                this.getLog().debug((CharSequence)String.format("Ignoring packaging type %s.", this.packaging));
                return;
            }
            this.validate();
            Deployment deployment = null;
            try {
                deployment = this.isDomainServer() ? DomainDeployment.create(this, this.getDomain(), this.file(), this.name, this.getType()) : StandaloneDeployment.create(this, this.file(), this.name, this.getType());
                deployment.execute();
                deployment.close();
            }
            catch (Throwable throwable) {
                this.safeClose(deployment);
                throw throwable;
            }
            this.safeClose(deployment);
            return;
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Could not execute goal %s on %s. Reason: %s", this.goal(), this.file(), e.getMessage()), e);
        }
    }

    protected void validate() throws MojoFailureException {
    }

    protected String nameNotDefinedMessage() {
        return NO_NAME_MSG;
    }

    protected String nameDefinedMessage() {
        return String.format(NAME_DEFINED_MSG_FMT, this.name);
    }

    protected boolean checkPackaging() {
        return true;
    }
}

