/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import org.jboss.as.controller.ModelController;
import org.jboss.as.jmx.model.ModelControllerMBeanServer;
import org.jboss.as.jmx.tcl.TcclMBeanServer;
import org.jboss.as.server.Services;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class MBeanServerService
implements Service<MBeanServer> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "server"});
    private final boolean showModel;
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private MBeanServer mBeanServer;

    private MBeanServerService(boolean showModel) {
        this.showModel = showModel;
    }

    public static ServiceController<?> addService(ServiceTarget batchBuilder, boolean showModel, ServiceListener<Object> ... listeners) {
        MBeanServerService service = new MBeanServerService(showModel);
        return batchBuilder.addService(SERVICE_NAME, (Service)service).addListener(listeners).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(ServiceBuilder.DependencyType.OPTIONAL, Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.modelControllerValue).install();
    }

    public synchronized void start(StartContext context) throws StartException {
        this.mBeanServer = new TcclMBeanServer(ManagementFactory.getPlatformMBeanServer());
        if (this.showModel) {
            this.mBeanServer = new ModelControllerMBeanServer(this.mBeanServer, (ModelController)this.modelControllerValue.getValue());
        }
    }

    public synchronized void stop(StopContext context) {
        this.mBeanServer = null;
    }

    public synchronized MBeanServer getValue() throws IllegalStateException {
        return this.mBeanServer;
    }
}

