/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.jmx.Attribute;
import org.jboss.as.jmx.Element;
import org.jboss.as.jmx.GetMBeanInfoRaw;
import org.jboss.as.jmx.InvokeMBeanRaw;
import org.jboss.as.jmx.JMXConnectorAdd;
import org.jboss.as.jmx.JMXConnectorRemove;
import org.jboss.as.jmx.JMXSubsystemAdd;
import org.jboss.as.jmx.JMXSubsystemProviders;
import org.jboss.as.jmx.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JMXExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jmx";
    private static final String INVOKE_MBEAN_RAW = "invoke-mbean-raw";
    private static final String GET_MBEAN_INFO_RAW = "get-mbean-info-raw";
    static final JMXSubsystemParser parsers = new JMXSubsystemParser();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(JMXSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)JMXSubsystemAdd.INSTANCE, JMXSubsystemProviders.SUBSYTEM_ADD, false);
        registration.registerOperationHandler(INVOKE_MBEAN_RAW, (OperationStepHandler)new InvokeMBeanRaw(), JMXSubsystemProviders.INVOKE_MBEAN_RAW, false);
        registration.registerOperationHandler(GET_MBEAN_INFO_RAW, (OperationStepHandler)new GetMBeanInfoRaw(), JMXSubsystemProviders.GET_MBEAN_INFO_RAW, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)JMXDescribeHandler.INSTANCE, (DescriptionProvider)JMXDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        registration.registerOperationHandler("add-connector", (OperationStepHandler)JMXConnectorAdd.INSTANCE, JMXSubsystemProviders.JMX_CONNECTOR_ADD, false);
        registration.registerOperationHandler("remove-connector", (OperationStepHandler)JMXConnectorRemove.INSTANCE, JMXSubsystemProviders.JMX_CONNECTOR_REMOVE, false);
        subsystem.registerXMLElementWriter((XMLElementWriter)parsers);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.JMX_1_0.getUriString(), (XMLElementReader)parsers);
        context.setSubsystemXmlMapping(Namespace.JMX_1_1.getUriString(), (XMLElementReader)parsers);
    }

    private static ModelNode createAddOperation(Boolean showModel) {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", SUBSYSTEM_NAME);
        if (showModel != null) {
            subsystem.get("show-model").set(showModel.booleanValue());
        }
        return subsystem;
    }

    private static ModelNode createAddConnectorOperation(String serverBinding, String registryBinding) {
        ModelNode connector = new ModelNode();
        connector.get("operation").set("add-connector");
        connector.get("address").add("subsystem", SUBSYSTEM_NAME);
        connector.get("server-binding").set(serverBinding);
        connector.get("registry-binding").set(registryBinding);
        return connector;
    }

    private static class JMXDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final JMXDescribeHandler INSTANCE = new JMXDescribeHandler();

        private JMXDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
            context.getResult().add(JMXExtension.createAddOperation(model.hasDefined("show-model") ? Boolean.valueOf(model.get("show-model").asBoolean()) : null));
            if (model.hasDefined("server-binding")) {
                context.getResult().add(JMXExtension.createAddConnectorOperation(model.require("server-binding").asString(), model.require("registry-binding").asString()));
            }
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    private static class JMXSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        private JMXSubsystemParser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            Namespace schemaVer = Namespace.forUri(reader.getNamespaceURI());
            Boolean showModel = null;
            if (schemaVer == Namespace.JMX_1_0) {
                ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            } else {
                int count = reader.getAttributeCount();
                block6: for (int i = 0; i < count; ++i) {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case SHOW_MODEL: {
                            if (schemaVer == Namespace.JMX_1_0) {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                            showModel = Boolean.valueOf(value);
                            continue block6;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                    }
                }
            }
            list.add(JMXExtension.createAddOperation(showModel));
            boolean gotConnector = false;
            block7: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case JMX_CONNECTOR: {
                        if (gotConnector) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.JMX_CONNECTOR.getLocalName());
                        }
                        this.parseConnector(reader, list);
                        gotConnector = true;
                        continue block7;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        void parseConnector(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            String serverBinding = null;
            String registryBinding = null;
            int count = reader.getAttributeCount();
            block4: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case SERVER_BINDING: {
                        serverBinding = value;
                        continue block4;
                    }
                    case REGISTRY_BINDING: {
                        registryBinding = value;
                        continue block4;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            if (serverBinding == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SERVER_BINDING));
            }
            if (registryBinding == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.REGISTRY_BINDING));
            }
            list.add(JMXExtension.createAddConnectorOperation(serverBinding, registryBinding));
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            Namespace schemaVer = Namespace.CURRENT;
            ModelNode node = context.getModelNode();
            context.startSubsystemElement(schemaVer.getUriString(), false);
            if (node.hasDefined("show-model")) {
                writer.writeAttribute(Attribute.SHOW_MODEL.getLocalName(), node.get("show-model").asString());
            }
            if (node.hasDefined("server-binding")) {
                writer.writeStartElement(Element.JMX_CONNECTOR.getLocalName());
                writer.writeAttribute(Attribute.REGISTRY_BINDING.getLocalName(), node.get("registry-binding").asString());
                writer.writeAttribute(Attribute.SERVER_BINDING.getLocalName(), node.get("server-binding").asString());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }
}

