/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.SimpleInterceptorFactoryContext;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class BasicComponent
implements Component {
    private final String componentName;
    private final Class<?> componentClass;
    private final InterceptorFactory postConstruct;
    private final InterceptorFactory preDestroy;
    private final Map<Method, InterceptorFactory> interceptorFactoryMap;
    private final NamespaceContextSelector namespaceContextSelector;
    private final ServiceName createServiceName;
    private volatile boolean gate;
    private final AtomicBoolean stopping = new AtomicBoolean();

    public BasicComponent(BasicComponentCreateService createService) {
        this.componentName = createService.getComponentName();
        this.componentClass = createService.getComponentClass();
        this.postConstruct = createService.getPostConstruct();
        this.preDestroy = createService.getPreDestroy();
        this.interceptorFactoryMap = createService.getComponentInterceptors();
        this.namespaceContextSelector = createService.getNamespaceContextSelector();
        this.createServiceName = createService.getServiceName();
    }

    @Override
    public ComponentInstance createInstance() {
        BasicComponentInstance instance = this.constructComponentInstance(null, true, (InterceptorFactoryContext)new SimpleInterceptorFactoryContext());
        return instance;
    }

    public ComponentInstance createInstance(Object instance) {
        BasicComponentInstance obj = this.constructComponentInstance((ManagedReference)new ValueManagedReference((Value)new ImmediateValue(instance)), true, (InterceptorFactoryContext)new SimpleInterceptorFactoryContext());
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForComponentStart() {
        if (!this.gate) {
            BasicComponent basicComponent = this;
            synchronized (basicComponent) {
                if (this.stopping.get()) {
                    throw EeMessages.MESSAGES.componentIsStopped();
                }
                while (!this.gate) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw EeMessages.MESSAGES.componentNotAvailable();
                    }
                }
            }
        }
    }

    protected BasicComponentInstance constructComponentInstance(ManagedReference instance, boolean invokePostConstruct, InterceptorFactoryContext context) {
        this.waitForComponentStart();
        context.getContextData().put(Component.class, this);
        Interceptor componentInstancePostConstructInterceptor = this.getPostConstruct().create(context);
        Interceptor componentInstancePreDestroyInterceptor = this.getPreDestroy().create(context);
        AtomicReference instanceReference = (AtomicReference)context.getContextData().get(BasicComponentInstance.INSTANCE_KEY);
        instanceReference.set(instance);
        Map<Method, InterceptorFactory> interceptorFactoryMap = this.getInterceptorFactoryMap();
        IdentityHashMap<Method, Interceptor> interceptorMap = new IdentityHashMap<Method, Interceptor>();
        for (Method method : interceptorFactoryMap.keySet()) {
            interceptorMap.put(method, interceptorFactoryMap.get(method).create(context));
        }
        BasicComponentInstance basicComponentInstance = this.instantiateComponentInstance(instanceReference, componentInstancePreDestroyInterceptor, interceptorMap, context);
        if (invokePostConstruct) {
            InterceptorContext interceptorContext = new InterceptorContext();
            interceptorContext.putPrivateData(Component.class, (Object)this);
            interceptorContext.putPrivateData(ComponentInstance.class, (Object)basicComponentInstance);
            interceptorContext.putPrivateData(InvocationType.class, (Object)InvocationType.POST_CONSTRUCT);
            interceptorContext.setContextData(new HashMap());
            try {
                componentInstancePostConstructInterceptor.processInvocation(interceptorContext);
            }
            catch (Exception e) {
                throw EeMessages.MESSAGES.componentConstructionFailure(e);
            }
        }
        this.componentInstanceCreated(basicComponentInstance, context);
        return basicComponentInstance;
    }

    protected void componentInstanceCreated(BasicComponentInstance basicComponentInstance, InterceptorFactoryContext context) {
    }

    protected BasicComponentInstance instantiateComponentInstance(AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, InterceptorFactoryContext context) {
        return new BasicComponentInstance(this, instanceReference, preDestroyInterceptor, methodInterceptors);
    }

    @Override
    public Class<?> getComponentClass() {
        return this.componentClass;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public ServiceName getCreateServiceName() {
        return this.createServiceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        BasicComponent basicComponent = this;
        synchronized (basicComponent) {
            this.gate = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(StopContext stopContext) {
        if (this.stopping.compareAndSet(false, true)) {
            stopContext.asynchronous();
            BasicComponent basicComponent = this;
            synchronized (basicComponent) {
                this.gate = false;
            }
            stopContext.complete();
        }
    }

    Map<Method, InterceptorFactory> getInterceptorFactoryMap() {
        return this.interceptorFactoryMap;
    }

    InterceptorFactory getPostConstruct() {
        return this.postConstruct;
    }

    InterceptorFactory getPreDestroy() {
        return this.preDestroy;
    }

    void finishDestroy() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.componentName;
    }

    @Override
    public NamespaceContextSelector getNamespaceContextSelector() {
        return this.namespaceContextSelector;
    }

    public static ServiceName serviceNameOf(ServiceName deploymentUnitServiceName, String componentName) {
        return deploymentUnitServiceName.append(new String[]{"component"}).append(new String[]{componentName});
    }
}

