/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.state;

import java.util.Locale;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.ConsoleWrapper;
import org.jboss.as.domain.management.security.state.ErrorState;
import org.jboss.as.domain.management.security.state.PropertyFileFinder;
import org.jboss.as.domain.management.security.state.State;
import org.jboss.as.domain.management.security.state.StateValues;

public class PropertyFilePrompt
implements State {
    private static final int MANAGEMENT = 0;
    private static final int APPLICATION = 1;
    private static final int INVALID = 2;
    private ConsoleWrapper theConsole;
    private StateValues stateValues;

    public PropertyFilePrompt(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
        if (theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
    }

    @Override
    public State execute() {
        this.theConsole.printf("\n", new Object[0]);
        this.theConsole.printf(DomainManagementMessages.MESSAGES.filePrompt(), new Object[0]);
        this.theConsole.printf("\n", new Object[0]);
        String temp = this.theConsole.readLine("(a): ", new Object[0]);
        if (temp == null) {
            this.theConsole.printf("\n", new Object[0]);
            return null;
        }
        if (temp.length() > 0) {
            switch (this.convertResponse(temp)) {
                case 0: {
                    this.stateValues.setManagement(true);
                    this.stateValues.setRealm("ManagementRealm");
                    return new PropertyFileFinder(this.theConsole, this.stateValues);
                }
                case 1: {
                    this.stateValues.setManagement(false);
                    this.stateValues.setRealm("ApplicationRealm");
                    return new PropertyFileFinder(this.theConsole, this.stateValues);
                }
            }
            return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.invalidChoiceResponse(), this);
        }
        this.stateValues.setManagement(true);
        this.stateValues.setRealm("ManagementRealm");
        return new PropertyFileFinder(this.theConsole, this.stateValues);
    }

    private int convertResponse(String response) {
        String temp = response.toLowerCase(Locale.ENGLISH);
        if ("A".equals(temp) || "a".equals(temp)) {
            return 0;
        }
        if ("B".equals(temp) || "b".equals(temp)) {
            return 1;
        }
        return 2;
    }
}

