/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.jacoco.container;

import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.core.internal.instr.InstrSupport;
import org.jacoco.core.runtime.IRuntime;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArquillianRuntime
implements IRuntime {
    private static ArquillianRuntime runtime = null;
    private String sessionId;
    private ExecutionDataStore store = new ExecutionDataStore();
    private long startTimeStamp;

    public static synchronized ArquillianRuntime getInstance() {
        if (runtime == null) {
            runtime = new ArquillianRuntime();
        }
        return runtime;
    }

    private ArquillianRuntime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapExecutionData(Object[] args) {
        Long classid = (Long)args[0];
        String name = (String)args[1];
        int probecount = (Integer)args[2];
        ExecutionDataStore executionDataStore = this.store;
        synchronized (executionDataStore) {
            args[0] = this.store.get(classid, name, probecount).getData();
        }
    }

    protected final void setStartTimeStamp() {
        this.startTimeStamp = System.currentTimeMillis();
    }

    public void setSessionId(String id) {
        this.sessionId = id;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void startup() throws Exception {
        this.setStartTimeStamp();
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(IExecutionDataVisitor executionDataVisitor, ISessionInfoVisitor sessionInfoVisitor, boolean reset) {
        ExecutionDataStore executionDataStore = this.store;
        synchronized (executionDataStore) {
            if (sessionInfoVisitor != null) {
                SessionInfo info = new SessionInfo(this.sessionId, this.startTimeStamp, System.currentTimeMillis());
                sessionInfoVisitor.visitSessionInfo(info);
            }
            this.store.accept(executionDataVisitor);
            if (reset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ExecutionDataStore executionDataStore = this.store;
        synchronized (executionDataStore) {
            this.store.reset();
            this.setStartTimeStamp();
        }
    }

    public int generateDataAccessor(long classid, String classname, int probecount, MethodVisitor mv) {
        ArquillianRuntime.generateArgumentArray(classid, classname, probecount, mv);
        mv.visitInsn(89);
        mv.visitMethodInsn(184, "org/jboss/arquillian/extension/jacoco/container/ArquillianRuntime", "getInstance", "()Lorg/jboss/arquillian/extension/jacoco/container/ArquillianRuntime;");
        mv.visitInsn(95);
        mv.visitMethodInsn(182, "org/jboss/arquillian/extension/jacoco/container/ArquillianRuntime", "swapExecutionData", "([Ljava/lang/Object;)V");
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "[Z");
        return 5;
    }

    public static void generateArgumentArray(long classid, String classname, int probecount, MethodVisitor mv) {
        mv.visitInsn(6);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitLdcInsn((Object)classid);
        mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        mv.visitInsn(83);
        mv.visitInsn(89);
        mv.visitInsn(4);
        mv.visitLdcInsn((Object)classname);
        mv.visitInsn(83);
        mv.visitInsn(89);
        mv.visitInsn(5);
        InstrSupport.push((MethodVisitor)mv, (int)probecount);
        mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        mv.visitInsn(83);
    }

    public void disconnect(Class<?> type) throws Exception {
        throw new UnsupportedOperationException();
    }
}

