/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.glassfish.embedded_3_1;

import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebModule;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.embeddable.web.Context;
import org.glassfish.embeddable.web.WebContainer;
import org.jboss.arquillian.container.glassfish.embedded_3_1.GlassFishConfiguration;
import org.jboss.arquillian.container.glassfish.embedded_3_1.ShrinkWrapUtil;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishContainer
implements DeployableContainer<GlassFishConfiguration> {
    private static final Logger log = Logger.getLogger(GlassFishContainer.class.getName());
    private static final String COMMAND_ADD_RESOURCES = "add-resources";
    private static final String ADDRESS = "localhost";
    private GlassFishConfiguration configuration;
    private GlassFishRuntime glassfishRuntime;
    private GlassFish glassfish;

    public Class<GlassFishConfiguration> getConfigurationClass() {
        return GlassFishConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public void setup(GlassFishConfiguration configuration) {
        this.configuration = configuration;
        BootstrapProperties bootstrapProps = new BootstrapProperties();
        if (configuration.getInstallRoot() != null) {
            bootstrapProps.setInstallRoot(configuration.getInstallRoot());
        }
        try {
            this.glassfishRuntime = GlassFishRuntime.bootstrap((BootstrapProperties)bootstrapProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not setup GlassFish Embedded Bootstrap", e);
        }
        GlassFishProperties serverProps = new GlassFishProperties();
        boolean shouldSetPort = true;
        if (configuration.getInstanceRoot() != null) {
            File instanceRoot = new File(configuration.getInstanceRoot());
            if (!instanceRoot.exists()) {
                instanceRoot.mkdirs();
            }
            serverProps.setInstanceRoot(configuration.getInstanceRoot());
            shouldSetPort = false;
        }
        if (configuration.getConfigurationXml() != null) {
            serverProps.setConfigFileURI(configuration.getConfigurationXml());
            shouldSetPort = false;
        }
        serverProps.setConfigFileReadOnly(configuration.isConfigurationReadOnly());
        if (shouldSetPort) {
            serverProps.setPort("http-listener", configuration.getBindHttpPort());
        }
        try {
            this.glassfish = this.glassfishRuntime.newGlassFish(serverProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not setup GlassFish Embedded Runtime", e);
        }
    }

    public void start() throws LifecycleException {
        try {
            this.glassfish.start();
            this.bindCommandRunner();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start GlassFish Embedded", (Throwable)e);
        }
        for (String resource : this.configuration.getSunResourcesXml()) {
            try {
                this.executeCommand(COMMAND_ADD_RESOURCES, resource);
            }
            catch (Throwable e) {
                throw new RuntimeException("Could not deploy sun-reosurces file: " + resource, e);
            }
        }
    }

    public void stop() throws LifecycleException {
        try {
            this.unbindCommandRunner();
            this.glassfish.stop();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop GlassFish Embedded", (Throwable)e);
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        String deploymentName = this.createDeploymentName(archive.getName());
        try {
            URL deploymentUrl = ShrinkWrapUtil.toURL(archive);
            this.glassfish.getDeployer().deploy(deploymentUrl.toURI(), new String[]{"--name", deploymentName});
        }
        catch (Exception e) {
            throw new DeploymentException("Could not deploy " + archive.getName(), (Throwable)e);
        }
        try {
            HTTPContext httpContext = new HTTPContext(ADDRESS, this.configuration.getBindHttpPort());
            this.findServlets(httpContext, this.resolveWebArchiveNames(archive));
            return new ProtocolMetaData().addContext((Object)httpContext);
        }
        catch (GlassFishException e) {
            throw new DeploymentException("Could not probe GlassFish embedded for environment", (Throwable)e);
        }
    }

    private String[] resolveWebArchiveNames(Archive<?> archive) {
        if (archive instanceof WebArchive) {
            return new String[]{this.createDeploymentName(archive.getName())};
        }
        if (archive instanceof EnterpriseArchive) {
            Map webArchives = archive.getContent(Filters.include((String)".*\\.war"));
            ArrayList<String> deploymentNames = new ArrayList<String>();
            for (ArchivePath path : webArchives.keySet()) {
                deploymentNames.add(this.createDeploymentName(path.get()));
            }
            return deploymentNames.toArray(new String[0]);
        }
        return new String[0];
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        try {
            this.glassfish.getDeployer().undeploy(this.createDeploymentName(archive.getName()), new String[0]);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not undeploy " + archive.getName(), (Throwable)e);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    private String createDeploymentName(String archiveName) {
        String correctedName = archiveName;
        if (correctedName.startsWith("/")) {
            correctedName = correctedName.substring(1);
        }
        if (correctedName.indexOf(".") != -1) {
            correctedName = correctedName.substring(0, correctedName.lastIndexOf("."));
        }
        return correctedName;
    }

    public void findServlets(HTTPContext httpContext, String[] webArchiveNames) throws GlassFishException {
        WebContainer webContainer = (WebContainer)this.glassfish.getService(WebContainer.class);
        for (String deploymentName : webArchiveNames) {
            for (org.glassfish.embeddable.web.VirtualServer server : webContainer.getVirtualServers()) {
                Container child;
                WebModule webModule = null;
                for (Context context : server.getContexts()) {
                    if (!(context instanceof WebModule) || !((WebModule)context).getID().startsWith(deploymentName)) continue;
                    webModule = (WebModule)context;
                }
                if (webModule == null && server instanceof VirtualServer && (child = ((VirtualServer)server).findChild("/" + deploymentName)) instanceof WebModule) {
                    webModule = (WebModule)child;
                }
                if (webModule == null) continue;
                for (Map.Entry entry : webModule.getServletRegistrations().entrySet()) {
                    httpContext.add(new Servlet((String)entry.getKey(), webModule.getContextPath()));
                }
            }
        }
    }

    private void executeCommand(String command, String ... parameterList) throws Throwable {
        CommandRunner runner = this.glassfish.getCommandRunner();
        CommandResult result = runner.run(command, parameterList);
        switch (result.getExitStatus()) {
            case FAILURE: 
            case WARNING: {
                throw result.getFailureCause();
            }
            case SUCCESS: {
                log.info("command " + command + " result: " + result.getOutput());
            }
        }
    }

    private void bindCommandRunner() throws NamingException, GlassFishException {
        CommandRunner runner = this.glassfish.getCommandRunner();
        new InitialContext().bind("org.glassfish.embeddable.CommandRunner", (Object)runner);
    }

    private void unbindCommandRunner() throws NamingException {
        new InitialContext().unbind("org.glassfish.embeddable.CommandRunner");
    }
}

