/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.portlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.filter.PortletRequestWrapper;
import org.apache.commons.lang.ArrayUtils;

public class ParameterAddingPortletRequestWrapper
extends PortletRequestWrapper {
    private final Map<String, String[]> additionalPrivateParameters = new LinkedHashMap();
    private final Map<String, String[]> additionalPublicParameters = new LinkedHashMap();

    public ParameterAddingPortletRequestWrapper(PortletRequest request) {
        super(request);
    }

    public String[] putPublicParameters(String name, String[] values) {
        return this.additionalPublicParameters.put(name, values);
    }

    public String[] putPrivateParameters(String name, String[] values) {
        return this.additionalPrivateParameters.put(name, values);
    }

    public void putPublicAllParameter(Map<String, String[]> params) {
        this.additionalPublicParameters.putAll(params);
    }

    public void putPrivateAllParameter(Map<String, String[]> params) {
        this.additionalPrivateParameters.putAll(params);
    }

    public String getParameter(String name) {
        Object[] values = this.getParameterValues(name);
        if (ArrayUtils.isNotEmpty((Object[])values)) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        LinkedHashMap parameterMap = new LinkedHashMap();
        parameterMap.putAll(super.getParameterMap());
        parameterMap.putAll(this.additionalPublicParameters);
        parameterMap.putAll(this.additionalPrivateParameters);
        return Collections.unmodifiableMap(parameterMap);
    }

    public Enumeration<String> getParameterNames() {
        Map parameterMap = this.getParameterMap();
        return Collections.enumeration(parameterMap.keySet());
    }

    public String[] getParameterValues(String name) {
        if (this.additionalPrivateParameters.containsKey(name)) {
            return (String[])this.additionalPrivateParameters.get(name);
        }
        if (this.additionalPublicParameters.containsKey(name)) {
            return (String[])this.additionalPublicParameters.get(name);
        }
        return super.getParameterValues(name);
    }

    public Map<String, String[]> getPrivateParameterMap() {
        LinkedHashMap parameterMap = new LinkedHashMap();
        parameterMap.putAll(super.getParameterMap());
        parameterMap.putAll(this.additionalPrivateParameters);
        return Collections.unmodifiableMap(parameterMap);
    }

    public Map<String, String[]> getPublicParameterMap() {
        LinkedHashMap parameterMap = new LinkedHashMap();
        parameterMap.putAll(super.getParameterMap());
        parameterMap.putAll(this.additionalPublicParameters);
        return Collections.unmodifiableMap(parameterMap);
    }
}

