/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.mvc.tests;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import javax.portlet.PortletSession;
import org.jasig.portlet.test.mvc.tests.BasePortletTest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller(value="fileUploadTest")
@RequestMapping(value={"VIEW", "EDIT", "HELP", "ABOUT"}, params={"currentTest=fileUploadTest"})
public class FileUploadController
extends BasePortletTest {
    private static final String UPLOADED_FILE_INFO = FileUploadController.class.getName() + ".UPLOADED_FILE_INFO";

    public String getTestName() {
        return "File Upload Test";
    }

    @RenderMapping
    public String viewFileUploadTest(PortletSession portletSession, ModelMap model) {
        this.logger.debug("Rendering File Upload Test");
        Map fileInfo = (Map)portletSession.getAttribute(UPLOADED_FILE_INFO);
        model.put((Object)"fileInfo", (Object)fileInfo);
        return "fileUploadTest";
    }

    @ActionMapping
    public void noopAction() {
    }

    @ActionMapping(value="fileUploadAction")
    public void simpleFileUpload(PortletSession portletSession, @RequestParam(value="file") MultipartFile f) throws IOException {
        ImmutableMap fileInfo = ImmutableMap.of((Object)"size", (Object)f.getSize(), (Object)"originalFilename", (Object)f.getOriginalFilename(), (Object)"name", (Object)f.getName(), (Object)"contentType", (Object)f.getContentType(), (Object)"byteCount", (Object)f.getBytes().length);
        portletSession.setAttribute(UPLOADED_FILE_INFO, (Object)fileInfo);
    }
}

