/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.plugin.mojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.jasig.portal.plugin.mojo.AbstractTomcatWarDeployerMojo;

public class DeployWarMojo
extends AbstractTomcatWarDeployerMojo {
    private String artifactId;
    private String artifactGroupId;
    private String artifactVersion;
    private String artifactClassifier;
    private String contextName;
    private File ear;
    private boolean extractWars = false;
    private boolean removeExistingDirectories = false;
    private boolean useTempDir = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        block20: {
            File fullWebAppsDir = new File(this.getWebAppsDir());
            Log log = this.getLog();
            if (this.contextName.endsWith(".war")) {
                this.contextName = this.contextName.substring(this.contextName.length() - 4);
            }
            if (this.contextName.startsWith("/")) {
                this.contextName = this.contextName.substring(1);
            }
            Artifact artifact = this.artifactClassifier == null ? this.artifactFactory.createArtifact(this.artifactGroupId, this.artifactId, "default", this.artifactVersion, "war") : this.artifactFactory.createArtifactWithClassifier(this.artifactGroupId, this.artifactId, this.artifactVersion, "war", this.artifactClassifier);
            try {
                this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
                File artifactFile = artifact.getFile();
                if (!this.extractWars) {
                    if (this.removeExistingDirectories) {
                        this.removeExisting(fullWebAppsDir, this.contextName);
                    }
                    File deployedFile = new File(fullWebAppsDir, this.contextName.concat(".war"));
                    FileInputStream jarEntryStream = new FileInputStream(artifactFile);
                    try {
                        FileOutputStream jarOutStream = new FileOutputStream(deployedFile);
                        try {
                            IOUtils.copy((InputStream)jarEntryStream, (OutputStream)jarOutStream);
                            break block20;
                        }
                        finally {
                            IOUtils.closeQuietly((OutputStream)jarOutStream);
                        }
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)jarEntryStream);
                    }
                }
                if (this.useTempDir) {
                    File tmpDir = new File(System.getProperty("java.io.tmpdir"), "jasig");
                    FileUtils.forceMkdir((File)tmpDir);
                    File contextTmpDir = new File(tmpDir, this.contextName);
                    FileUtils.deleteDirectory((File)contextTmpDir);
                    FileUtils.forceMkdir((File)contextTmpDir);
                    log.info((CharSequence)("Extracting war for context " + this.contextName));
                    this.extractWar(artifactFile, contextTmpDir, this.contextName);
                    if (this.removeExistingDirectories) {
                        this.removeExisting(fullWebAppsDir, this.contextName);
                    }
                    log.info((CharSequence)"Copying extracted war");
                    File contextDir = new File(fullWebAppsDir, this.contextName);
                    FileUtils.moveDirectory((File)contextTmpDir, (File)contextDir);
                } else {
                    if (this.removeExistingDirectories) {
                        this.removeExisting(fullWebAppsDir, this.contextName);
                    }
                    File contextDir = new File(fullWebAppsDir, this.contextName);
                    this.extractWar(artifactFile, contextDir, this.contextName);
                }
            }
            catch (ArtifactResolutionException ex) {
                this.getLog().error((CharSequence)"Failed to resolve artifact", (Throwable)ex);
                throw new MojoFailureException("Failed to resolve artifact " + artifact);
            }
            catch (ArtifactNotFoundException ex) {
                this.getLog().error((CharSequence)"Failed to find artifact", (Throwable)ex);
                throw new MojoFailureException("Failed to find artifact " + artifact);
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)"Failed to deploy artifact", (Throwable)ex);
                throw new MojoFailureException("Failed to deploy artifact " + artifact);
            }
            catch (NoSuchArchiverException ex) {
                this.getLog().error((CharSequence)"Failed to unpack artifact", (Throwable)ex);
                throw new MojoFailureException("Failed to find artifact " + artifact);
            }
            catch (ArchiverException ex) {
                this.getLog().error((CharSequence)"Failed to unpack artifact", (Throwable)ex);
                throw new MojoFailureException("Failed to unpack artifact " + artifact);
            }
        }
    }
}

