/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.server.memcached.ByteBufPool;
import org.infinispan.server.memcached.MemcachedBaseDecoder;
import org.infinispan.server.memcached.MemcachedResponse;
import org.infinispan.server.memcached.logging.Log;
import org.infinispan.server.memcached.logging.MemcachedAccessLogging;
import org.infinispan.util.logging.LogFactory;

public class MemcachedInboundAdapter
extends ChannelInboundHandlerAdapter {
    static final AttributeKey<ByteBufPool> ALLOCATOR_KEY = AttributeKey.valueOf((String)"allocator");
    protected static final int MINIMUM_BUFFER_SIZE;
    protected static final Log log;
    private final MemcachedBaseDecoder decoder;
    protected ByteBuf outbound;
    protected ChannelProgressivePromise progressive;
    private long progressiveStart;
    private long progressiveEnd;
    protected boolean resumeAutoReadOnWritability;

    public MemcachedInboundAdapter(MemcachedBaseDecoder decoder) {
        this.decoder = decoder;
    }

    public static ByteBufPool getAllocator(ChannelHandlerContext ctx) {
        ByteBufPool allocator = (ByteBufPool)ctx.channel().attr(ALLOCATOR_KEY).get();
        if (allocator == null) {
            throw new IllegalStateException("Context does not have a buffer allocator");
        }
        return allocator;
    }

    private void flushBufferIfNeeded(ChannelHandlerContext ctx, boolean runOnEventLoop, MemcachedResponse res) {
        if (this.outbound != null) {
            if (runOnEventLoop) {
                ctx.channel().eventLoop().execute(() -> {
                    ChannelPromise p = ctx.newPromise();
                    ctx.writeAndFlush((Object)this.outbound, p);
                    if (res != null && this.progressive != null) {
                        res.flushed((ChannelFuture)p);
                    }
                    this.notifyPendingResponses(ctx, (ChannelFuture)p);
                    this.outbound = null;
                });
            } else {
                ChannelPromise p = ctx.newPromise();
                ctx.writeAndFlush((Object)this.outbound, p);
                if (res != null && this.progressive != null) {
                    res.flushed((ChannelFuture)p);
                }
                this.notifyPendingResponses(ctx, (ChannelFuture)p);
                this.outbound = null;
            }
        }
    }

    public void flushBufferIfNeeded(ChannelHandlerContext ctx) {
        assert (ctx.channel().eventLoop().inEventLoop());
        this.flushBufferIfNeeded(ctx, false, null);
    }

    private void notifyPendingResponses(ChannelHandlerContext ctx, ChannelFuture future) {
        assert (ctx.channel().eventLoop().inEventLoop());
        if (this.progressive == null) {
            return;
        }
        if (this.progressiveEnd == this.progressiveStart) {
            return;
        }
        long s = this.progressiveStart;
        long e = this.progressiveEnd;
        future.addListener(ignore -> this.progressive.tryProgress(s, e));
        this.progressiveStart = this.progressiveEnd;
    }

    private ByteBuf allocateBuffer(ChannelHandlerContext ctx, int size) {
        if (this.outbound != null) {
            if (this.outbound.writableBytes() > size) {
                return this.outbound;
            }
            ctx.write((Object)this.outbound, ctx.voidPromise());
        }
        int allocatedSize = Math.max(size, MINIMUM_BUFFER_SIZE);
        this.outbound = ctx.alloc().buffer(allocatedSize, allocatedSize);
        return this.outbound;
    }

    private void resumeAutoRead(ChannelHandlerContext ctx) {
        ctx.channel().config().setAutoRead(true);
        this.decoder.resumeRead();
    }

    public void handleExceptionally(ChannelHandlerContext ctx, MemcachedResponse response) {
        assert (!response.isSuccessful());
        ByteBufPool allocator = (ByteBufPool)ctx.channel().attr(ALLOCATOR_KEY).get();
        response.writeFailure(allocator);
        this.registerResponseForLater(response);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().attr(ALLOCATOR_KEY).set(size -> this.allocateBuffer(ctx, size));
        this.progressive = MemcachedAccessLogging.isEnabled() ? ctx.newProgressivePromise() : null;
        super.handlerAdded(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        if (this.progressive != null) {
            this.progressive.setSuccess();
        }
        super.channelUnregistered(ctx);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().config().isAutoRead()) {
            this.flushBufferIfNeeded(ctx);
        }
        super.channelReadComplete(ctx);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (this.resumeAutoReadOnWritability && ctx.channel().isWritable()) {
            this.resumeAutoReadOnWritability = false;
            this.resumeAutoRead(ctx);
        }
        super.channelWritabilityChanged(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg == null) {
            return;
        }
        this.handleResponse(ctx, (MemcachedResponse)msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.unexpectedException(cause);
        if (ctx.channel().isOpen()) {
            this.flushBufferIfNeeded(ctx);
        }
        ctx.close();
    }

    private void handleResponse(ChannelHandlerContext ctx, MemcachedResponse res) {
        CompletionStage<?> cs = res.getResponse();
        if (CompletionStages.isCompletedSuccessfully(cs)) {
            Object result = CompletionStages.join(cs);
            res.writeResponse(result, (ByteBufPool)ctx.channel().attr(ALLOCATOR_KEY).get());
            if (this.outbound != null && (long)this.outbound.readableBytes() > ctx.channel().bytesBeforeUnwritable()) {
                this.flushBufferIfNeeded(ctx, true, res);
                ctx.channel().config().setAutoRead(false);
                this.resumeAutoReadOnWritability = true;
                return;
            }
            this.registerResponseForLater(res);
            return;
        }
        ctx.channel().config().setAutoRead(false);
        cs.whenCompleteAsync((obj, t) -> {
            assert (ctx.channel().eventLoop().inEventLoop());
            ByteBufPool allocator = (ByteBufPool)ctx.channel().attr(ALLOCATOR_KEY).get();
            if (t != null) {
                res.writeFailure((Throwable)t, allocator);
                this.flushBufferIfNeeded(ctx, false, res);
                return;
            }
            res.writeResponse(obj, allocator);
            this.flushBufferIfNeeded(ctx, false, res);
            this.resumeAutoRead(ctx);
        }, (Executor)ctx.channel().eventLoop());
    }

    private void registerResponseForLater(MemcachedResponse res) {
        if (this.progressive != null) {
            this.progressive.addListener((GenericFutureListener)new MemcachedProgressiveListener(res, this.progressiveEnd++));
        }
    }

    static {
        log = (Log)LogFactory.getLog(MemcachedInboundAdapter.class, Log.class);
        MINIMUM_BUFFER_SIZE = Integer.parseInt(System.getProperty("infinispan.memcached.minimum-buffer-size", "4096"));
    }

    private static class MemcachedProgressiveListener
    implements ChannelProgressiveFutureListener {
        private final MemcachedResponse res;
        private final long id;

        private MemcachedProgressiveListener(MemcachedResponse res, long offset) {
            this.res = res;
            this.id = offset;
        }

        public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
            if (this.id >= progress && this.id <= total) {
                this.res.flushed(future.channel().newSucceededFuture());
                future.removeListener((GenericFutureListener)this);
            }
        }

        public void operationComplete(ChannelProgressiveFuture future) {
            this.res.flushed((ChannelFuture)future);
        }
    }
}

