/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.Random;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.spi.AlwaysRemoveXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.DefaultXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.PreferNonNullXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.PreferNullXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.SiteEntry;
import org.infinispan.xsite.spi.XSiteEntryMergePolicy;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="xsite.XSiteMergePolicyUnitTest")
public class XSiteMergePolicyUnitTest
extends AbstractInfinispanTest {
    private static final Random RANDOM = new Random(System.currentTimeMillis());

    private static Sync defaultMergePolicy() {
        return new Sync((XSiteEntryMergePolicy<String, String>)DefaultXSiteEntryMergePolicy.getInstance());
    }

    public static Sync preferNonNullMergePolicy() {
        return new Sync((XSiteEntryMergePolicy<String, String>)PreferNonNullXSiteEntryMergePolicy.getInstance());
    }

    public static Sync preferNullMergePolicy() {
        return new Sync((XSiteEntryMergePolicy<String, String>)PreferNullXSiteEntryMergePolicy.getInstance());
    }

    public static Sync alwaysRemoveMergePolicy() {
        return new Sync((XSiteEntryMergePolicy<String, String>)AlwaysRemoveXSiteEntryMergePolicy.getInstance());
    }

    @DataProvider(name="alwaysRemoveData")
    private static Object[][] alwaysRemoveDataProvider() {
        SiteEntryMode[] values = SiteEntryMode.values();
        Object[][] result = new Object[values.length * 2][3];
        int i = 0;
        for (SiteEntryMode mode : values) {
            result[i] = XSiteMergePolicyUnitTest.createInputs(mode, "LON", "NYC");
            result[i++][2] = XSiteMergePolicyUnitTest.newNullSiteEntry("LON");
            result[i] = XSiteMergePolicyUnitTest.createInputs(mode, "1NYC", "2LON");
            result[i++][2] = XSiteMergePolicyUnitTest.newNullSiteEntry("1NYC");
        }
        return result;
    }

    @DataProvider(name="defaultData")
    private static Object[][] defaultDataProvider() {
        SiteEntryMode[] values = SiteEntryMode.values();
        Object[][] result = new Object[values.length * 2][3];
        int i = 0;
        for (SiteEntryMode mode : values) {
            result[i] = XSiteMergePolicyUnitTest.createInputs(mode, "LON", "NYC");
            result[i][2] = result[i][0];
            result[++i] = XSiteMergePolicyUnitTest.createInputs(mode, "1NYC", "2LON");
            result[i][2] = result[i][0];
            ++i;
        }
        return result;
    }

    @DataProvider(name="preferNullData")
    private static Object[][] preferNullDataProvider() {
        SiteEntryMode[] values = SiteEntryMode.values();
        Object[][] result = new Object[values.length * 2][3];
        int i = 0;
        for (SiteEntryMode mode : values) {
            result[i] = XSiteMergePolicyUnitTest.createInputs(mode, "LON", "NYC");
            result[i][2] = mode == SiteEntryMode.S2_NULL ? result[i][1] : result[i][0];
            result[++i] = XSiteMergePolicyUnitTest.createInputs(mode, "1NYC", "2LON");
            result[i][2] = mode == SiteEntryMode.S2_NULL ? result[i][1] : result[i][0];
            ++i;
        }
        return result;
    }

    @DataProvider(name="preferNonNullData")
    private static Object[][] preferNonNullDataProvider() {
        SiteEntryMode[] values = SiteEntryMode.values();
        Object[][] result = new Object[values.length * 2][3];
        int i = 0;
        for (SiteEntryMode mode : values) {
            result[i] = XSiteMergePolicyUnitTest.createInputs(mode, "LON", "NYC");
            result[i][2] = mode == SiteEntryMode.S1_NULL ? result[i][1] : result[i][0];
            result[++i] = XSiteMergePolicyUnitTest.createInputs(mode, "1NYC", "2LON");
            result[i][2] = mode == SiteEntryMode.S1_NULL ? result[i][1] : result[i][0];
            ++i;
        }
        return result;
    }

    private static SiteEntry<String> newNullSiteEntry(String site) {
        return new SiteEntry(site, null, null);
    }

    private static SiteEntry<String> newSiteEntry(String site) {
        return new SiteEntry(site, (Object)TestingUtil.generateRandomString(8, RANDOM), null);
    }

    private static Object[] createInputs(SiteEntryMode mode, String lowerString, String upperString) {
        return new Object[]{mode.s1(lowerString), mode.s2(upperString), null};
    }

    @Test(dataProvider="preferNonNullData")
    public void testPreferNonNullMergePolicy(SiteEntry<String> s1, SiteEntry<String> s2, SiteEntry<String> r) {
        this.doTest(XSiteMergePolicyUnitTest.preferNonNullMergePolicy(), s1, s2, r);
    }

    @Test(dataProvider="preferNullData")
    public void testPreferNullMergePolicy(SiteEntry<String> s1, SiteEntry<String> s2, SiteEntry<String> r) {
        this.doTest(XSiteMergePolicyUnitTest.preferNullMergePolicy(), s1, s2, r);
    }

    @Test(dataProvider="defaultData")
    public void testDefaultMergePolicy(SiteEntry<String> s1, SiteEntry<String> s2, SiteEntry<String> r) {
        this.doTest(XSiteMergePolicyUnitTest.defaultMergePolicy(), s1, s2, r);
    }

    @Test(dataProvider="alwaysRemoveData")
    public void testAlwaysNull(SiteEntry<String> s1, SiteEntry<String> s2, SiteEntry<String> r) {
        this.doTest(XSiteMergePolicyUnitTest.alwaysRemoveMergePolicy(), s1, s2, r);
    }

    private void doTest(Sync mergePolicy, SiteEntry<String> s1, SiteEntry<String> s2, SiteEntry<String> expected) {
        SiteEntry<String> result = mergePolicy.merge(s1, s2);
        AssertJUnit.assertEquals(expected, result);
        result = mergePolicy.merge(s2, s1);
        AssertJUnit.assertEquals(expected, result);
    }

    private static class Sync {
        private final XSiteEntryMergePolicy<String, String> mergePolicy;

        private Sync(XSiteEntryMergePolicy<String, String> mergePolicy) {
            this.mergePolicy = mergePolicy;
        }

        SiteEntry<String> merge(SiteEntry<String> s1, SiteEntry<String> s2) {
            return (SiteEntry)CompletionStages.join((CompletionStage)this.mergePolicy.merge((Object)"key", s1, s2));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum SiteEntryMode {
        BOTH_NON_NULL{

            @Override
            SiteEntry<String> s1(String site) {
                return XSiteMergePolicyUnitTest.newSiteEntry(site);
            }

            @Override
            SiteEntry<String> s2(String site) {
                return XSiteMergePolicyUnitTest.newSiteEntry(site);
            }
        }
        ,
        BOTH_NULL{

            @Override
            SiteEntry<String> s1(String site) {
                return XSiteMergePolicyUnitTest.newNullSiteEntry(site);
            }

            @Override
            SiteEntry<String> s2(String site) {
                return XSiteMergePolicyUnitTest.newNullSiteEntry(site);
            }
        }
        ,
        S1_NULL{

            @Override
            SiteEntry<String> s1(String site) {
                return XSiteMergePolicyUnitTest.newNullSiteEntry(site);
            }

            @Override
            SiteEntry<String> s2(String site) {
                return XSiteMergePolicyUnitTest.newSiteEntry(site);
            }
        }
        ,
        S2_NULL{

            @Override
            SiteEntry<String> s1(String site) {
                return XSiteMergePolicyUnitTest.newSiteEntry(site);
            }

            @Override
            SiteEntry<String> s2(String site) {
                return XSiteMergePolicyUnitTest.newNullSiteEntry(site);
            }
        };


        abstract SiteEntry<String> s1(String var1);

        abstract SiteEntry<String> s2(String var1);
    }
}

