/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.logging.events;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.infinispan.commons.time.DefaultTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestException;
import org.infinispan.util.logging.events.EventLog;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogLevel;
import org.infinispan.util.logging.events.EventLoggerNotifier;
import org.infinispan.util.logging.events.impl.BasicEventLogger;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(testName="events.BasicEventLoggerTest", groups={"unit"})
public class BasicEventLoggerTest
extends AbstractInfinispanTest {
    @DataProvider(name="levels-categories")
    public Object[][] levelCategoriesProvider() {
        return (Object[][])Stream.of(EventLogLevel.values()).flatMap(level -> Stream.of(EventLogCategory.values()).map(category -> new Object[]{level, category})).toArray(x$0 -> new Object[x$0][]);
    }

    @Test(dataProvider="levels-categories")
    public void shouldSendNotification(EventLogLevel level, EventLogCategory category) throws InterruptedException {
        EventLoggerNotifier notifier = (EventLoggerNotifier)Mockito.mock(EventLoggerNotifier.class);
        CountDownLatch latch = new CountDownLatch(1);
        ArgumentCaptor logged = ArgumentCaptor.forClass(EventLog.class);
        BasicEventLogger logger = new BasicEventLogger(notifier, (TimeService)DefaultTimeService.INSTANCE);
        Mockito.when((Object)notifier.notifyEventLogged((EventLog)logged.capture())).thenAnswer(invocation -> {
            latch.countDown();
            return CompletableFutures.completedNull();
        });
        logger.log(level, category, "Lorem");
        if (!latch.await(5L, TimeUnit.SECONDS)) {
            throw new TestException("Failed notifying about logged data");
        }
        EventLog actual = (EventLog)logged.getValue();
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)actual.getLevel(), (Object)level);
        Assert.assertEquals((Object)actual.getCategory(), (Object)category);
        Assert.assertEquals((String)actual.getMessage(), (String)"Lorem");
    }
}

