/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.ByteArrayInputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.infinispan.commons.io.LazyByteArrayOutputStream;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.ByteString;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="util.ByteStringTest")
public class ByteStringTest
extends AbstractInfinispanTest {
    public void testEmptyString() throws Exception {
        ByteString byteString = ByteString.fromString((String)"");
        AssertJUnit.assertSame((Object)ByteString.emptyString(), (Object)byteString);
        LazyByteArrayOutputStream outputStream = new LazyByteArrayOutputStream();
        try (ObjectOutputStream output = new ObjectOutputStream((OutputStream)outputStream);){
            ByteString.writeObject((ObjectOutput)output, (ByteString)byteString);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.getRawBuffer());
        try (ObjectInputStream input = new ObjectInputStream(inputStream);){
            ByteString byteString2 = ByteString.readObject((ObjectInput)input);
            AssertJUnit.assertSame((Object)ByteString.emptyString(), (Object)byteString2);
        }
    }

    public void testShortString() throws Exception {
        ByteString byteString = ByteString.fromString((String)"abc");
        LazyByteArrayOutputStream outputStream = new LazyByteArrayOutputStream();
        try (ObjectOutputStream output = new ObjectOutputStream((OutputStream)outputStream);){
            ByteString.writeObject((ObjectOutput)output, (ByteString)byteString);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.getRawBuffer());
        try (ObjectInputStream input = new ObjectInputStream(inputStream);){
            ByteString byteString2 = ByteString.readObject((ObjectInput)input);
            AssertJUnit.assertEquals((Object)byteString, (Object)byteString2);
        }
    }

    public void testLargeString() throws Exception {
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < 128; ++i) {
            sb.append("a");
        }
        ByteString.fromString((String)sb.toString());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testTooLargeString() throws Exception {
        StringBuilder sb = new StringBuilder(256);
        for (int i = 0; i < 256; ++i) {
            sb.append("a");
        }
        ByteString.fromString((String)sb.toString());
    }
}

