/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestException;
import org.infinispan.util.concurrent.ActionSequencer;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="util.ActionSequencerUnitTest")
public class ActionSequencerUnitTest
extends AbstractInfinispanTest {
    private static void assertEmpty(ActionSequencer sequencer) {
        ActionSequencerUnitTest.assertMapSize(sequencer, 0);
        ActionSequencerUnitTest.assertPendingActions(sequencer, 0);
    }

    private static int nextInt() {
        return ThreadLocalRandom.current().nextInt();
    }

    private static String nextStringInt() {
        return Integer.toString(ActionSequencerUnitTest.nextInt());
    }

    private static int getResult(CompletionStage<Integer> cf) {
        return (Integer)CompletionStages.join(cf);
    }

    private static void assertMapSize(ActionSequencer sequencer, int size) {
        AssertJUnit.assertEquals((String)"Wrong ActionSequencer.getMapSize()", (int)size, (int)sequencer.getMapSize());
    }

    private static void assertPendingActions(ActionSequencer sequencer, int size) {
        AssertJUnit.assertEquals((String)"Wrong ActionSequencer.getPendingActions()", (long)size, (long)sequencer.getPendingActions());
    }

    private static void assertActionResult(CompletionStage<Integer> cf, int result) {
        AssertJUnit.assertEquals((String)"Wrong result", (int)result, (int)ActionSequencerUnitTest.getResult(cf));
    }

    private static void assertActionResult(CompletionStage<Integer> cf, String exceptionMessage) {
        Exceptions.expectException(CompletionException.class, TestException.class, (String)exceptionMessage, () -> CompletionStages.join((CompletionStage)cf));
    }

    private static void assertActionState(NonBlockingAction action, CompletionStage<Integer> cf, boolean started, boolean completed) {
        AssertJUnit.assertEquals((String)"Is action started?", (boolean)started, (boolean)action.isStarted());
        AssertJUnit.assertEquals((String)"Is action completed?", (boolean)completed, (boolean)cf.toCompletableFuture().isDone());
    }

    private static void assertActionState(List<NonBlockingAction> actionList, List<CompletionStage<Integer>> cfList, Predicate<Integer> started, Predicate<Integer> completed) {
        for (int i = 0; i < actionList.size(); ++i) {
            ActionSequencerUnitTest.assertActionState(actionList.get(i), cfList.get(i), started.test(i), completed.test(i));
        }
    }

    private static void assertAllCompleted(int[] results, List<CompletionStage<Integer>> cfList, Predicate<Integer> fail) {
        for (int i = 0; i < results.length; ++i) {
            if (fail.test(i)) {
                ActionSequencerUnitTest.assertActionResult(cfList.get(i), Integer.toString(results[i]));
                continue;
            }
            ActionSequencerUnitTest.assertActionResult(cfList.get(i), results[i]);
        }
    }

    @DataProvider(name="default-with-keys")
    public static Object[][] dataProviderWithKeys() {
        return new Object[][]{{KeysSupplier.NO_KEY}, {KeysSupplier.SINGLE_KEY}, {KeysSupplier.MULTIPLE_KEY}};
    }

    @Test(dataProvider="default-with-keys")
    public void testExecution(KeysSupplier keysSupplier) {
        ActionSequencer sequencer = new ActionSequencer((Executor)this.testExecutor(), false, TIME_SERVICE);
        sequencer.setStatisticEnabled(true);
        int retVal = ActionSequencerUnitTest.nextInt();
        Object keys = keysSupplier.get();
        NonBlockingAction action = new NonBlockingAction(retVal);
        CompletionStage cf = keysSupplier.useSingleKeyMethod() ? sequencer.orderOnKey(keys.iterator().next(), (Callable)action) : sequencer.orderOnKeys((Collection)keys, (Callable)action);
        ActionSequencerUnitTest.assertPendingActions(sequencer, keys.isEmpty() ? 0 : 1);
        ActionSequencerUnitTest.assertMapSize(sequencer, keys.size());
        action.awaitUntilStarted();
        ActionSequencerUnitTest.assertActionState(action, cf, true, false);
        action.continueExecution();
        ActionSequencerUnitTest.assertActionResult((CompletionStage<Integer>)cf, retVal);
        ActionSequencerUnitTest.assertEmpty(sequencer);
    }

    public void testNullParameters() {
        ActionSequencer sequencer = new ActionSequencer((Executor)this.testExecutor(), false, TIME_SERVICE);
        sequencer.setStatisticEnabled(true);
        NonBlockingAction action = new NonBlockingAction(0);
        Exceptions.expectException(NullPointerException.class, () -> sequencer.orderOnKeys(Arrays.asList("k1", "k2"), null));
        Exceptions.expectException(NullPointerException.class, () -> sequencer.orderOnKeys(null, (Callable)action));
        Exceptions.expectException(NullPointerException.class, () -> sequencer.orderOnKey((Object)"k0", null));
        Exceptions.expectException(NullPointerException.class, () -> sequencer.orderOnKey(null, (Callable)action));
        ActionSequencerUnitTest.assertEmpty(sequencer);
    }

    @Test(dataProvider="default-with-keys")
    public void testExceptionExecution(KeysSupplier keysSupplier) {
        ActionSequencer sequencer = new ActionSequencer((Executor)this.testExecutor(), false, TIME_SERVICE);
        sequencer.setStatisticEnabled(true);
        Object keys = keysSupplier.get();
        String msg = ActionSequencerUnitTest.nextStringInt();
        NonBlockingAction action = new NonBlockingAction(new TestException(msg));
        CompletionStage cf = keysSupplier.useSingleKeyMethod() ? sequencer.orderOnKey(keys.iterator().next(), (Callable)action) : sequencer.orderOnKeys((Collection)keys, (Callable)action);
        ActionSequencerUnitTest.assertPendingActions(sequencer, keys.isEmpty() ? 0 : 1);
        ActionSequencerUnitTest.assertMapSize(sequencer, keys.size());
        action.awaitUntilStarted();
        ActionSequencerUnitTest.assertActionState(action, cf, true, false);
        action.continueExecution();
        ActionSequencerUnitTest.assertActionResult((CompletionStage<Integer>)cf, msg);
        ActionSequencerUnitTest.assertEmpty(sequencer);
    }

    public void testSingleKeyOrder() {
        ActionSequencer sequencer = new ActionSequencer((Executor)this.testExecutor(), false, TIME_SERVICE);
        sequencer.setStatisticEnabled(true);
        Set<Object> keys = Collections.singleton("k");
        int[] results = new int[3];
        ArrayList<NonBlockingAction> actionList = new ArrayList<NonBlockingAction>(results.length);
        ArrayList<CompletionStage<Integer>> cfList = new ArrayList<CompletionStage<Integer>>(results.length);
        for (int i2 = 0; i2 < results.length; ++i2) {
            this.createAndOrderAction(sequencer, results, actionList, cfList, keys, i2, i2 == 1);
        }
        ActionSequencerUnitTest.assertPendingActions(sequencer, results.length);
        ActionSequencerUnitTest.assertMapSize(sequencer, keys.size());
        ((NonBlockingAction)actionList.get(0)).awaitUntilStarted();
        ActionSequencerUnitTest.assertActionState(actionList, cfList, i -> i == 0, i -> false);
        ((NonBlockingAction)actionList.get(0)).continueExecution();
        ((NonBlockingAction)actionList.get(1)).awaitUntilStarted();
        ActionSequencerUnitTest.assertActionResult((CompletionStage<Integer>)((CompletionStage)cfList.get(0)), results[0]);
        ActionSequencerUnitTest.assertActionState(actionList, cfList, i -> i <= 1, i -> i == 0);
        ((NonBlockingAction)actionList.get(2)).continueExecution();
        ActionSequencerUnitTest.assertActionState(actionList, cfList, i -> i <= 1, i -> i == 0);
        ((NonBlockingAction)actionList.get(1)).continueExecution();
        ((NonBlockingAction)actionList.get(2)).awaitUntilStarted();
        ActionSequencerUnitTest.assertAllCompleted(results, cfList, i -> i == 1);
        ActionSequencerUnitTest.assertEmpty(sequencer);
    }

    public void testDistinctKeysWithSameKey() {
        this.doDistinctKeysTest(Arrays.asList("k1", "k1", "k1"), 1);
    }

    public void testDistinctKeys() {
        this.doDistinctKeysTest(Arrays.asList("k1", "k2", "k2"), 2);
    }

    public void testMultiKeyOrder() {
        ActionSequencer sequencer = new ActionSequencer((Executor)this.testExecutor(), false, TIME_SERVICE);
        sequencer.setStatisticEnabled(true);
        int[] results = new int[4];
        ArrayList<NonBlockingAction> actionList = new ArrayList<NonBlockingAction>(results.length);
        ArrayList<CompletionStage<Integer>> cfList = new ArrayList<CompletionStage<Integer>>(results.length);
        this.createAndOrderAction(sequencer, results, actionList, cfList, Arrays.asList("k1", "k2", "k3"), 0, false);
        this.createAndOrderAction(sequencer, results, actionList, cfList, Collections.singleton("k1"), 1, true);
        this.createAndOrderAction(sequencer, results, actionList, cfList, Arrays.asList("k3", "k4"), 2, false);
        this.createAndOrderAction(sequencer, results, actionList, cfList, Arrays.asList("k1", "k4"), 3, false);
        ActionSequencerUnitTest.assertPendingActions(sequencer, results.length);
        ActionSequencerUnitTest.assertMapSize(sequencer, 4);
        ((NonBlockingAction)actionList.get(0)).awaitUntilStarted();
        ActionSequencerUnitTest.assertActionState(actionList, cfList, i -> i == 0, i -> false);
        ((NonBlockingAction)actionList.get(0)).continueExecution();
        ((NonBlockingAction)actionList.get(1)).awaitUntilStarted();
        ((NonBlockingAction)actionList.get(2)).awaitUntilStarted();
        ActionSequencerUnitTest.assertActionResult((CompletionStage<Integer>)((CompletionStage)cfList.get(0)), results[0]);
        ActionSequencerUnitTest.assertActionState(actionList, cfList, i -> i <= 2, i -> i == 0);
        ((NonBlockingAction)actionList.get(1)).continueExecution();
        ActionSequencerUnitTest.assertActionResult((CompletionStage<Integer>)((CompletionStage)cfList.get(1)), Integer.toString(results[1]));
        ActionSequencerUnitTest.assertActionState(actionList, cfList, i -> i <= 2, i -> i <= 1);
        ((NonBlockingAction)actionList.get(2)).continueExecution();
        ((NonBlockingAction)actionList.get(3)).awaitUntilStarted();
        ActionSequencerUnitTest.assertActionResult((CompletionStage<Integer>)((CompletionStage)cfList.get(2)), results[2]);
        ActionSequencerUnitTest.assertActionState(actionList, cfList, i -> i <= 3, i -> i <= 2);
        ((NonBlockingAction)actionList.get(3)).continueExecution();
        ActionSequencerUnitTest.assertActionResult((CompletionStage<Integer>)((CompletionStage)cfList.get(3)), results[3]);
        ActionSequencerUnitTest.assertEmpty(sequencer);
    }

    private void createAndOrderAction(ActionSequencer sequencer, int[] results, List<NonBlockingAction> actionList, List<CompletionStage<Integer>> cfList, Collection<Object> keys, int index, boolean fail) {
        results[index] = ActionSequencerUnitTest.nextInt();
        NonBlockingAction action = fail ? new NonBlockingAction(new TestException(Integer.toString(results[index]))) : new NonBlockingAction(results[index]);
        actionList.add(action);
        cfList.add(sequencer.orderOnKeys(keys, (Callable)action));
    }

    private void doDistinctKeysTest(Collection<Object> keys, int distinctKeys) {
        ActionSequencer sequencer = new ActionSequencer((Executor)this.testExecutor(), false, TIME_SERVICE);
        sequencer.setStatisticEnabled(true);
        int retVal = ThreadLocalRandom.current().nextInt();
        NonBlockingAction action = new NonBlockingAction(retVal);
        CompletionStage cf = sequencer.orderOnKeys(keys, (Callable)action);
        ActionSequencerUnitTest.assertPendingActions(sequencer, 1);
        ActionSequencerUnitTest.assertMapSize(sequencer, distinctKeys);
        action.continueExecution();
        ActionSequencerUnitTest.assertActionResult((CompletionStage<Integer>)cf, retVal);
        ActionSequencerUnitTest.assertEmpty(sequencer);
    }

    private static class NonBlockingAction
    implements Callable<CompletableFuture<Integer>> {
        private final Integer retVal;
        private final Exception throwable;
        private final CompletableFuture<Integer> cf;
        private final CountDownLatch beforeLatch = new CountDownLatch(1);

        private NonBlockingAction(int retVal) {
            this.retVal = retVal;
            this.throwable = null;
            this.cf = new CompletableFuture();
        }

        private NonBlockingAction(Exception throwable) {
            this.retVal = null;
            this.throwable = throwable;
            this.cf = new CompletableFuture();
        }

        @Override
        public CompletableFuture<Integer> call() throws Exception {
            this.beforeLatch.countDown();
            return this.cf;
        }

        void continueExecution() {
            if (this.throwable != null) {
                this.cf.completeExceptionally(this.throwable);
            } else {
                this.cf.complete(this.retVal);
            }
        }

        boolean isStarted() {
            return this.beforeLatch.getCount() == 0L;
        }

        void awaitUntilStarted() {
            try {
                if (this.beforeLatch.await(10L, TimeUnit.SECONDS)) {
                    return;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            AssertJUnit.fail((String)("Action never started! action=" + String.valueOf(this)));
        }
    }

    private static enum KeysSupplier implements Supplier<Collection<Object>>
    {
        NO_KEY(Collections.emptyList()),
        SINGLE_KEY(Collections.singleton("k1")),
        SINGLE_KEY_WITH_SINGLE_METHOD(Collections.singleton("k1"), true),
        MULTIPLE_KEY(Arrays.asList("k2", "k3", "k4"));

        final Collection<Object> keys;
        final boolean useSingleKeyMethod;

        private KeysSupplier(Collection<Object> keys) {
            this(keys, false);
        }

        private KeysSupplier(Collection<Object> keys, boolean useSingleKeyMethod) {
            this.keys = keys;
            this.useSingleKeyMethod = useSingleKeyMethod;
        }

        @Override
        public Collection<Object> get() {
            return this.keys;
        }

        boolean useSingleKeyMethod() {
            return this.useSingleKeyMethod;
        }
    }
}

