/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.HashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.infinispan.util.mocks.ControlledCommandFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(groups={"functional"}, testName="tx.TxCleanupServiceTest")
public class TxCleanupServiceTest
extends MultipleCacheManagersTest {
    private static final int TX_COUNT = 1;
    private ConfigurationBuilder dcc;
    private ControlledConsistentHashFactory consistentHashFactory;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.dcc = TxCleanupServiceTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        this.dcc.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        this.consistentHashFactory = new ControlledConsistentHashFactory.Default(1, new int[0]);
        this.dcc.clustering().hash().numOwners(1).numSegments(1).consistentHashFactory((ConsistentHashFactory)this.consistentHashFactory);
        this.createCluster(TestDataSCI.INSTANCE, this.dcc, 2);
        this.waitForClusterToForm();
    }

    public void testTransactionStateNotLost() throws Throwable {
        ControlledCommandFactory ccf = ControlledCommandFactory.registerControlledCommandFactory(this.cache(1), VersionedCommitCommand.class);
        ccf.gate.close();
        HashMap keys2Tx = new HashMap(1);
        int viewId = this.advancedCache(0).getRpcManager().getTransport().getViewId();
        log.tracef("ViewId before %s", viewId);
        Future<Object> future = this.fork(() -> {
            for (int i = 0; i < 1; ++i) {
                Object k = this.getKeyForCache(1);
                this.tm(0).begin();
                this.cache(0).put(k, k);
                EmbeddedTransaction transaction = ((EmbeddedTransactionManager)this.tm(0)).getTransaction();
                keys2Tx.put(k, transaction);
                this.tm(0).commit();
            }
            return null;
        });
        this.eventuallyEquals(1, ccf.blockTypeCommandsReceived::get);
        log.tracef("Viewid middle %s", viewId);
        this.consistentHashFactory.setOwnerIndexes(2, new int[0]);
        this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE, this.dcc);
        this.waitForClusterToForm();
        viewId = this.advancedCache(0).getRpcManager().getTransport().getViewId();
        log.tracef("Viewid after before %s", viewId);
        HashMap migratedTx = new HashMap(1);
        for (Object key : keys2Tx.keySet()) {
            if (!this.keyMapsToNode2(key)) continue;
            migratedTx.put(key, (EmbeddedTransaction)keys2Tx.get(key));
        }
        log.tracef("Number of migrated tx is %s", migratedTx.size());
        AssertJUnit.assertEquals((int)1, (int)migratedTx.size());
        this.eventuallyEquals(migratedTx.size(), () -> TestingUtil.getTransactionTable(this.cache(2)).getRemoteTxCount());
        log.trace((Object)"Releasing the gate");
        ccf.gate.open();
        future.get(10L, TimeUnit.SECONDS);
        this.eventuallyEquals(0, () -> TestingUtil.getTransactionTable(this.cache(2)).getRemoteTxCount());
        TxCleanupServiceTest.eventually(() -> {
            boolean allZero = true;
            for (int i = 0; i < 3; ++i) {
                TransactionTable tt = TestingUtil.getTransactionTable(this.cache(i));
                int local = tt.getLocalTxCount();
                int remote = tt.getRemoteTxCount();
                log.tracef("For cache %d, localTxCount=%s, remoteTxCount=%s", i, local, remote);
                log.tracef(String.format("For cache %s , localTxCount=%s, remoteTxCount=%s", i, local, remote), new Object[0]);
                allZero = allZero && local == 0;
                allZero = allZero && remote == 0;
            }
            return allZero;
        });
        for (Object key : keys2Tx.keySet()) {
            this.assertNotLocked(key);
            AssertJUnit.assertEquals(key, (Object)this.cache(0).get(key));
        }
    }

    private boolean keyMapsToNode2(Object key) {
        Address owner = this.owner(key);
        return owner.equals((Object)this.address(2));
    }

    private Address owner(Object key) {
        return this.advancedCache(0).getDistributionManager().getCacheTopology().getDistribution(key).primary();
    }
}

