/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import io.reactivex.rxjava3.core.Flowable;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.commands.GlobalRpcCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.reactive.publisher.impl.Notifications;
import org.infinispan.reactive.publisher.impl.SegmentAwarePublisherSupplier;
import org.infinispan.reactive.publisher.impl.SegmentPublisherSupplier;
import org.infinispan.remoting.inboundhandler.AbstractDelegatingHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.xsite.commands.remote.XSiteRequest;
import org.mockito.AdditionalAnswers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.Stubber;
import org.reactivestreams.Publisher;

public class Mocks {
    public static final String BEFORE_INVOCATION = "before_invocation";
    public static final String BEFORE_RELEASE = "before_release";
    public static final String AFTER_INVOCATION = "after_invocation";
    public static final String AFTER_RELEASE = "after_release";
    public static final Answer<Void> EXECUTOR_RUN_ANSWER = invocation -> {
        Runnable runnable = (Runnable)invocation.getArgument(0);
        runnable.run();
        return null;
    };

    private Mocks() {
    }

    public static Answer<Void> justRunExecutorAnswer() {
        return EXECUTOR_RUN_ANSWER;
    }

    public static Answer<Void> runWithExecutorAnswer(Executor executor) {
        return invocation -> {
            Runnable runnable = (Runnable)invocation.getArgument(0);
            executor.execute(runnable);
            return null;
        };
    }

    public static <T, R> R invokeAndReturnMock(InvocationOnMock i, T target) throws IllegalAccessException, InvocationTargetException {
        Object returnValue = i.getMethod().invoke(target, i.getArguments());
        return (R)(returnValue == target ? i.getMock() : returnValue);
    }

    public static <T> T callRealMethod(InvocationOnMock invocation) {
        try {
            return (T)invocation.callRealMethod();
        }
        catch (Throwable throwable) {
            throw CompletableFutures.asCompletionException((Throwable)throwable);
        }
    }

    public static <T> T callAnotherAnswer(Answer<?> answer, InvocationOnMock invocation) {
        try {
            return (T)answer.answer(invocation);
        }
        catch (Throwable throwable) {
            throw CompletableFutures.asCompletionException((Throwable)throwable);
        }
    }

    public static <Mock> Mock blockingMock(CheckPoint checkPoint, Class<? extends Mock> componentClass, Cache<?, ?> cache, BiConsumer<? super Stubber, ? super Mock> mockStubConsumer, Class<?> ... extraInterfaces) {
        return (Mock)Mocks.interceptComponent(componentClass, cache, (realObject, mock) -> mockStubConsumer.accept((Stubber)Mockito.doAnswer(Mocks.blockingAnswer(AdditionalAnswers.delegatesTo((Object)realObject), checkPoint)), (Object)mock), extraInterfaces);
    }

    public static <Mock, OwnerClass> Mock blockingFieldMock(CheckPoint checkPoint, Class<? extends Mock> mockClass, OwnerClass obj, Class<? super OwnerClass> objClass, String mockFieldName, BiConsumer<? super Stubber, ? super Mock> mockStubConsumer, Class<?> ... extraInterfaces) {
        Object realObject = TestingUtil.extractField(obj, mockFieldName);
        Answer forwardingAnswer = AdditionalAnswers.delegatesTo(realObject);
        MockSettings mockSettings = Mockito.withSettings().defaultAnswer(forwardingAnswer);
        if (extraInterfaces != null && extraInterfaces.length > 0) {
            mockSettings.extraInterfaces((Class[])extraInterfaces);
        }
        Object mock = Mockito.mock(mockClass, (MockSettings)mockSettings);
        mockStubConsumer.accept((Stubber)Mockito.doAnswer(Mocks.blockingAnswer(forwardingAnswer, checkPoint)), mock);
        TestingUtil.replaceField(mock, mockFieldName, obj, objClass);
        return (Mock)realObject;
    }

    public static <Mock> Mock interceptComponent(Class<? extends Mock> componentClass, Cache<?, ?> cache, BiConsumer<? super Mock, ? super Mock> methodInterceptor, Class<?> ... extraInterfaces) {
        Mock realObject = TestingUtil.extractComponent(cache, componentClass);
        Answer forwardingAnswer = AdditionalAnswers.delegatesTo(realObject);
        MockSettings mockSettings = Mockito.withSettings().defaultAnswer(forwardingAnswer);
        if (extraInterfaces != null && extraInterfaces.length > 0) {
            mockSettings.extraInterfaces((Class[])extraInterfaces);
        }
        Object mock = Mockito.mock(componentClass, (MockSettings)mockSettings);
        methodInterceptor.accept(realObject, mock);
        TestingUtil.replaceComponent(cache, componentClass, mock, true);
        return realObject;
    }

    public static <T> Answer<T> blockingAnswer(Answer<T> answer, CheckPoint checkPoint) {
        return invocation -> {
            checkPoint.trigger(BEFORE_INVOCATION);
            checkPoint.awaitStrict(BEFORE_RELEASE, 20L, TimeUnit.SECONDS);
            try {
                Object object = answer.answer(invocation);
                return object;
            }
            finally {
                checkPoint.trigger(AFTER_INVOCATION);
                checkPoint.awaitStrict(AFTER_RELEASE, 20L, TimeUnit.SECONDS);
            }
        };
    }

    public static <V> Callable<CompletableFuture<V>> blockingCompletableFuture(Callable<CompletableFuture<V>> completableFutureCallable, CheckPoint checkPoint, Executor executor) {
        return () -> {
            checkPoint.trigger(BEFORE_INVOCATION);
            try {
                checkPoint.awaitStrict(BEFORE_RELEASE, 20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            CompletableFuture completableFuture = (CompletableFuture)completableFutureCallable.call();
            return completableFuture.thenCompose(v -> {
                checkPoint.trigger(AFTER_INVOCATION);
                return checkPoint.future(AFTER_RELEASE, 20L, TimeUnit.SECONDS, executor).thenApply(ignore -> v);
            });
        };
    }

    public static <E> Publisher<E> blockingPublisher(Publisher<E> publisher, CheckPoint checkPoint) {
        return Flowable.fromPublisher(publisher).doOnSubscribe(s -> {
            checkPoint.trigger(BEFORE_INVOCATION);
            checkPoint.awaitStrict(BEFORE_RELEASE, 20L, TimeUnit.SECONDS);
        }).doOnComplete(() -> {
            checkPoint.trigger(AFTER_INVOCATION);
            checkPoint.awaitStrict(AFTER_RELEASE, 20L, TimeUnit.SECONDS);
        });
    }

    public static <E> SegmentPublisherSupplier<E> blockingPublisher(final SegmentPublisherSupplier<E> publisher, final CheckPoint checkPoint) {
        return new SegmentPublisherSupplier<E>(){

            public Publisher<SegmentPublisherSupplier.Notification<E>> publisherWithSegments() {
                return Flowable.fromPublisher((Publisher)publisher.publisherWithSegments()).doOnSubscribe(subscription -> {
                    checkPoint.trigger(Mocks.BEFORE_INVOCATION);
                    checkPoint.awaitStrict(Mocks.BEFORE_RELEASE, 20L, TimeUnit.SECONDS);
                }).doOnComplete(() -> {
                    checkPoint.trigger(Mocks.AFTER_INVOCATION);
                    checkPoint.awaitStrict(Mocks.AFTER_RELEASE, 20L, TimeUnit.SECONDS);
                });
            }

            public Publisher<E> publisherWithoutSegments() {
                return Flowable.fromPublisher((Publisher)publisher.publisherWithoutSegments()).doOnSubscribe(subscription -> {
                    checkPoint.trigger(Mocks.BEFORE_INVOCATION);
                    checkPoint.awaitStrict(Mocks.BEFORE_RELEASE, 20L, TimeUnit.SECONDS);
                }).doOnComplete(() -> {
                    checkPoint.trigger(Mocks.AFTER_INVOCATION);
                    checkPoint.awaitStrict(Mocks.AFTER_RELEASE, 20L, TimeUnit.SECONDS);
                });
            }
        };
    }

    public static <E> SegmentAwarePublisherSupplier<E> blockingPublisherAware(final SegmentAwarePublisherSupplier<E> publisher, final CheckPoint checkPoint) {
        return new SegmentAwarePublisherSupplier<E>(){

            public Publisher<SegmentPublisherSupplier.Notification<E>> publisherWithSegments() {
                return Flowable.fromPublisher((Publisher)publisher.publisherWithSegments()).doOnSubscribe(s -> {
                    checkPoint.trigger(Mocks.BEFORE_INVOCATION);
                    checkPoint.awaitStrict(Mocks.BEFORE_RELEASE, 20L, TimeUnit.SECONDS);
                }).doOnComplete(() -> {
                    checkPoint.trigger(Mocks.AFTER_INVOCATION);
                    checkPoint.awaitStrict(Mocks.AFTER_RELEASE, 20L, TimeUnit.SECONDS);
                });
            }

            public Publisher<E> publisherWithoutSegments() {
                return Flowable.fromPublisher((Publisher)publisher.publisherWithoutSegments()).doOnSubscribe(subscription -> {
                    checkPoint.trigger(Mocks.BEFORE_INVOCATION);
                    checkPoint.awaitStrict(Mocks.BEFORE_RELEASE, 20L, TimeUnit.SECONDS);
                }).doOnComplete(() -> {
                    checkPoint.trigger(Mocks.AFTER_INVOCATION);
                    checkPoint.awaitStrict(Mocks.AFTER_RELEASE, 20L, TimeUnit.SECONDS);
                });
            }

            public Publisher<SegmentAwarePublisherSupplier.NotificationWithLost<E>> publisherWithLostSegments(boolean reuseNotifications) {
                return Flowable.fromPublisher((Publisher)publisher.publisherWithLostSegments(reuseNotifications)).doOnSubscribe(subscription -> {
                    checkPoint.trigger(Mocks.BEFORE_INVOCATION);
                    checkPoint.awaitStrict(Mocks.BEFORE_RELEASE, 20L, TimeUnit.SECONDS);
                }).doOnComplete(() -> {
                    checkPoint.trigger(Mocks.AFTER_INVOCATION);
                    checkPoint.awaitStrict(Mocks.AFTER_RELEASE, 20L, TimeUnit.SECONDS);
                });
            }
        };
    }

    public static <E> Publisher<E> blockingPublisherOnElement(Publisher<E> publisher, CheckPoint checkPoint, Predicate<? super E> predicate) {
        return Flowable.defer(() -> {
            ByRef.Boolean byRef = new ByRef.Boolean(false);
            return Flowable.fromPublisher((Publisher)publisher).doOnNext(e -> {
                if (byRef.get()) {
                    byRef.set(false);
                    checkPoint.trigger(AFTER_INVOCATION);
                    checkPoint.awaitStrict(AFTER_RELEASE, 20L, TimeUnit.SECONDS);
                }
                if (predicate.test((Object)e)) {
                    byRef.set(true);
                    checkPoint.trigger(BEFORE_INVOCATION);
                    checkPoint.awaitStrict(BEFORE_RELEASE, 20L, TimeUnit.SECONDS);
                }
            }).doFinally(() -> {
                if (byRef.get()) {
                    checkPoint.trigger(AFTER_INVOCATION);
                    checkPoint.awaitStrict(AFTER_RELEASE, 20L, TimeUnit.SECONDS);
                }
            });
        });
    }

    public static <E> SegmentPublisherSupplier<E> blockingSegmentPublisherOnElement(final SegmentPublisherSupplier<E> publisher, final CheckPoint checkPoint, final Predicate<? super SegmentPublisherSupplier.Notification<E>> predicate) {
        return new SegmentPublisherSupplier<E>(){

            public Publisher<SegmentPublisherSupplier.Notification<E>> publisherWithSegments() {
                ByRef.Boolean byRef = new ByRef.Boolean(false);
                return Flowable.fromPublisher((Publisher)publisher.publisherWithSegments()).doOnNext(e -> {
                    if (byRef.get()) {
                        byRef.set(false);
                        checkPoint.trigger(Mocks.AFTER_INVOCATION);
                        checkPoint.awaitStrict(Mocks.AFTER_RELEASE, 20L, TimeUnit.SECONDS);
                    }
                    if (predicate.test(e)) {
                        byRef.set(true);
                        checkPoint.trigger(Mocks.BEFORE_INVOCATION);
                        checkPoint.awaitStrict(Mocks.BEFORE_RELEASE, 20L, TimeUnit.SECONDS);
                    }
                }).doFinally(() -> {
                    if (byRef.get()) {
                        checkPoint.trigger(Mocks.AFTER_INVOCATION);
                        checkPoint.awaitStrict(Mocks.AFTER_RELEASE, 20L, TimeUnit.SECONDS);
                    }
                });
            }

            public Publisher<E> publisherWithoutSegments() {
                return Mocks.blockingPublisherOnElement((Publisher)publisher, checkPoint, value -> predicate.test(Notifications.value((Object)value, (int)-1)));
            }
        };
    }

    public static AbstractDelegatingHandler blockInboundCacheRpcCommand(Cache<?, ?> cache, final CheckPoint checkPoint, final Predicate<? super CacheRpcCommand> predicate) {
        final Executor executor = TestingUtil.extractGlobalComponent((CacheContainer)cache.getCacheManager(), ExecutorService.class, "org.infinispan.executors.non-blocking");
        return TestingUtil.wrapInboundInvocationHandler(cache, handler -> new AbstractDelegatingHandler((PerCacheInboundInvocationHandler)handler){

            public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
                if (!predicate.test(command)) {
                    this.delegate.handle(command, reply, order);
                    return;
                }
                checkPoint.trigger(Mocks.BEFORE_INVOCATION);
                ((CompletableFuture)checkPoint.future(Mocks.BEFORE_RELEASE, 20L, TimeUnit.SECONDS, executor).thenRun(() -> this.delegate.handle(command, reply, order))).thenCompose(ignored -> {
                    checkPoint.trigger(Mocks.AFTER_INVOCATION);
                    return checkPoint.future(Mocks.AFTER_RELEASE, 20L, TimeUnit.SECONDS, executor);
                });
            }
        });
    }

    public static void blockInboundGlobalCommand(EmbeddedCacheManager ecm, CheckPoint checkPoint, final Predicate<? super ReplicableCommand> predicate) {
        Executor executor = TestingUtil.extractGlobalComponent((CacheContainer)ecm, ExecutorService.class, "org.infinispan.executors.non-blocking");
        TestingUtil.wrapGlobalComponent((CacheContainer)ecm, InboundInvocationHandler.class, handler -> new InboundInvocationHandler(){
            final /* synthetic */ InboundInvocationHandler val$handler;
            final /* synthetic */ CheckPoint val$checkPoint;
            final /* synthetic */ Executor val$executor;
            {
                this.val$handler = inboundInvocationHandler;
                this.val$checkPoint = checkPoint;
                this.val$executor = executor;
            }

            public void handleFromCluster(Address origin, ReplicableCommand command, Reply reply, DeliverOrder order) {
                if (!predicate.test(command)) {
                    this.val$handler.handleFromCluster(origin, command, reply, order);
                    return;
                }
                this.val$checkPoint.trigger(Mocks.BEFORE_INVOCATION);
                ((CompletableFuture)this.val$checkPoint.future(Mocks.BEFORE_RELEASE, 20L, TimeUnit.SECONDS, this.val$executor).thenRun(() -> this.val$handler.handleFromCluster(origin, command, reply, order))).thenCompose(ignore -> {
                    this.val$checkPoint.trigger(Mocks.AFTER_INVOCATION);
                    return this.val$checkPoint.future(Mocks.AFTER_RELEASE, 20L, TimeUnit.SECONDS, this.val$executor);
                });
            }

            public void handleFromRemoteSite(String origin, XSiteRequest<?> command, Reply reply, DeliverOrder order) {
                throw new IllegalArgumentException("Not expecting cross site requests");
            }
        }, true);
    }

    public static CheckPoint blockInboundGlobalCommandExecution(EmbeddedCacheManager ecm, final Predicate<? super ReplicableCommand> predicate) {
        CheckPoint checkPoint = new CheckPoint();
        Executor executor = TestingUtil.extractGlobalComponent((CacheContainer)ecm, ExecutorService.class, "org.infinispan.executors.non-blocking");
        TestingUtil.wrapGlobalComponent((CacheContainer)ecm, InboundInvocationHandler.class, handler -> new InboundInvocationHandler(){
            final /* synthetic */ InboundInvocationHandler val$handler;
            final /* synthetic */ CheckPoint val$checkPoint;
            final /* synthetic */ Executor val$executor;
            {
                this.val$handler = inboundInvocationHandler;
                this.val$checkPoint = checkPoint;
                this.val$executor = executor;
            }

            public void handleFromCluster(final Address origin, final ReplicableCommand command, Reply reply, final DeliverOrder order) {
                if (!predicate.test(command)) {
                    this.val$handler.handleFromCluster(origin, command, reply, order);
                    return;
                }
                GlobalRpcCommand wrapped = new GlobalRpcCommand(){
                    final /* synthetic */ 6 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public byte getCommandId() {
                        return command.getCommandId();
                    }

                    public boolean isReturnValueExpected() {
                        return command.isReturnValueExpected();
                    }

                    public CompletionStage<?> invokeAsync(GlobalComponentRegistry globalComponentRegistry) {
                        val$checkPoint.trigger(Mocks.BEFORE_INVOCATION);
                        return val$checkPoint.future(Mocks.BEFORE_RELEASE, 20L, TimeUnit.SECONDS, val$executor).thenCompose(ignore -> {
                            CompletableFuture cf = new CompletableFuture();
                            Reply completableReply = response -> {
                                val$checkPoint.trigger(Mocks.AFTER_INVOCATION);
                                val$checkPoint.future(Mocks.AFTER_RELEASE, 20L, TimeUnit.SECONDS, val$executor).thenRun(() -> cf.complete(response));
                            };
                            val$handler.handleFromCluster(origin, command, completableReply, order);
                            return cf;
                        });
                    }
                };
                this.val$handler.handleFromCluster(origin, (ReplicableCommand)wrapped, reply, order);
            }

            public void handleFromRemoteSite(String origin, XSiteRequest<?> command, Reply reply, DeliverOrder order) {
                throw new IllegalArgumentException("Not expecting cross site requests");
            }
        }, true);
        return checkPoint;
    }

    public static <C> C replaceComponentWithSpy(Cache<?, ?> cache, Class<C> componentClass) {
        C component = TestingUtil.extractComponent(cache, componentClass);
        if (MockUtil.isMock(component)) {
            MockUtil.resetMock(component);
            return component;
        }
        Object spiedComponent = Mockito.spy(component);
        TestingUtil.replaceComponent(cache, componentClass, spiedComponent, true);
        return (C)spiedComponent;
    }

    public static <C> C replaceFieldWithSpy(Object parentObject, String fieldName, Class<? extends C> fieldClass) {
        ByRef ref = new ByRef(null);
        TestingUtil.replaceField(parentObject, fieldName, c -> {
            Object mock;
            Object fieldObject = TestingUtil.extractField(parentObject, fieldName);
            if (MockUtil.isMock(fieldObject)) {
                MockUtil.resetMock(fieldObject);
                mock = fieldObject;
            } else {
                mock = Mockito.spy(fieldObject);
            }
            ref.set(mock);
            return mock;
        });
        return (C)ref.get();
    }
}

