/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.CacheStream;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.HashConfigurationBuilder;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.distribution.MagicKey;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.filter.Converter;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.StreamSerializationContextImpl;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.BaseControlledConsistentHashFactory;
import org.infinispan.util.function.SerializableSupplier;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stream.BaseSetupStreamIteratorTest")
public abstract class BaseSetupStreamIteratorTest
extends MultipleCacheManagersTest {
    public static final int NUM_NODES = 3;
    protected final String CACHE_NAME = "testCache";
    protected ConfigurationBuilder builderUsed;
    protected SerializationContextInitializer sci;

    public BaseSetupStreamIteratorTest(boolean tx, CacheMode mode) {
        this.transactional = tx;
        this.cacheMode = mode;
    }

    protected void enhanceConfiguration(ConfigurationBuilder builder) {
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.builderUsed = new ConfigurationBuilder();
        this.sci = new StreamSerializationContextImpl();
        HashConfigurationBuilder hashConfiguration = this.builderUsed.clustering().cacheMode(this.cacheMode).hash().numSegments(3);
        if (!this.cacheMode.isReplicated()) {
            TestDefaultConsistentHashFactory chf = new TestDefaultConsistentHashFactory();
            hashConfiguration.consistentHashFactory((ConsistentHashFactory)chf);
        }
        if (this.transactional.booleanValue()) {
            this.builderUsed.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        }
        if (this.cacheMode.isClustered()) {
            this.builderUsed.clustering().stateTransfer().chunkSize(5);
            this.enhanceConfiguration(this.builderUsed);
            this.createClusteredCaches(3, "testCache", this.sci, this.builderUsed, new TransportFlags().withFD(true));
        } else {
            this.enhanceConfiguration(this.builderUsed);
            EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(this.sci, this.builderUsed);
            this.cacheManagers.add(cm);
            cm.defineConfiguration("testCache", this.builderUsed.build());
        }
    }

    protected static <K, V> Map<K, V> mapFromIterator(Iterator<? extends Map.Entry<K, V>> iterator) {
        HashMap<K, V> map = new HashMap<K, V>();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    protected static <K, V> Map<K, V> mapFromStream(CacheStream<CacheEntry<K, V>> stream) {
        return (Map)stream.collect((SerializableSupplier & Serializable)() -> Collectors.toMap(CacheEntry::getKey, CacheEntry::getValue));
    }

    protected Map<Integer, Set<Map.Entry<Object, String>>> generateEntriesPerSegment(KeyPartitioner keyPartitioner, Iterable<Map.Entry<Object, String>> entries) {
        HashMap<Integer, Set<Map.Entry<Object, String>>> returnMap = new HashMap<Integer, Set<Map.Entry<Object, String>>>();
        for (Map.Entry<Object, String> value : entries) {
            int segment = keyPartitioner.getSegment(value.getKey());
            Set set = returnMap.computeIfAbsent(segment, k -> new LinkedHashSet());
            set.add(new ImmortalCacheEntry(value.getKey(), (Object)value.getValue()));
        }
        return returnMap;
    }

    public static class TestDefaultConsistentHashFactory
    extends BaseControlledConsistentHashFactory<DefaultConsistentHash> {
        TestDefaultConsistentHashFactory() {
            super(new BaseControlledConsistentHashFactory.DefaultTrait(), 3);
        }

        @Override
        protected int[][] assignOwners(int numSegments, List<Address> members) {
            switch (members.size()) {
                case 1: {
                    return new int[][]{{0}, {0}, {0}};
                }
                case 2: {
                    return new int[][]{{0, 0}, {0, 1}, {0, 1}};
                }
            }
            return new int[][]{{0, 1}, {1, 2}, {2, 1}};
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={StringTruncator.class, TestDefaultConsistentHashFactory.class, MagicKey.class}, schemaFileName="core.stream.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.core.stream", service=false)
    static interface StreamSerializationContext
    extends SerializationContextInitializer {
    }

    @ProtoName(value="BaseSetupStreamStringTrunctator")
    public static class StringTruncator
    implements Converter<Object, String, String> {
        @ProtoField(number=1, defaultValue="0")
        final int beginning;
        @ProtoField(number=2, defaultValue="0")
        final int length;

        @ProtoFactory
        StringTruncator(int beginning, int length) {
            this.beginning = beginning;
            this.length = length;
        }

        public String convert(Object key, String value, Metadata metadata) {
            if (value != null && value.length() > this.beginning + this.length) {
                return value.substring(this.beginning, this.beginning + this.length);
            }
            throw new IllegalStateException("String should be longer than truncation size!  Possible double conversion performed!");
        }
    }
}

