/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import jakarta.transaction.TransactionManager;
import java.util.Collection;
import java.util.HashMap;
import org.infinispan.Cache;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.SyncPessimisticLockingTest")
@InCacheMode(value={CacheMode.DIST_SYNC, CacheMode.REPL_SYNC})
public class SyncPessimisticLockingTest
extends MultipleCacheManagersTest {
    private String k = "key";
    private String v = "value";

    public SyncPessimisticLockingTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = SyncPessimisticLockingTest.getDefaultClusteredCacheConfig(this.cacheMode, true);
        cfg.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).lockingMode(LockingMode.PESSIMISTIC).locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
        this.createClusteredCaches(2, "testcache", TestDataSCI.INSTANCE, cfg);
    }

    public void testBasicOperation() throws Exception {
        this.testBasicOperationHelper(false);
        this.testBasicOperationHelper(true);
    }

    public void testLocksReleasedWithNoMods() throws Exception {
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        Cache cache1 = this.cache(0, "testcache");
        Cache cache2 = this.cache(1, "testcache");
        AssertJUnit.assertNull((String)"Should be null", (Object)cache1.get((Object)this.k));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get((Object)this.k));
        TransactionManager mgr = TestingUtil.getTransactionManager(cache1);
        mgr.begin();
        cache1.get((Object)this.k);
        mgr.commit();
        this.assertNotLocked(cache1.getName(), (Object)this.k);
        this.assertNotLocked(cache2.getName(), (Object)this.k);
        cache1.clear();
        cache2.clear();
    }

    public void testReplaceNonExistentKey() throws Exception {
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        Cache cache1 = this.cache(0, "testcache");
        Cache cache2 = this.cache(1, "testcache");
        TransactionManager mgr = TestingUtil.getTransactionManager(cache1);
        mgr.begin();
        Object old = cache1.replace((Object)this.k, (Object)"blah");
        boolean replaced = cache1.replace((Object)this.k, (Object)"Vladimir", (Object)"Blagojevic");
        assert (!replaced);
        AssertJUnit.assertNull((String)"Should be null", (Object)cache1.get((Object)this.k));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get((Object)this.k));
        mgr.commit();
        this.assertNotLocked(cache1.getName(), (Object)this.k);
        this.assertNotLocked(cache2.getName(), (Object)this.k);
        cache1.clear();
        cache2.clear();
    }

    private void testBasicOperationHelper(boolean useCommit) throws Exception {
        Cache cache1 = this.cache(0, "testcache");
        Cache cache2 = this.cache(1, "testcache");
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        AssertJUnit.assertNull((String)"Should be null", (Object)cache1.get((Object)this.k));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get((Object)this.k));
        String name = "Infinispan";
        TransactionManager mgr = TestingUtil.getTransactionManager(cache1);
        mgr.begin();
        cache1.put((Object)this.k, (Object)name);
        this.assertKeyLockedCorrectly(this.k, "testcache");
        String key2 = "name";
        cache1.put((Object)key2, (Object)"Vladimir");
        this.assertKeyLockedCorrectly(key2, "testcache");
        String key3 = "product";
        String key4 = "org";
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put(key3, "Infinispan");
        newMap.put(key4, "JBoss");
        cache1.putAll(newMap);
        this.assertLocked(this.getLockOwner(key3, "testcache"), (Object)key3);
        this.assertLocked(this.getLockOwner(key4, "testcache"), (Object)key4);
        if (useCommit) {
            mgr.commit();
        } else {
            mgr.rollback();
        }
        if (useCommit) {
            AssertJUnit.assertEquals((Object)name, (Object)cache1.get((Object)this.k));
            AssertJUnit.assertEquals((String)"Should have replicated", (Object)name, (Object)cache2.get((Object)this.k));
        } else {
            AssertJUnit.assertEquals(null, (Object)cache1.get((Object)this.k));
            AssertJUnit.assertEquals((String)"Should not have replicated", null, (Object)cache2.get((Object)this.k));
        }
        cache2.remove((Object)this.k);
        cache2.remove((Object)key2);
        cache2.remove((Object)key3);
        cache2.remove((Object)key4);
    }

    public void testSimpleCommit() throws Throwable {
        this.tm(0, "testcache").begin();
        this.cache(0, "testcache").put((Object)"k", (Object)"v");
        this.tm(0, "testcache").commit();
        AssertJUnit.assertEquals((Object)this.cache(0, "testcache").get((Object)"k"), (Object)"v");
        AssertJUnit.assertEquals((Object)this.cache(1, "testcache").get((Object)"k"), (Object)"v");
        this.assertNotLocked("testcache", (Object)"k");
        this.tm(0, "testcache").begin();
        this.cache(0, "testcache").put((Object)"k", (Object)"v");
        this.cache(0, "testcache").remove((Object)"k");
        this.tm(0, "testcache").commit();
        AssertJUnit.assertEquals((Object)this.cache(0, "testcache").get((Object)"k"), null);
        AssertJUnit.assertEquals((Object)this.cache(1, "testcache").get((Object)"k"), null);
        this.assertNotLocked("testcache", (Object)"k");
    }

    public void testSimpleRollabck() throws Throwable {
        this.tm(0, "testcache").begin();
        this.cache(0, "testcache").put((Object)"k", (Object)"v");
        this.tm(0, "testcache").rollback();
        assert (!this.lockManager(1, "testcache").isLocked((Object)"k"));
        AssertJUnit.assertEquals((Object)this.cache(0, "testcache").get((Object)"k"), null);
        AssertJUnit.assertEquals((Object)this.cache(1, "testcache").get((Object)"k"), null);
        assert (!this.lockManager(0, "testcache").isLocked((Object)"k"));
    }

    @Test
    public void testRemoteLocksReleasedWhenReadTransactionCommitted() throws Exception {
        this.testRemoteLocksReleased(false, true);
    }

    @Test
    public void testRemoteLocksReleasedWhenReadTransactionRolledBack() throws Exception {
        this.testRemoteLocksReleased(false, false);
    }

    @Test
    public void testRemoteLocksReleasedWhenWriteTransactionCommitted() throws Exception {
        this.testRemoteLocksReleased(true, true);
    }

    @Test
    public void testRemoteLocksReleasedWhenWriteTransactionRolledBack() throws Exception {
        this.testRemoteLocksReleased(true, false);
    }

    private void testRemoteLocksReleased(boolean write, boolean commit) throws Exception {
        final MagicKey key = new MagicKey(this.cache(0, "testcache"));
        this.tm(1, "testcache").begin();
        if (write) {
            this.cache(1, "testcache").put((Object)key, (Object)"somevalue");
        } else {
            this.cache(1, "testcache").getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK).get((Object)key);
        }
        Collection localTxs = TestingUtil.getTransactionTable(this.cache(1, "testcache")).getLocalTransactions();
        AssertJUnit.assertEquals((int)1, (int)localTxs.size());
        LocalTransaction localTx = (LocalTransaction)localTxs.iterator().next();
        if (write) {
            AssertJUnit.assertFalse((boolean)localTx.isReadOnly());
        } else {
            Assert.assertTrue((boolean)localTx.isReadOnly());
        }
        final Collection remoteTxs = TestingUtil.getTransactionTable(this.cache(0, "testcache")).getRemoteTransactions();
        AssertJUnit.assertEquals((int)1, (int)remoteTxs.size());
        RemoteTransaction remoteTx = (RemoteTransaction)remoteTxs.iterator().next();
        Assert.assertTrue((boolean)remoteTx.getLockedKeys().contains(key));
        Assert.assertTrue((boolean)TestingUtil.extractLockManager(this.cache(0, "testcache")).isLocked((Object)key));
        if (commit) {
            this.tm(1, "testcache").commit();
        } else {
            this.tm(1, "testcache").rollback();
        }
        SyncPessimisticLockingTest.eventually(new AbstractInfinispanTest.Condition(){
            final /* synthetic */ SyncPessimisticLockingTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean isSatisfied() throws Exception {
                return remoteTxs.isEmpty();
            }
        });
        SyncPessimisticLockingTest.eventually(new AbstractInfinispanTest.Condition(){
            final /* synthetic */ SyncPessimisticLockingTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean isSatisfied() throws Exception {
                return !TestingUtil.extractLockManager(this.this$0.cache(0, "testcache")).isLocked((Object)key);
            }
        });
    }
}

