/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import jakarta.transaction.Transaction;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.transaction.LockingMode;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.FlagsReplicationTest")
public class FlagsReplicationTest
extends BaseDistFunctionalTest<Object, String> {
    static final String TEST_NAME = "replication.FlagsReplicationTest";
    static final String DATA_PROVIDER = "replication.FlagsReplicationTest.dataprovider";
    private final Integer one = 1;
    private final String key = "replication.FlagsReplicationTest";

    public FlagsReplicationTest() {
        this.transactional = true;
        this.cacheName = TEST_NAME;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
        this.lockingMode = LockingMode.PESSIMISTIC;
        this.lockTimeout = 1;
    }

    @DataProvider(name="replication.FlagsReplicationTest.dataprovider")
    public Object[][] createTestConfigurations() {
        return new Object[][]{{true, true}, {false, false}, {false, true}, {true, false}};
    }

    @Test(dataProvider="replication.FlagsReplicationTest.dataprovider")
    public void testScenario(boolean cache1IsOwner, boolean cache2IsOwner) throws Throwable {
        log.tracef("Start cache1IsOwner = %s, cache2IsOwner %s", (Object)cache1IsOwner, (Object)cache2IsOwner);
        AdvancedCache cache1 = (cache1IsOwner ? this.getFirstOwner(TEST_NAME) : this.getFirstNonOwner(TEST_NAME)).getAdvancedCache();
        AdvancedCache cache2 = (cache2IsOwner ? this.getFirstOwner(TEST_NAME) : this.getFirstNonOwner(TEST_NAME)).getAdvancedCache();
        AssertJUnit.assertNull((Object)cache1.put((Object)TEST_NAME, (Object)this.one));
        log.trace((Object)"About to try to acquire a lock.");
        cache2.getTransactionManager().begin();
        if (!cache2.lock(new Object[]{TEST_NAME})) {
            AssertJUnit.fail((String)"Could not acquire lock");
        }
        Transaction tx2 = cache2.getTransactionManager().suspend();
        cache1.getTransactionManager().begin();
        boolean locked = cache1.withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}).lock(new Object[]{TEST_NAME});
        AssertJUnit.assertFalse((boolean)locked);
        Object removed = cache1.withFlags(Flag.SKIP_LOCKING).remove((Object)TEST_NAME);
        AssertJUnit.assertEquals((Object)this.one, (Object)removed);
        Transaction tx1 = cache1.getTransactionManager().suspend();
        cache2.getTransactionManager().resume(tx2);
        cache2.getTransactionManager().commit();
        cache1.getTransactionManager().resume(tx1);
        cache1.getTransactionManager().commit();
        AssertJUnit.assertNull((Object)cache2.get((Object)TEST_NAME));
        log.tracef("End cache1IsOwner = %s, cache2IsOwner %s", (Object)cache1IsOwner, (Object)cache2IsOwner);
    }
}

