/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.lambda.NamedLambdas;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.distribution.BaseDistStoreTest;
import org.infinispan.persistence.sifs.Compactor;
import org.infinispan.persistence.sifs.Index;
import org.infinispan.persistence.sifs.IndexRequest;
import org.infinispan.persistence.sifs.NonBlockingSoftIndexFileStore;
import org.infinispan.persistence.sifs.SoftIndexFileStoreTestUtils;
import org.infinispan.persistence.sifs.configuration.DataConfiguration;
import org.infinispan.persistence.support.WaitDelegatingNonBlockingStore;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.Mocks;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.mockito.ArgumentMatchers;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.sifs.SoftIndexFileStoreRestartTest")
public class SoftIndexFileStoreRestartTest
extends BaseDistStoreTest<Integer, String, SoftIndexFileStoreRestartTest> {
    protected String tmpDirectory;
    protected int fileSize;
    protected boolean hasPassivation;

    public SoftIndexFileStoreRestartTest() {
        this.INIT_CLUSTER_SIZE = 1;
        this.l1CacheEnabled = false;
        this.segmented = true;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    SoftIndexFileStoreRestartTest fileSize(int fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    SoftIndexFileStoreRestartTest hasPassivation(boolean passivation) {
        this.hasPassivation = passivation;
        return this;
    }

    @Override
    public Object[] factory() {
        return Stream.of(CacheMode.DIST_SYNC, CacheMode.LOCAL).flatMap(type -> Stream.of(Boolean.TRUE, Boolean.FALSE).flatMap(hasPassivation -> Stream.builder().add(new SoftIndexFileStoreRestartTest().hasPassivation((boolean)hasPassivation).fileSize(1000).cacheMode((CacheMode)type)).add(new SoftIndexFileStoreRestartTest().hasPassivation((boolean)hasPassivation).fileSize(10000).cacheMode((CacheMode)type)).add(new SoftIndexFileStoreRestartTest().hasPassivation((boolean)hasPassivation).fileSize(320000).cacheMode((CacheMode)type)).add(new SoftIndexFileStoreRestartTest().hasPassivation((boolean)hasPassivation).fileSize(2000000).cacheMode((CacheMode)type)).add(new SoftIndexFileStoreRestartTest().hasPassivation((boolean)hasPassivation).fileSize((Integer)DataConfiguration.MAX_FILE_SIZE.getDefaultValue()).cacheMode((CacheMode)type)).build())).toArray();
    }

    @Override
    protected String[] parameterNames() {
        return SoftIndexFileStoreRestartTest.concat(super.parameterNames(), "fileSize", "hasPassivation");
    }

    @Override
    protected Object[] parameterValues() {
        return SoftIndexFileStoreRestartTest.concat(super.parameterValues(), this.fileSize, this.hasPassivation);
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() throws Throwable {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
        super.createBeforeClass();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        super.destroy();
        if (this.cleanup == AbstractCacheTest.CleanupPhase.AFTER_TEST) {
            Util.recursiveFileRemove((String)this.tmpDirectory);
        }
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        super.clearContent();
        if (this.cleanup == AbstractCacheTest.CleanupPhase.AFTER_METHOD) {
            Util.recursiveFileRemove((String)this.tmpDirectory);
        }
    }

    @Override
    protected StoreConfigurationBuilder addStore(PersistenceConfigurationBuilder persistenceConfigurationBuilder, boolean shared) {
        assert (!shared);
        persistenceConfigurationBuilder.passivation(this.hasPassivation);
        return persistenceConfigurationBuilder.addSoftIndexFileStore().maxFileSize(this.fileSize).dataLocation(Paths.get(this.tmpDirectory, "data").toString()).indexLocation(Paths.get(this.tmpDirectory, "index").toString());
    }

    public void testRestartWithNoIndex() throws Throwable {
        int i;
        int size = 10;
        for (i = 0; i < size; ++i) {
            this.cache(0, this.cacheName).put((Object)i, (Object)("value-" + i));
        }
        AssertJUnit.assertEquals((int)size, (int)this.cache(0, this.cacheName).size());
        this.cache(0, this.cacheName).remove((Object)4);
        this.killMember(0, this.cacheName);
        Util.recursiveFileRemove((Path)Paths.get(this.tmpDirectory, "index"));
        this.createCacheManagers();
        AssertJUnit.assertEquals((int)(size - 1), (int)this.cache(0, this.cacheName).size());
        for (i = 0; i < size; ++i) {
            if (i == 4) {
                AssertJUnit.assertNull((Object)this.cache(0, this.cacheName).get((Object)i));
                continue;
            }
            AssertJUnit.assertEquals((Object)("value-" + i), (Object)this.cache(0, this.cacheName).get((Object)i));
        }
    }

    static <K, V> NonBlockingSoftIndexFileStore<K, V> getStoreFromCache(Cache<K, V> cache) {
        WaitDelegatingNonBlockingStore<K, V> storeDel = TestingUtil.getFirstStoreWait(cache);
        return (NonBlockingSoftIndexFileStore)storeDel.delegate();
    }

    @DataProvider(name="restart")
    Object[][] restartProvider() {
        return new Object[][]{{NamedLambdas.of((String)"DELETE", () -> {
            Path path = Path.of(this.tmpDirectory, "index", this.cacheName, "index", "index.stats");
            path.toFile().delete();
        })}, {NamedLambdas.of((String)"NO-DELETE", () -> {})}};
    }

    @Test(dataProvider="restart")
    public void testStatsUponRestart(Runnable runnable) throws Throwable {
        int attempts = 5;
        long previousSize = -1L;
        for (int i = 0; i < attempts; ++i) {
            previousSize = this.performRestart(runnable, previousSize, i);
        }
    }

    long performRestart(Runnable runnable, long previousUsedSize, int iterationCount) throws Throwable {
        log.tracef("Iteration: %s", iterationCount);
        int size = 10;
        Cache cache = this.cache(0, this.cacheName);
        for (int i = 0; i < size; ++i) {
            if (iterationCount > 0 && i == iterationCount) continue;
            String prev = (String)cache.put((Object)i, (Object)("iteration-" + iterationCount + " value-" + i));
            if (iterationCount <= 0) continue;
            AssertJUnit.assertNotNull((Object)prev);
            int offset = iterationCount > 1 && iterationCount == i + 1 ? 2 : 1;
            AssertJUnit.assertEquals((String)("iteration-" + (iterationCount - offset) + " value-" + i), (String)prev);
        }
        AssertJUnit.assertEquals((int)size, (int)cache.size());
        this.killMember(0, this.cacheName);
        long actualSize = SoftIndexFileStoreTestUtils.dataDirectorySize(this.tmpDirectory, this.cacheName);
        SoftIndexFileStoreTestUtils.StatsValue stats = SoftIndexFileStoreTestUtils.readStatsFile(this.tmpDirectory, this.cacheName, log);
        AssertJUnit.assertEquals((long)actualSize, (long)stats.getStatsSize());
        if (previousUsedSize >= 0L) {
            AssertJUnit.assertEquals((String)("Restart attempt: " + iterationCount), (long)previousUsedSize, (long)(actualSize - stats.getFreeSize()));
        }
        runnable.run();
        this.createCacheManagers();
        return actualSize - stats.getFreeSize();
    }

    @DataProvider(name="booleans")
    Object[][] booleans() {
        return new Object[][]{{Boolean.TRUE}, {Boolean.FALSE}};
    }

    @Test(dataProvider="booleans")
    public void testRestartWithEntryUpdatedMultipleTimes(boolean leafOrNode) throws Throwable {
        int i;
        int size = 20;
        String key = "compaction";
        int extraInserts = leafOrNode ? size : size * 256;
        for (i = 0; i < extraInserts; ++i) {
            this.cache(0, this.cacheName).put((Object)i, (Object)("value-" + i));
        }
        for (i = 0; i < size; ++i) {
            this.cache(0, this.cacheName).put((Object)key, (Object)("value-" + i));
        }
        AssertJUnit.assertEquals((int)(extraInserts + 1), (int)this.cache(0, this.cacheName).size());
        this.cache(0, this.cacheName).remove((Object)3);
        this.killMember(0, this.cacheName);
        long actualSize = SoftIndexFileStoreTestUtils.dataDirectorySize(this.tmpDirectory, this.cacheName);
        SoftIndexFileStoreTestUtils.StatsValue stats = SoftIndexFileStoreTestUtils.readStatsFile(this.tmpDirectory, this.cacheName, log);
        AssertJUnit.assertEquals((long)actualSize, (long)stats.getStatsSize());
        this.createCacheManagers();
        AssertJUnit.assertEquals((Object)("value-" + (size - 1)), (Object)this.cache(0, this.cacheName).get((Object)key));
        WaitDelegatingNonBlockingStore store = TestingUtil.getFirstStoreWait(this.cache(0, this.cacheName));
        Compactor compactor = (Compactor)TestingUtil.extractField(store.delegate(), "compactor");
        compactor.forceCompactionForAllNonLogFiles().toCompletableFuture().get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)("value-" + (size - 1)), (Object)this.cache(0, this.cacheName).get((Object)key));
        this.killMember(0, this.cacheName);
        actualSize = SoftIndexFileStoreTestUtils.dataDirectorySize(this.tmpDirectory, this.cacheName);
        stats = SoftIndexFileStoreTestUtils.readStatsFile(this.tmpDirectory, this.cacheName, log);
        AssertJUnit.assertEquals((long)actualSize, (long)stats.getStatsSize());
        this.createCacheManagers();
    }

    @Test(dataProvider="booleans")
    public void testRestartSameKey(boolean deleteIndex) throws Throwable {
        int size = 20;
        for (int i = 0; i < size; ++i) {
            this.cache(0, this.cacheName).put((Object)"same-key", (Object)("value-" + i));
        }
        this.killMember(0, this.cacheName);
        if (deleteIndex) {
            Util.recursiveFileRemove((Path)Paths.get(this.tmpDirectory, "index"));
        }
        this.createCacheManagers();
    }

    public void testRestartCompactorNotComplete() throws Throwable {
        File[] dataFiles;
        ConcurrentMap stats;
        if (this.fileSize > 320000) {
            return;
        }
        WaitDelegatingNonBlockingStore store = TestingUtil.getFirstStoreWait(this.cache(0, this.cacheName));
        Compactor compactor = (Compactor)TestingUtil.extractField(store.delegate(), "compactor");
        CheckPoint checkPoint = new CheckPoint();
        checkPoint.triggerForever("after_release");
        Mocks.blockingFieldMock(checkPoint, Index.class, compactor, Compactor.class, "index", (stubber, index) -> ((Index)stubber.when(index)).handleRequest((IndexRequest)ArgumentMatchers.any()), new Class[0]);
        this.cache(0, this.cacheName).remove((Object)"removed-key");
        int size = 0;
        while ((stats = compactor.getFileStats()).isEmpty()) {
            this.cache(0, this.cacheName).remove((Object)("key-" + size));
            this.cache(0, this.cacheName).put((Object)("key-" + size), (Object)("value-" + size));
            ++size;
        }
        Integer fileId = (Integer)stats.keySet().iterator().next();
        CompletionStage compactorStage = compactor.forceCompactionForAllNonLogFiles();
        checkPoint.awaitStrict("before_invocation", 10L, TimeUnit.SECONDS);
        Future<Void> killFuture = this.fork(() -> this.killMember(0, this.cacheName));
        checkPoint.triggerForever("before_release");
        compactorStage.toCompletableFuture().get(10L, TimeUnit.SECONDS);
        killFuture.get(10L, TimeUnit.SECONDS);
        this.createCacheManagers();
        Path dataPath = Path.of(this.tmpDirectory, "data", this.cacheName, "data");
        for (File file : dataFiles = dataPath.toFile().listFiles()) {
            if (!file.getName().equals("ispn12." + fileId)) continue;
            AssertJUnit.fail((String)("File " + fileId + " that was compacted is still present!"));
        }
        AssertJUnit.assertNull((Object)this.cache(0, this.cacheName).get((Object)"removed-key"));
        for (int i = 0; i < size; ++i) {
            AssertJUnit.assertEquals((Object)("value-" + i), (Object)this.cache(0, this.cacheName).get((Object)("key-" + i)));
        }
    }
}

