/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.sifs.Compactor;
import org.infinispan.persistence.sifs.EntryPosition;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.NonBlockingSoftIndexFileStore;
import org.infinispan.persistence.sifs.SoftIndexFileStoreTestUtils;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.infinispan.persistence.support.WaitDelegatingNonBlockingStore;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.BlockingManagerTestUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.sifs.SoftIndexFileStoreFileStatsTest")
public class SoftIndexFileStoreFileStatsTest
extends SingleCacheManagerTest {
    protected String tmpDirectory;

    @BeforeClass(alwaysRun=true)
    protected void setUpTempDir() {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroyAfterClass() {
        super.destroyAfterClass();
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.globalState().persistentLocation(CommonsTestingUtil.tmpDirectory(this.getClass()));
        return TestCacheManagerFactory.newDefaultCacheManager(true, global, new ConfigurationBuilder());
    }

    protected PersistenceConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder persistence) {
        ((SoftIndexFileStoreConfigurationBuilder)persistence.addSoftIndexFileStore().dataLocation(Paths.get(this.tmpDirectory, "data").toString()).indexLocation(Paths.get(this.tmpDirectory, "index").toString()).maxFileSize(1000).purgeOnStartup(false)).expiration().wakeUpInterval(Long.MAX_VALUE);
        return persistence;
    }

    void configureCache(String cacheName) {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        this.createCacheStoreConfig(cb.persistence());
        TestingUtil.defineConfiguration(this.cacheManager, cacheName, cb.build());
    }

    ControlledTimeService defineCacheConfigurationAndInjectTimeService(String cacheName) {
        this.configureCache(cacheName);
        ControlledTimeService controlledTimeService = new ControlledTimeService();
        TimeService prev = (TimeService)TestingUtil.replaceComponent((CacheContainer)this.cacheManager, TimeService.class, controlledTimeService, true);
        controlledTimeService.setActualTimeService(prev);
        return controlledTimeService;
    }

    Map.Entry<Integer, Compactor.Stats> extractCompletedStat(ConcurrentMap<Integer, Compactor.Stats> statsMap) {
        return statsMap.entrySet().stream().filter(e -> ((Compactor.Stats)e.getValue()).isCompleted()).findFirst().orElse(null);
    }

    @Test(dataProvider="booleans")
    public void testOverwriteLogFileSize(Method m, boolean performExpirationAfterFirst) throws InterruptedException {
        String cacheName = m.getName() + "-" + performExpirationAfterFirst;
        this.configureCache(cacheName);
        BlockingManagerTestUtil.replaceManagersWithInline((CacheContainer)this.cacheManager);
        Cache cache = this.cacheManager.getCache(cacheName);
        cache.start();
        WaitDelegatingNonBlockingStore store = TestingUtil.getFirstStoreWait(cache);
        Compactor compactor = (Compactor)TestingUtil.extractField(store.delegate(), "compactor");
        ConcurrentMap statsMap = compactor.getFileStats();
        cache.put((Object)"k1", (Object)"v1");
        cache.put((Object)"k1", (Object)"v1");
        if (performExpirationAfterFirst) {
            MyCompactionObserver myCompactionObserver = new MyCompactionObserver(new ArrayBlockingQueue<Object>(5));
            compactor.performExpirationCompaction((Compactor.CompactionExpirationSubscriber)myCompactionObserver);
            myCompactionObserver.waitForCompletion();
        }
        AssertJUnit.assertEquals((int)1, (int)statsMap.size());
        Map.Entry entry = statsMap.entrySet().iterator().next();
        int maxInserts = 100;
        int insertions = 0;
        while (statsMap.containsKey(entry.getKey())) {
            cache.put((Object)"k1", (Object)"v1");
            if (++insertions != maxInserts) continue;
            AssertJUnit.fail((String)("Failed to remove stats map after " + maxInserts + " stats were: " + String.valueOf(statsMap)));
        }
    }

    @DataProvider(name="booleans")
    public static Object[][] booleans() {
        return new Object[][]{{Boolean.FALSE}, {Boolean.TRUE}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="booleans")
    public void testExpirationStats(Method m, boolean extraRemovedEntry) throws InterruptedException {
        String cacheName = m.getName() + "-" + extraRemovedEntry;
        ControlledTimeService controlledTimeService = this.defineCacheConfigurationAndInjectTimeService(cacheName);
        BlockingManagerTestUtil.replaceManagersWithInline((CacheContainer)this.cacheManager);
        try {
            Map.Entry<Integer, Compactor.Stats> entry;
            Cache cache = this.cacheManager.getCache(cacheName);
            cache.start();
            WaitDelegatingNonBlockingStore store = TestingUtil.getFirstStoreWait(cache);
            Compactor compactor = (Compactor)TestingUtil.extractField(store.delegate(), "compactor");
            ConcurrentMap statsMap = compactor.getFileStats();
            cache.put((Object)"k1", (Object)"v1", 3L, TimeUnit.MILLISECONDS);
            long expectedExpirationTime = controlledTimeService.wallClockTime() + 3L;
            AssertJUnit.assertEquals((int)0, (int)statsMap.size());
            if (extraRemovedEntry) {
                cache.put((Object)"removed", (Object)"remove-me");
                cache.remove((Object)"removed");
                AssertJUnit.assertEquals((int)1, (int)statsMap.size());
                Compactor.Stats stat = (Compactor.Stats)statsMap.values().iterator().next();
                int freeAmount = stat.getFree();
                AssertJUnit.assertTrue((String)"Something should have been freed", (freeAmount != 0 ? 1 : 0) != 0);
            }
            controlledTimeService.advance(4L);
            ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(10);
            MyCompactionObserver myCompactionObserver = new MyCompactionObserver(queue);
            compactor.performExpirationCompaction((Compactor.CompactionExpirationSubscriber)myCompactionObserver);
            myCompactionObserver.waitForCompletion();
            AssertJUnit.assertEquals((int)1, (int)queue.size());
            AssertJUnit.assertEquals((int)1, (int)statsMap.size());
            Compactor.Stats stat = (Compactor.Stats)statsMap.values().iterator().next();
            int freeAmount = stat.getFree();
            AssertJUnit.assertTrue((String)"Something should have been freed", (freeAmount != 0 ? 1 : 0) != 0);
            int i = 1;
            while ((entry = this.extractCompletedStat(statsMap)) == null) {
                cache.put((Object)("k" + i), (Object)("v" + i), 4L, TimeUnit.MILLISECONDS);
                if (++i <= 100) continue;
                AssertJUnit.fail((String)"Shouldn't require 100 iterations...");
            }
            Compactor.Stats completedStats = entry.getValue();
            AssertJUnit.assertTrue((String)("Stats were: " + String.valueOf(completedStats)), (completedStats.getFree() > 0 ? 1 : 0) != 0);
            AssertJUnit.assertEquals((long)expectedExpirationTime, (long)completedStats.getNextExpirationTime());
            AssertJUnit.assertFalse((boolean)completedStats.isScheduled());
            for (int j = 1; j < i; ++j) {
                cache.remove((Object)("k" + j));
                if (statsMap.containsKey(entry.getKey())) continue;
                completedStats = null;
                break;
            }
            AssertJUnit.assertNull((String)("File " + String.valueOf(entry.getKey()) + " was still not removed... stats were: " + String.valueOf(statsMap)), (Object)completedStats);
        }
        finally {
            TestingUtil.replaceComponent((CacheContainer)this.cacheManager, TimeService.class, controlledTimeService.getActualTimeService(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExpirationCompactionOnLogFile(Method m) throws InterruptedException {
        String cacheName = m.getName();
        ControlledTimeService controlledTimeService = this.defineCacheConfigurationAndInjectTimeService(cacheName);
        try {
            Cache cache = this.cacheManager.getCache(cacheName);
            cache.start();
            cache.put((Object)"expired", (Object)"bar", 10L, TimeUnit.SECONDS);
            cache.put((Object)"replace-me", (Object)"1");
            controlledTimeService.advance(TimeUnit.SECONDS.toMillis(11L));
            NonBlockingSoftIndexFileStore store = (NonBlockingSoftIndexFileStore)TestingUtil.getFirstStore(cache);
            Compactor compactor = (Compactor)TestingUtil.extractField(store, "compactor");
            SynchronousQueue<Object> queue = new SynchronousQueue<Object>();
            MyCompactionObserver myCompactionObserver = new MyCompactionObserver(queue);
            compactor.performExpirationCompaction((Compactor.CompactionExpirationSubscriber)myCompactionObserver);
            int increment = 2;
            ConcurrentMap fileStats = compactor.getFileStats();
            while (this.extractCompletedStat(fileStats) == null) {
                cache.put((Object)"replace-me", (Object)String.valueOf(increment++));
            }
            AssertJUnit.assertNotNull((Object)queue.poll(10L, TimeUnit.SECONDS));
            SoftIndexFileStoreFileStatsTest.eventually(() -> "File stats are: " + String.valueOf(fileStats) + " and data directory size is: " + SoftIndexFileStoreTestUtils.dataDirectorySize(this.tmpDirectory, cacheName), () -> SoftIndexFileStoreTestUtils.dataDirectorySize(this.tmpDirectory, cacheName) < 1000L);
        }
        finally {
            TestingUtil.replaceComponent((CacheContainer)this.cacheManager, TimeService.class, controlledTimeService.getActualTimeService(), true);
        }
    }

    static class MyCompactionObserver
    implements Compactor.CompactionExpirationSubscriber {
        private final BlockingQueue<Object> syncQueue;
        private final CountDownLatch completionLatch = new CountDownLatch(1);
        private volatile Throwable error;

        MyCompactionObserver(BlockingQueue<Object> syncQueue) {
            this.syncQueue = syncQueue;
        }

        public void onEntryPosition(EntryPosition entryPosition) throws IOException {
            try {
                log.trace((Object)("EntryPosition found: " + String.valueOf(entryPosition)));
                if (!this.syncQueue.offer(entryPosition, 10L, TimeUnit.SECONDS)) {
                    AssertJUnit.fail((String)"Queue did not accept offer of an EntryPosition!");
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        public void onEntryEntryRecord(EntryRecord entryRecord) throws IOException {
            try {
                log.trace((Object)("EntryRecord found: " + String.valueOf(entryRecord)));
                if (!this.syncQueue.offer(entryRecord, 10L, TimeUnit.SECONDS)) {
                    AssertJUnit.fail((String)"Queue did not accept offer of an EntryRecord!");
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        public void onComplete() {
            log.trace((Object)"Expiration compaction completed");
            this.completionLatch.countDown();
        }

        public void onError(Throwable t) {
            log.warn((Object)"Throwable encountered: ", t);
            this.error = t;
            this.completionLatch.countDown();
        }

        void waitForCompletion() throws InterruptedException {
            AssertJUnit.assertTrue((boolean)this.completionLatch.await(10L, TimeUnit.SECONDS));
            if (this.error != null) {
                throw new AssertionError((Object)this.error);
            }
        }
    }
}

