/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.TestAddress;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHashFactory;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.AvailabilityStrategyContext;
import org.infinispan.partitionhandling.impl.PreferAvailabilityStrategy;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.ClusterTopologyManagerImpl;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.topology.PersistentUUIDManagerImpl;
import org.infinispan.topology.TestClusterCacheStatus;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.TestingEventLogManager;
import org.mockito.Mockito;
import org.mockito.MockitoSession;
import org.mockito.quality.Strictness;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="partitionhandling.impl.PreferAvailabilityStrategyTest")
public class PreferAvailabilityStrategyTest
extends AbstractInfinispanTest {
    private final ConflictResolution conflicts;
    private static final CacheJoinInfo DIST_INFO = new CacheJoinInfo((ConsistentHashFactory)new DefaultConsistentHashFactory(), 8, 2, 1000L, CacheMode.DIST_SYNC, 1.0f, null, Optional.empty());
    private static final CacheJoinInfo REPL_INFO = new CacheJoinInfo((ConsistentHashFactory)new DefaultConsistentHashFactory(), 8, 2, 1000L, CacheMode.REPL_SYNC, 1.0f, null, Optional.empty());
    private static final Address A = new TestAddress(1, "A");
    private static final Address B = new TestAddress(2, "B");
    private static final Address C = new TestAddress(3, "C");
    private static final Address D = new TestAddress(4, "D");
    public static final String CACHE_NAME = "test";
    private EventLogManager eventLogManager;
    private PersistentUUIDManagerImpl persistentUUIDManager;
    private AvailabilityStrategyContext context;
    private PreferAvailabilityStrategy strategy;
    private MockitoSession mockitoSession;

    @DataProvider
    public static Object[][] conflictResolutionProvider() {
        return new Object[][]{{ConflictResolution.RESOLVE}, {ConflictResolution.IGNORE}};
    }

    @Factory(dataProvider="conflictResolutionProvider")
    public PreferAvailabilityStrategyTest(ConflictResolution conflicts) {
        this.conflicts = conflicts;
    }

    @BeforeMethod(alwaysRun=true)
    public void setup() {
        this.mockitoSession = Mockito.mockitoSession().strictness(Strictness.STRICT_STUBS).startMocking();
        this.persistentUUIDManager = new PersistentUUIDManagerImpl();
        this.eventLogManager = new TestingEventLogManager();
        this.context = (AvailabilityStrategyContext)Mockito.mock(AvailabilityStrategyContext.class);
        this.persistentUUIDManager.addPersistentAddressMapping(A, TestClusterCacheStatus.persistentUUID(A));
        this.persistentUUIDManager.addPersistentAddressMapping(B, TestClusterCacheStatus.persistentUUID(B));
        this.persistentUUIDManager.addPersistentAddressMapping(C, TestClusterCacheStatus.persistentUUID(C));
        this.persistentUUIDManager.addPersistentAddressMapping(D, TestClusterCacheStatus.persistentUUID(D));
        this.strategy = new PreferAvailabilityStrategy(this.eventLogManager, (PersistentUUIDManager)this.persistentUUIDManager, ClusterTopologyManagerImpl::distLostDataCheck);
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() {
        this.mockitoSession.finishMocking();
    }

    public void testSinglePartitionOnlyJoiners() {
        List<Address> joiners = Arrays.asList(A, B);
        CacheStatusResponse response = new CacheStatusResponse(DIST_INFO, null, null, AvailabilityMode.AVAILABLE, joiners);
        Map statusResponses = TestingUtil.mapOf(A, response, B, response);
        Mockito.when((Object)this.context.getCacheName()).thenReturn((Object)CACHE_NAME);
        Mockito.when((Object)this.context.getExpectedMembers()).thenReturn(joiners);
        this.strategy.onPartitionMerge(this.context, statusResponses);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateCurrentTopology(joiners);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueRebalance(joiners);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.context});
    }

    public void testSinglePartitionJoinersAndMissingNode() {
        List<Address> mergeMembers = Arrays.asList(B, C);
        TestClusterCacheStatus cacheA = TestClusterCacheStatus.start(DIST_INFO, A);
        CacheStatusResponse responseB = this.availableResponse(B, cacheA);
        CacheStatusResponse responseC = new CacheStatusResponse(DIST_INFO, null, null, AvailabilityMode.AVAILABLE, List.of(B));
        Map statusResponses = TestingUtil.mapOf(B, responseB, C, responseC);
        Mockito.when((Object)this.context.getCacheName()).thenReturn((Object)CACHE_NAME);
        Mockito.when((Object)this.context.getExpectedMembers()).thenReturn(mergeMembers);
        this.strategy.onPartitionMerge(this.context, statusResponses);
        TestClusterCacheStatus expectedCache = cacheA.copy();
        expectedCache.incrementIds();
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateCurrentTopology(mergeMembers);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueRebalance(mergeMembers);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.context});
    }

    public void testSinglePartitionTopologyNotUpdatedAfterLeave() {
        List<Address> remainingMembers = Arrays.asList(B, C);
        TestClusterCacheStatus cacheABC = TestClusterCacheStatus.start(DIST_INFO, A, B, C);
        CacheStatusResponse responseB = this.availableResponse(B, cacheABC);
        CacheStatusResponse responseC = this.availableResponse(C, cacheABC);
        Map statusResponses = TestingUtil.mapOf(B, responseB, C, responseC);
        Mockito.when((Object)this.context.getExpectedMembers()).thenReturn(remainingMembers);
        Mockito.when((Object)this.context.getCacheName()).thenReturn((Object)CACHE_NAME);
        this.strategy.onPartitionMerge(this.context, statusResponses);
        TestClusterCacheStatus expectedCache = cacheABC.copy();
        expectedCache.updateActualMembers(B, C);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateTopologiesAfterMerge(expectedCache.topology(), expectedCache.stableTopology(), null);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateCurrentTopology(remainingMembers);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueRebalance(remainingMembers);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.context});
    }

    public void testSinglePartitionTopologyPartiallyUpdatedAfterLeave() {
        List<Address> remainingMembers = Arrays.asList(B, C);
        TestClusterCacheStatus cacheAB = TestClusterCacheStatus.start(DIST_INFO, A, B, C);
        TestClusterCacheStatus cacheC = cacheAB.copy();
        cacheC.removeMembers(A);
        CacheStatusResponse responseB = this.availableResponse(B, cacheAB);
        CacheStatusResponse responseC = this.availableResponse(C, cacheC);
        Map statusResponses = TestingUtil.mapOf(B, responseB, C, responseC);
        Mockito.when((Object)this.context.getExpectedMembers()).thenReturn(remainingMembers);
        Mockito.when((Object)this.context.getCacheName()).thenReturn((Object)CACHE_NAME);
        this.strategy.onPartitionMerge(this.context, statusResponses);
        TestClusterCacheStatus expectedCache = cacheC.copy();
        expectedCache.incrementIds();
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateTopologiesAfterMerge(expectedCache.topology(), expectedCache.stableTopology(), null);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueRebalance(remainingMembers);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.context});
    }

    public void testSinglePartitionLeaveDuringRebalancePhaseReadOld() {
        List<Address> remainingMembers = Arrays.asList(B, C);
        TestClusterCacheStatus cacheAB = TestClusterCacheStatus.start(DIST_INFO, A, B);
        TestClusterCacheStatus cacheC = cacheAB.copy();
        cacheC.startRebalance(CacheTopology.Phase.READ_OLD_WRITE_ALL, A, B, C);
        cacheC.removeMembers(A);
        CacheStatusResponse responseB = this.availableResponse(B, cacheAB);
        CacheStatusResponse responseC = this.availableResponse(C, cacheC);
        Map statusResponses = TestingUtil.mapOf(B, responseB, C, responseC);
        Mockito.when((Object)this.context.getExpectedMembers()).thenReturn(remainingMembers);
        Mockito.when((Object)this.context.getCacheName()).thenReturn((Object)CACHE_NAME);
        this.strategy.onPartitionMerge(this.context, statusResponses);
        TestClusterCacheStatus expectedCache = cacheC.copy();
        expectedCache.cancelRebalance();
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateTopologiesAfterMerge(expectedCache.topology(), expectedCache.stableTopology(), null);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueRebalance(remainingMembers);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.context});
    }

    public void testSinglePartitionRepl2LeaveDuringRebalancePhaseReadOld() {
        List<Address> remainingMembers = Arrays.asList(C, D);
        TestClusterCacheStatus cacheAB = TestClusterCacheStatus.start(REPL_INFO, A, B);
        TestClusterCacheStatus cacheD = cacheAB.copy();
        cacheD.startRebalance(CacheTopology.Phase.READ_OLD_WRITE_ALL, A, B, C, D);
        TestClusterCacheStatus cacheC = cacheD.copy();
        cacheC.removeMembers(B);
        cacheC.removeMembers(A);
        cacheC.finishRebalance();
        cacheC.updateStableTopology();
        CacheStatusResponse responseC = this.availableResponse(C, cacheC);
        CacheStatusResponse responseD = this.availableResponse(D, cacheD);
        Map statusResponses = TestingUtil.mapOf(C, responseC, D, responseD);
        Mockito.when((Object)this.context.getExpectedMembers()).thenReturn(remainingMembers);
        Mockito.when((Object)this.context.getCacheName()).thenReturn((Object)CACHE_NAME);
        Mockito.when((Object)this.context.resolveConflictsOnMerge()).thenReturn((Object)this.conflicts.resolve());
        if (this.conflicts.resolve()) {
            Mockito.when((Object)this.context.calculateConflictHash(cacheC.readConsistentHash(), TestingUtil.setOf(cacheC.readConsistentHash(), cacheD.readConsistentHash()), remainingMembers)).thenReturn((Object)TestClusterCacheStatus.conflictResolutionConsistentHash(cacheC, cacheD));
        }
        this.strategy.onPartitionMerge(this.context, statusResponses);
        TestClusterCacheStatus expectedCache = cacheC.copy();
        if (this.conflicts.resolve()) {
            expectedCache.startConflictResolution(TestClusterCacheStatus.conflictResolutionConsistentHash(cacheC, cacheD), C, D);
        } else {
            expectedCache.incrementIds();
        }
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateTopologiesAfterMerge(expectedCache.topology(), expectedCache.stableTopology(), null);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateCurrentTopology(remainingMembers);
        if (this.conflicts.resolve()) {
            ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueConflictResolution(expectedCache.topology(), TestingUtil.setOf(C, D));
        } else {
            ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueRebalance(remainingMembers);
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.context});
    }

    public void testSinglePartitionLeaveDuringRebalancePhaseReadNew() {
        List<Address> mergeMembers = Arrays.asList(B, C);
        TestClusterCacheStatus cacheA = TestClusterCacheStatus.start(DIST_INFO, A, B);
        cacheA.startRebalance(CacheTopology.Phase.READ_OLD_WRITE_ALL, A, B, C);
        cacheA.advanceRebalance(CacheTopology.Phase.READ_ALL_WRITE_ALL);
        TestClusterCacheStatus cacheC = cacheA.copy();
        cacheC.removeMembers(A);
        cacheC.advanceRebalance(CacheTopology.Phase.READ_NEW_WRITE_ALL);
        CacheStatusResponse responseB = this.availableResponse(B, cacheA);
        CacheStatusResponse responseC = this.availableResponse(C, cacheC);
        Map statusResponses = TestingUtil.mapOf(B, responseB, C, responseC);
        Mockito.when((Object)this.context.getExpectedMembers()).thenReturn(mergeMembers);
        Mockito.when((Object)this.context.getCacheName()).thenReturn((Object)CACHE_NAME);
        this.strategy.onPartitionMerge(this.context, statusResponses);
        TestClusterCacheStatus expectedCache = cacheC.copy();
        expectedCache.cancelRebalance();
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateTopologiesAfterMerge(expectedCache.topology(), expectedCache.stableTopology(), null);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueRebalance(mergeMembers);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.context});
    }

    public void testSinglePartitionOneNodeSplits() {
        TestClusterCacheStatus cacheABC = TestClusterCacheStatus.start(DIST_INFO, A, B, C);
        List<Address> remainingMembers = Collections.singletonList(C);
        CacheStatusResponse responseC = this.availableResponse(C, cacheABC);
        Map statusResponses = TestingUtil.mapOf(C, responseC);
        Mockito.when((Object)this.context.getExpectedMembers()).thenReturn(remainingMembers);
        Mockito.when((Object)this.context.getCacheName()).thenReturn((Object)CACHE_NAME);
        this.strategy.onPartitionMerge(this.context, statusResponses);
        TestClusterCacheStatus expectedCache = cacheABC.copy();
        expectedCache.updateActualMembers(C);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateTopologiesAfterMerge(expectedCache.topology(), expectedCache.stableTopology(), null);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateCurrentTopology(remainingMembers);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueRebalance(remainingMembers);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.context});
    }

    public void testMerge1Paused2Rebalancing() {
        List<Address> mergeMembers = Arrays.asList(A, B, C);
        TestClusterCacheStatus cacheA = TestClusterCacheStatus.start(DIST_INFO, A, B, C);
        TestClusterCacheStatus cacheB = cacheA.copy();
        cacheB.removeMembers(A);
        cacheB.startRebalance(CacheTopology.Phase.READ_OLD_WRITE_ALL, B, C);
        TestClusterCacheStatus cacheC = cacheB.copy();
        cacheC.advanceRebalance(CacheTopology.Phase.READ_ALL_WRITE_ALL);
        CacheStatusResponse responseA = this.availableResponse(A, cacheA);
        CacheStatusResponse responseB = this.availableResponse(B, cacheB);
        CacheStatusResponse responseC = this.availableResponse(C, cacheC);
        Map statusResponses = TestingUtil.mapOf(A, responseA, B, responseB, C, responseC);
        Mockito.when((Object)this.context.getExpectedMembers()).thenReturn(mergeMembers);
        Mockito.when((Object)this.context.getCacheName()).thenReturn((Object)CACHE_NAME);
        this.strategy.onPartitionMerge(this.context, statusResponses);
        TestClusterCacheStatus expectedCache = cacheC.copy();
        expectedCache.cancelRebalance();
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateTopologiesAfterMerge(expectedCache.topology(), expectedCache.stableTopology(), null);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueRebalance(mergeMembers);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.context});
    }

    public void testMerge1Paused2StableAfterRebalance() {
        List<Address> mergeMembers = Arrays.asList(A, B, C);
        TestClusterCacheStatus cacheA = TestClusterCacheStatus.start(DIST_INFO, A, B, C);
        TestClusterCacheStatus cacheBC = cacheA.copy();
        cacheBC.removeMembers(A);
        cacheBC.startRebalance(CacheTopology.Phase.READ_OLD_WRITE_ALL, B, C);
        cacheBC.advanceRebalance(CacheTopology.Phase.READ_ALL_WRITE_ALL);
        cacheBC.finishRebalance();
        cacheBC.updateStableTopology();
        CacheStatusResponse responseA = this.availableResponse(A, cacheA);
        CacheStatusResponse responseB = this.availableResponse(B, cacheBC);
        CacheStatusResponse responseC = this.availableResponse(C, cacheBC);
        Map statusResponses = TestingUtil.mapOf(A, responseA, B, responseB, C, responseC);
        Mockito.when((Object)this.context.getExpectedMembers()).thenReturn(mergeMembers);
        Mockito.when((Object)this.context.getCacheName()).thenReturn((Object)CACHE_NAME);
        this.strategy.onPartitionMerge(this.context, statusResponses);
        TestClusterCacheStatus expectedCache = cacheBC.copy();
        expectedCache.incrementIds();
        expectedCache.incrementIdsIfNeeded(cacheA);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateTopologiesAfterMerge(expectedCache.topology(), expectedCache.stableTopology(), null);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueRebalance(mergeMembers);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.context});
    }

    public void testMerge1Paused2StableNoRebalance() {
        List<Address> mergeMembers = Arrays.asList(A, B);
        TestClusterCacheStatus cacheA = TestClusterCacheStatus.start(DIST_INFO, A, B);
        TestClusterCacheStatus cacheB = cacheA.copy();
        cacheB.removeMembers(A);
        cacheB.updateStableTopology();
        CacheStatusResponse responseA = this.availableResponse(A, cacheA);
        CacheStatusResponse responseB = this.availableResponse(B, cacheB);
        Map statusResponses = TestingUtil.mapOf(A, responseA, B, responseB);
        Mockito.when((Object)this.context.getExpectedMembers()).thenReturn(mergeMembers);
        Mockito.when((Object)this.context.getCacheName()).thenReturn((Object)CACHE_NAME);
        this.strategy.onPartitionMerge(this.context, statusResponses);
        TestClusterCacheStatus expectedCache = cacheB.copy();
        expectedCache.incrementIds();
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateTopologiesAfterMerge(expectedCache.topology(), expectedCache.stableTopology(), null);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueRebalance(mergeMembers);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.context});
    }

    public void testMerge1Paused2StableAfterLosingAnotherNode() {
        List<Address> mergeMembers = Arrays.asList(A, C);
        TestClusterCacheStatus cacheA = TestClusterCacheStatus.start(DIST_INFO, A, B, C);
        TestClusterCacheStatus cacheB = cacheA.copy();
        cacheB.removeMembers(A);
        cacheB.startRebalance(CacheTopology.Phase.READ_OLD_WRITE_ALL, B, C);
        cacheB.advanceRebalance(CacheTopology.Phase.READ_ALL_WRITE_ALL);
        cacheB.finishRebalance();
        cacheB.updateStableTopology();
        TestClusterCacheStatus cacheC = cacheB.copy();
        cacheC.removeMembers(B);
        cacheC.updateStableTopology();
        CacheStatusResponse responseA = this.availableResponse(A, cacheA);
        CacheStatusResponse responseC = this.availableResponse(C, cacheC);
        Map statusResponses = TestingUtil.mapOf(A, responseA, C, responseC);
        Mockito.when((Object)this.context.getExpectedMembers()).thenReturn(mergeMembers);
        Mockito.when((Object)this.context.getCacheName()).thenReturn((Object)CACHE_NAME);
        Mockito.when((Object)this.context.resolveConflictsOnMerge()).thenReturn((Object)this.conflicts.resolve());
        if (this.conflicts.resolve()) {
            Mockito.when((Object)this.context.calculateConflictHash(cacheC.readConsistentHash(), TestingUtil.setOf(cacheA.readConsistentHash(), cacheC.readConsistentHash()), mergeMembers)).thenReturn((Object)TestClusterCacheStatus.conflictResolutionConsistentHash(cacheC, cacheA));
        }
        this.strategy.onPartitionMerge(this.context, statusResponses);
        TestClusterCacheStatus expectedCache = cacheC.copy();
        if (this.conflicts.resolve()) {
            expectedCache.startConflictResolution(TestClusterCacheStatus.conflictResolutionConsistentHash(cacheC, cacheA), A, C);
        }
        expectedCache.incrementIdsIfNeeded(cacheC);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateTopologiesAfterMerge(expectedCache.topology(), expectedCache.stableTopology(), null);
        if (!this.conflicts.resolve()) {
            ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateCurrentTopology(Collections.singletonList(C));
            ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueRebalance(mergeMembers);
        } else {
            ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateCurrentTopology(mergeMembers);
            ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueConflictResolution(expectedCache.topology(), TestingUtil.setOf(C));
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.context});
    }

    public void testMerge1HigherTopologyId2MoreNodesSameStableTopology() {
        List<Address> mergeMembers = Arrays.asList(A, B, C);
        TestClusterCacheStatus cacheA = TestClusterCacheStatus.start(DIST_INFO, A, B, C);
        TestClusterCacheStatus cacheBC = cacheA.copy();
        cacheA.removeMembers(B);
        cacheA.removeMembers(C);
        cacheBC.removeMembers(A);
        CacheStatusResponse responseA = this.availableResponse(A, cacheA);
        CacheStatusResponse responseB = this.availableResponse(B, cacheBC);
        CacheStatusResponse responseC = this.availableResponse(C, cacheBC);
        Map statusResponses = TestingUtil.mapOf(A, responseA, B, responseB, C, responseC);
        AssertJUnit.assertTrue((cacheA.topology().getTopologyId() > cacheBC.topology().getTopologyId() ? 1 : 0) != 0);
        AssertJUnit.assertSame((Object)cacheA.stableTopology(), (Object)cacheBC.stableTopology());
        Mockito.when((Object)this.context.getExpectedMembers()).thenReturn(mergeMembers);
        Mockito.when((Object)this.context.resolveConflictsOnMerge()).thenReturn((Object)this.conflicts.resolve());
        Mockito.when((Object)this.context.getCacheName()).thenReturn((Object)CACHE_NAME);
        if (this.conflicts.resolve()) {
            Mockito.when((Object)this.context.calculateConflictHash(cacheBC.readConsistentHash(), TestingUtil.setOf(cacheA.readConsistentHash(), cacheBC.readConsistentHash()), mergeMembers)).thenReturn((Object)TestClusterCacheStatus.conflictResolutionConsistentHash(cacheA, cacheBC));
        }
        this.strategy.onPartitionMerge(this.context, statusResponses);
        TestClusterCacheStatus expectedCache = cacheBC.copy();
        if (this.conflicts.resolve()) {
            expectedCache.startConflictResolution(TestClusterCacheStatus.conflictResolutionConsistentHash(cacheA, cacheBC), A, B, C);
        } else {
            expectedCache.incrementIds();
        }
        expectedCache.incrementIdsIfNeeded(cacheA);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateTopologiesAfterMerge(expectedCache.topology(), expectedCache.stableTopology(), null);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateCurrentTopology(expectedCache.topology().getMembers());
        if (!this.conflicts.resolve()) {
            ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueRebalance(mergeMembers);
        } else {
            ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueConflictResolution(expectedCache.topology(), TestingUtil.setOf(B, C));
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.context});
    }

    public void testMerge1HigherTopologyId2MoreNodesIndependentStableTopology() {
        List<Address> mergeMembers = Arrays.asList(A, B, C);
        TestClusterCacheStatus cacheA = TestClusterCacheStatus.start(DIST_INFO, A);
        cacheA.incrementIds();
        TestClusterCacheStatus cacheBC = TestClusterCacheStatus.start(DIST_INFO, B, C);
        CacheStatusResponse responseA = this.availableResponse(A, cacheA);
        CacheStatusResponse responseB = this.availableResponse(B, cacheBC);
        CacheStatusResponse responseC = this.availableResponse(C, cacheBC);
        Map statusResponses = TestingUtil.mapOf(A, responseA, B, responseB, C, responseC);
        AssertJUnit.assertTrue((cacheA.topology().getTopologyId() > cacheBC.topology().getTopologyId() ? 1 : 0) != 0);
        Mockito.when((Object)this.context.getExpectedMembers()).thenReturn(mergeMembers);
        Mockito.when((Object)this.context.resolveConflictsOnMerge()).thenReturn((Object)this.conflicts.resolve());
        Mockito.when((Object)this.context.getCacheName()).thenReturn((Object)CACHE_NAME);
        if (this.conflicts.resolve()) {
            Mockito.when((Object)this.context.calculateConflictHash(cacheBC.readConsistentHash(), TestingUtil.setOf(cacheA.readConsistentHash(), cacheBC.readConsistentHash()), mergeMembers)).thenReturn((Object)TestClusterCacheStatus.conflictResolutionConsistentHash(cacheA, cacheBC));
        }
        this.strategy.onPartitionMerge(this.context, statusResponses);
        TestClusterCacheStatus expectedCache = cacheBC.copy();
        if (this.conflicts.resolve()) {
            expectedCache.startConflictResolution(TestClusterCacheStatus.conflictResolutionConsistentHash(cacheA, cacheBC), A, B, C);
        } else {
            expectedCache.incrementIds();
        }
        expectedCache.incrementIdsIfNeeded(cacheA);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateTopologiesAfterMerge(expectedCache.topology(), expectedCache.stableTopology(), null);
        ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).updateCurrentTopology(expectedCache.topology().getMembers());
        if (!this.conflicts.resolve()) {
            ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueRebalance(mergeMembers);
        } else {
            ((AvailabilityStrategyContext)Mockito.verify((Object)this.context)).queueConflictResolution(expectedCache.topology(), TestingUtil.setOf(B, C));
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.context});
    }

    private CacheStatusResponse availableResponse(Address a, TestClusterCacheStatus cacheStatus) {
        return new CacheStatusResponse(cacheStatus.joinInfo(a), cacheStatus.topology(), cacheStatus.stableTopology(), AvailabilityMode.AVAILABLE, Arrays.asList(A, B, C));
    }

    @Override
    protected String parameters() {
        return "[" + String.valueOf((Object)this.conflicts) + "]";
    }

    public static enum ConflictResolution {
        RESOLVE,
        IGNORE;


        boolean resolve() {
            return this == RESOLVE;
        }
    }
}

